/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.audio.AudioException;
import ch.laoe.clip.AClip;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GClipFrame;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GLaoeTheme;
import ch.laoe.ui.GMainFrame;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GProgressViewer;
import ch.laoe.ui.GStartWindow;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.GUserInstaller;
import ch.oli4.io.CommandLineParser;
import ch.oli4.ui.UiLFTheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFrame;

public class Laoe {
    private static Laoe instance = null;
    public static final String version = "0.7.02";
    public static final String date = "04-09-2010";
    public static final String copyright = "(c) 2000-2010 oli4 switzerland";
    public static final String eAddress = "www.oli4.ch/laoe";
    public static final String eMail = "laoe@oli4.ch";
    public static final String java = "java " + System.getProperty("java.version");
    public static final String os = System.getProperty("os.name");
    public static final String license = "GNU General Public License";
    private GPersistence persistance;
    private GStartWindow startWindow;
    private GPluginHandler pluginHandler;
    private GMainFrame mainFrame;
    private ArrayList clipFrames;
    private GClipFrame focussedClipFrame;
    private ArrayList visibleFrames;

    public static Laoe getInstance() {
        if (instance == null) {
            instance = new Laoe();
        }
        return instance;
    }

    private Laoe() {
        this(new String[0]);
    }

    private Laoe(String[] stringArray) {
        instance = this;
        CommandLineParser commandLineParser = new CommandLineParser(stringArray);
        if (commandLineParser.containsFlag("i")) {
            GUserInstaller.getInstance().forceInstallation();
        } else {
            GUserInstaller.getInstance().maybeInstall();
        }
        Locale.setDefault(Locale.US);
        String[] stringArray2 = commandLineParser.getArguments("f");
        String[] stringArray3 = commandLineParser.getArguments("l");
        String[] stringArray4 = commandLineParser.getArguments("d");
        if (commandLineParser.containsFlag("h")) {
            System.out.println("LAoE 0.7.02, 04-09-2010, (c) 2000-2010 oli4 switzerland");
            System.out.println("syntax: laoe -hvi [-d verboseLevel[,console]] [-l language] [-f [filename[,filename...]]]");
            System.out.println("  -h            print help information, then exit");
            System.out.println("  -v            print version, then exit");
            System.out.println("  -i            force beginning with installation-dialog, even if already installed");
            System.out.println("  verboseLevel  select the verbose level 0..9, the higher the verbose");
            System.out.println("  console       if the word \"console\" follows the verboseLevel, the debug-text is ");
            System.out.println("                printed to the console instead to the trace-file");
            System.out.println("  -d            verbose for debugging");
            System.out.println("  -l            language setting");
            System.out.println("  language      selected language [en | de | fr], default is english");
            System.out.println("  -f            open audiofiles on start");
            System.out.println("  filename      audiofilenames to open");
            System.out.println("LAoE is a graphic-layer based audiofile editor, implemented in java. ");
            System.out.println("homepage: www.oli4.ch/laoe");
            System.out.println("for questions and bugreport: laoe@oli4.ch");
            System.out.println("I hope you enjoy it !");
            System.out.println("oli4");
            System.exit(0);
        }
        if (commandLineParser.containsFlag("v")) {
            System.out.println(version);
            System.exit(0);
        }
        String string = GToolkit.getLaoeUserHomePath() + "laoe.properties";
        this.persistance = GPersistence.createPersistance(string);
        GLanguage.createLanguage("language");
        if (commandLineParser.containsFlag("l")) {
            GLanguage.setLanguage(stringArray3[0], "");
        }
        System.out.println("LAoE 0.7.02, 04-09-2010, (c) 2000-2010 oli4 switzerland");
        System.out.println("GNU General Public License, " + GLanguage.translate("<language>Version") + ", " + os + ", " + java);
        Debug.setTimeStampEnabled(true);
        if (commandLineParser.containsFlag("d")) {
            Debug.setVerboseLevel(Integer.parseInt(stringArray4[0]));
            if (stringArray4.length == 2) {
                if (!stringArray4[1].trim().equals("console")) {
                    Debug.setOutputFile(GToolkit.getLaoeUserHomePath() + "trace.txt");
                }
            } else {
                Debug.setOutputFile(GToolkit.getLaoeUserHomePath() + "trace.txt");
            }
        } else {
            Debug.setVerboseLevel(this.persistance.getInt("debug.verboseLevel"));
            Debug.setOutputFile(GToolkit.getLaoeUserHomePath() + "trace.txt");
        }
        Debug.println(3, "restore persistent objects");
        Debug.println(3, "load look and feel");
        UiLFTheme.load(new GLaoeTheme());
        this.startWindow = new GStartWindow();
        this.mainFrame = new GMainFrame();
        this.clipFrames = new ArrayList();
        this.visibleFrames = new ArrayList();
        this.pluginHandler = new GPluginHandler();
        this.mainFrame.setVisible(true);
        this.startWindow.setWorkInfo(GLanguage.translate("loadAudioFiles") + "...");
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.addClipFrame(new File(stringArray2[i]));
            }
        }
        this.startWindow.setWorkInfo(GLanguage.translate("ready") + " !");
        this.startWindow.onEndOfStart(3000);
    }

    public GStartWindow getStartWindow() {
        return this.startWindow;
    }

    public GPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public GMainFrame getMainFrame() {
        return this.mainFrame;
    }

    private void createClipFrame(AClip aClip) {
        Debug.println(3, "create clip frame " + aClip.getName());
        GClipFrame gClipFrame = new GClipFrame(aClip);
        if (this.getFocussedClipFrame() != null) {
            gClipFrame.setLocation(this.getFocussedClipFrame().getLocation().x + 30, this.getFocussedClipFrame().getLocation().y + 30);
        }
        this.clipFrames.add(gClipFrame);
        this.setFocussedClipFrame(gClipFrame);
        gClipFrame.setVisible(true);
    }

    public void addClipFrame(AClip aClip) {
        this.createClipFrame(aClip);
    }

    public void addClipFrame(File file) {
        try {
            GProgressViewer.entrySubProgress();
            GProgressViewer.setProgress(90);
            AClip aClip = new AClip(file);
            GProgressViewer.setProgress(100);
            this.createClipFrame(aClip);
            GProgressViewer.exitSubProgress();
        }
        catch (AudioException audioException) {
            GDialog.showErrorDialog(null, "audioError", audioException.getMessage());
        }
    }

    public void removeClipFrame(GClipFrame gClipFrame) {
        Debug.println(3, "remove clip frame " + gClipFrame.getClipEditor().getClip().getName());
        this.clipFrames.remove(gClipFrame);
        this.setFocussedClipFrame(new GClipFrame(new AClip(1, 1, 0)));
        System.gc();
    }

    public Object[] getAllClipFrames() {
        return this.clipFrames.toArray();
    }

    public void setFocussedClipFrame(GClipFrame gClipFrame) {
        this.focussedClipFrame = gClipFrame;
        if (gClipFrame != null) {
            this.pluginHandler.reloadAllPluginsAndFocussedClip(null);
        }
    }

    public GClipFrame getFocussedClipFrame() {
        return this.focussedClipFrame;
    }

    public GClipEditor getFocussedClipEditor() {
        if (this.focussedClipFrame != null) {
            return this.focussedClipFrame.getClipEditor();
        }
        return null;
    }

    public void iconifyAllFrames() {
        this.visibleFrames.clear();
        for (int i = 0; i < this.clipFrames.size(); ++i) {
            JFrame jFrame = (JFrame)this.clipFrames.get(i);
            if (jFrame.getState() != 0) continue;
            this.visibleFrames.add(jFrame);
            jFrame.setState(1);
        }
        this.getPluginHandler().iconifyAllFrames();
    }

    public void deiconifyAllFrames() {
        for (int i = 0; i < this.visibleFrames.size(); ++i) {
            JFrame jFrame = (JFrame)this.visibleFrames.get(i);
            jFrame.setState(0);
        }
        this.getPluginHandler().deiconifyAllFrames();
    }

    public static void main(String[] stringArray) {
        Laoe laoe = new Laoe(stringArray);
    }
}

