/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.ui.GToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GUserInstaller
implements ActionListener {
    private static GUserInstaller installer = null;
    private File dotLaoeDir = new File(GToolkit.getLaoeUserHomePath());
    private JFrame frame;
    private JButton installB;
    private JButton cancelB;
    private JLabel text;
    private static final int NO = 0;
    private static final int CANCEL = 1;
    private static final int INSTALL = 2;
    private int action = 0;

    private GUserInstaller() {
    }

    public static GUserInstaller getInstance() {
        if (installer == null) {
            installer = new GUserInstaller();
        }
        return installer;
    }

    public void maybeInstall() {
        if (this.dotLaoeDir.exists() && this.dotLaoeDir.isDirectory()) {
            return;
        }
        this.forceInstallation();
    }

    public void forceInstallation() {
        this.frame = new JFrame();
        URL uRL = this.getClass().getResource("laoe.gif");
        if (uRL != null) {
            this.frame.setIconImage(new ImageIcon(uRL).getImage());
        }
        this.frame.setTitle("LAoE installer");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.frame.getContentPane().add(jPanel);
        jPanel.add((Component)new JLabel(GToolkit.loadIcon(this, "installWindow")), "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel.add((Component)jPanel2, "South");
        this.text = new JLabel("", 0);
        this.text.setText("<html><body>do you want to install <font size=+1><b><i>LAoE</i></b></font> ?</body></html>");
        jPanel2.setBackground(Color.BLACK);
        this.text.setForeground(Color.WHITE);
        jPanel2.add(this.text);
        JPanel jPanel3 = new JPanel();
        FlowLayout flowLayout = new FlowLayout(1);
        jPanel3.setLayout(flowLayout);
        jPanel2.add(jPanel3);
        this.installB = new JButton("install now!");
        jPanel3.add(this.installB);
        this.cancelB = new JButton("cancel");
        jPanel3.add(this.cancelB);
        this.frame.pack();
        GToolkit.setFrameInMiddleOfScreen(this.frame);
        this.frame.setVisible(true);
        this.installB.addActionListener(this);
        this.cancelB.addActionListener(this);
        while (this.frame.isVisible()) {
            this.sleep(333);
            switch (this.action) {
                case 1: {
                    this.cancelNow();
                    System.exit(0);
                    break;
                }
                case 2: {
                    this.installNow();
                    this.frame.setVisible(false);
                }
            }
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.installB) {
            this.action = 2;
        } else if (actionEvent.getSource() == this.cancelB) {
            this.action = 1;
        }
    }

    private void installNow() {
        this.text.setText("create LAoE directory in home directory of " + System.getProperty("user.name") + "...");
        this.dotLaoeDir.mkdir();
        this.sleep(2000);
        this.text.setText("prepare the history...");
        this.copyDirectory("history");
        this.copyFile("history/read_me.txt");
        this.sleep(2000);
        this.text.setText("prepare the user settings...");
        this.copyFile("laoe.properties");
        this.sleep(2000);
        this.text.setText("successful installation of LAoE!");
        this.sleep(2000);
    }

    public void cancelNow() {
        this.text.setText("installation cancelled.");
        this.sleep(2000);
    }

    private void copyDirectory(String string) {
        File file = new File(GToolkit.getLaoeInstallationPath() + string);
        File file2 = new File(GToolkit.getLaoeUserHomePath() + string);
        if (file.exists() && file.isDirectory()) {
            file2.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string) {
        File file = new File(GToolkit.getLaoeInstallationPath() + string);
        File file2 = new File(GToolkit.getLaoeUserHomePath() + string);
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        if (file.exists() && file.isFile()) {
            try {
                fileInputStream = new FileInputStream(file);
                outputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

