/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPlugin;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GStatusBar
extends JPanel
implements MouseMotionListener,
ActionListener {
    private JLabel currentPlugin;
    private JLabel keyMouseHelp;
    private JLabel selectedLayer;
    private JLabel selectedChannel;
    private JLabel cursorPosition;
    private JButton xUnit;
    private JButton yUnit;
    private int xUnitIndex = 0;
    private int yUnitIndex = 0;

    public GStatusBar() {
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(this, 22, 1);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        uiCartesianLayout.setBorderGap(0.01f);
        uiCartesianLayout.setCellGap(0.01f);
        this.setLayout(uiCartesianLayout);
        Font font = new Font("Courrier", 0, 10);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 30));
        this.currentPlugin = new JLabel();
        this.currentPlugin.setFont(font);
        this.currentPlugin.setBorder(BorderFactory.createEtchedBorder());
        uiCartesianLayout.add(this.currentPlugin, 0, 0, 4, 1);
        this.keyMouseHelp = new JLabel();
        this.keyMouseHelp.setFont(font);
        this.keyMouseHelp.setBorder(BorderFactory.createEtchedBorder());
        uiCartesianLayout.add(this.keyMouseHelp, 4, 0, 6, 1);
        this.selectedLayer = new JLabel();
        this.selectedLayer.setFont(font);
        this.selectedLayer.setBorder(BorderFactory.createEtchedBorder());
        uiCartesianLayout.add(this.selectedLayer, 10, 0, 3, 1);
        this.selectedChannel = new JLabel();
        this.selectedChannel.setFont(font);
        this.selectedChannel.setBorder(BorderFactory.createEtchedBorder());
        uiCartesianLayout.add(this.selectedChannel, 13, 0, 3, 1);
        this.cursorPosition = new JLabel();
        this.cursorPosition.setFont(font);
        this.cursorPosition.setBorder(BorderFactory.createEtchedBorder());
        uiCartesianLayout.add(this.cursorPosition, 16, 0, 4, 1);
        this.xUnit = new JButton();
        this.xUnit.setFont(font);
        this.xUnit.setBorder(BorderFactory.createEtchedBorder());
        this.xUnit.addActionListener(this);
        uiCartesianLayout.add(this.xUnit, 20, 0, 1, 1);
        this.yUnit = new JButton();
        this.yUnit.setFont(font);
        this.yUnit.setBorder(BorderFactory.createEtchedBorder());
        this.yUnit.addActionListener(this);
        uiCartesianLayout.add(this.yUnit, 21, 0, 1, 1);
        this.update();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            this.calculateCursorPositions(mouseEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            this.calculateCursorPositions(mouseEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void calculateCursorPositions(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        AClip aClip = Laoe.getInstance().getFocussedClipEditor().getClip();
        AClipPlotter aClipPlotter = (AClipPlotter)aClip.getPlotter();
        ALayer aLayer = aClip.getSelectedLayer();
        int n = aLayer.getLayerPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        if (n >= 0) {
            object2 = aLayer.getChannel(n);
            object = ((AChannel)object2).getChannelPlotter();
            float f = ((AChannelPlotter)object).graphToSampleX(mouseEvent.getPoint().x);
            float f2 = ((AChannelPlotter)object).graphToSampleY(mouseEvent.getPoint().y);
            this.cursorPosition.setText("<html><b>" + GLanguage.translate("position") + "</b><br>" + aClipPlotter.toPlotterXUnit(f) + aClipPlotter.getPlotterXUnitName() + " / " + aClipPlotter.toPlotterYUnit(f2) + aClipPlotter.getPlotterYUnitName() + "</html>");
        }
        object2 = Laoe.getInstance().getPluginHandler().getFocussedPlugin();
        object = GLanguage.translate("mouse");
        if (GToolkit.isShiftKey(mouseEvent)) {
            object = (String)object + "+" + GLanguage.translate("shift");
        }
        if (GToolkit.isCtrlKey(mouseEvent)) {
            object = (String)object + "+" + GLanguage.translate("ctrl");
        }
        this.keyMouseHelp.setText("<html><b>" + (String)object + "</b><br>" + GLanguage.translate(((GPlugin)object2).getKeyMouseHelp(GToolkit.isShiftKey(mouseEvent), GToolkit.isCtrlKey(mouseEvent))) + "</html>");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.xUnit) {
            AClip aClip = Laoe.getInstance().getFocussedClipEditor().getClip();
            aClip.getClipPlotter().togglePlotterXUnit();
        } else if (actionEvent.getSource() == this.yUnit) {
            AClip aClip = Laoe.getInstance().getFocussedClipEditor().getClip();
            aClip.getClipPlotter().togglePlotterYUnit();
        }
        this.update();
        Laoe.getInstance().getFocussedClipEditor().reload();
    }

    public void update() {
        GPlugin gPlugin = Laoe.getInstance().getPluginHandler().getFocussedPlugin();
        if (gPlugin != null) {
            this.currentPlugin.setText("<html><b>" + GLanguage.translate("plugin") + "</b><br>" + GLanguage.translate(gPlugin.getName()) + "</html>");
        } else {
            this.currentPlugin.setText(GLanguage.translate("<html><b>" + GLanguage.translate("none") + "</b></html>"));
        }
        try {
            AClip aClip = Laoe.getInstance().getFocussedClipEditor().getClip();
            this.selectedLayer.setText("<html><b>" + GLanguage.translate("layer") + "</b><br>" + aClip.getSelectedLayer().getName() + "</html>");
            this.selectedChannel.setText("<html><b>" + GLanguage.translate("channel") + "</b><br>" + aClip.getSelectedLayer().getSelectedChannel().getName() + "</html>");
            this.xUnit.setText(aClip.getClipPlotter().getPlotterXUnitName());
            this.yUnit.setText(aClip.getClipPlotter().getPlotterYUnitName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

