/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class GSimpleColorChooser
extends JButton
implements MouseListener {
    private JFrame frame;
    private ColorPanel colorPanel;
    private Color selectedColor;

    public GSimpleColorChooser(String string, String string2) {
        super(string);
        this.frame = new JFrame(string2);
        this.colorPanel = new ColorPanel(this);
        this.frame.getContentPane().add(this.colorPanel);
        this.frame.setResizable(false);
        this.frame.pack();
        this.selectedColor = Color.BLUE;
        this.addMouseListener(this);
        this.setBackground(this.selectedColor);
        this.setEnabled(false);
    }

    private void updateRootComponent(boolean bl) {
        this.frame.setVisible(false);
        this.setBackground(this.selectedColor);
        this.validate();
        if (bl) {
            this.fireActionPerformed(new ActionEvent(this, 0, "color chosen"));
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
        this.updateRootComponent(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.frame.setLocationRelativeTo(this);
        this.frame.setVisible(true);
    }

    private class ColorPanel
    extends JLabel
    implements MouseListener {
        private GSimpleColorChooser chooser;

        public ColorPanel(GSimpleColorChooser gSimpleColorChooser2) {
            this.chooser = gSimpleColorChooser2;
            this.setPreferredSize(new Dimension(222, 222));
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = 64;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    float f = (float)i / (float)n;
                    float f2 = (float)j / (float)n;
                    graphics.setColor(new Color(this.coordToRgb(f, f2)));
                    graphics.fillRect(this.getWidth() * i / n, this.getHeight() * j / n, this.getWidth() / n + 1, this.getHeight() / n + 1);
                }
            }
        }

        public int coordToRgb(float f, float f2) {
            int n = ((int)Math.max(0.0f, f * 255.0f * 2.0f - 255.0f) << 8) + ((int)Math.max(0.0f, f * -255.0f * 2.0f + 255.0f) << 0) + ((int)(f2 * 255.0f) << 16);
            return n;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.chooser.selectedColor = new Color(this.coordToRgb((float)mouseEvent.getX() / (float)this.getWidth(), (float)mouseEvent.getY() / (float)this.getHeight()));
            this.chooser.updateRootComponent(true);
        }
    }
}

