/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.ui.GToolkit;
import ch.oli4.io.XmlInputStream;
import ch.oli4.io.XmlOutputStream;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GGraphicObjects {
    private static final String nameSpace = "graphicObjects";
    private List grObjects;
    private GrObject currentObject = null;
    private Cursor penCursor;
    private Cursor eraseCursor;
    private Cursor textCursor;
    private Cursor actualCursor;
    private Color currentColor = Color.DARK_GRAY;
    private Stroke currentStroke = new BasicStroke();
    private AChannel channel;
    private AChannelPlotter channelPlotter;
    private int operation;
    public static final int NO = 0;
    public static final int DRAW_LINE = 1;
    public static final int DRAW_RECTANGLE = 2;
    public static final int DRAW_TEXT = 3;
    public static final int ERASE = 4;
    private String currentText = "";
    private int oldDraggedX = 0;
    private int oldDraggedY = 0;

    public GGraphicObjects() {
        this.initCursors();
        this.initOperation();
        this.initGeometry();
    }

    public GGraphicObjects(GGraphicObjects gGraphicObjects) {
        this();
        Iterator iterator = gGraphicObjects.grObjects.iterator();
        while (iterator.hasNext()) {
            this.grObjects.add(iterator.next());
        }
    }

    private static void xmlAppendPointElement(XmlOutputStream xmlOutputStream, GrPoint grPoint) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("x", Float.toString(grPoint.x));
        hashMap.put("y", Float.toString(grPoint.y));
        xmlOutputStream.appendBeginEndTag("graphicObjects.point", hashMap);
    }

    public void toXmlElement(XmlOutputStream xmlOutputStream) throws IOException {
        xmlOutputStream.appendBeginTag(nameSpace, new HashMap());
        xmlOutputStream.appendCR();
        for (GrObject grObject : this.grObjects) {
            Object object;
            GrObject grObject2;
            if (grObject instanceof GrPoint) {
                xmlOutputStream.appendTab(1);
                GGraphicObjects.xmlAppendPointElement(xmlOutputStream, (GrPoint)grObject);
                xmlOutputStream.appendCR();
                continue;
            }
            if (grObject instanceof GrRectangle) {
                grObject2 = (GrRectangle)grObject;
                xmlOutputStream.appendTab(1);
                xmlOutputStream.appendBeginTag("graphicObjects.rectangle", new HashMap());
                xmlOutputStream.appendCR();
                xmlOutputStream.appendTab(2);
                GGraphicObjects.xmlAppendPointElement(xmlOutputStream, grObject2.p1);
                xmlOutputStream.appendCR();
                xmlOutputStream.appendTab(2);
                GGraphicObjects.xmlAppendPointElement(xmlOutputStream, grObject2.p2);
                xmlOutputStream.appendCR();
                xmlOutputStream.appendTab(1);
                xmlOutputStream.appendEndTag("graphicObjects.rectangle");
                xmlOutputStream.appendCR();
                continue;
            }
            if (grObject instanceof GrLine) {
                grObject2 = (GrLine)grObject;
                xmlOutputStream.appendTab(1);
                xmlOutputStream.appendBeginTag("graphicObjects.line", new HashMap());
                xmlOutputStream.appendCR();
                object = ((GrLine)grObject2).points.iterator();
                while (object.hasNext()) {
                    xmlOutputStream.appendTab(2);
                    GGraphicObjects.xmlAppendPointElement(xmlOutputStream, (GrPoint)object.next());
                    xmlOutputStream.appendCR();
                }
                xmlOutputStream.appendTab(1);
                xmlOutputStream.appendEndTag("graphicObjects.line");
                xmlOutputStream.appendCR();
                continue;
            }
            if (!(grObject instanceof GrText)) continue;
            grObject2 = (GrText)grObject;
            xmlOutputStream.appendTab(1);
            object = new HashMap<String, String>();
            ((HashMap)object).put("text", ((GrText)grObject2).text);
            xmlOutputStream.appendBeginTag("graphicObjects.text", (HashMap)object);
            xmlOutputStream.appendCR();
            xmlOutputStream.appendTab(2);
            GGraphicObjects.xmlAppendPointElement(xmlOutputStream, ((GrText)grObject2).point);
            xmlOutputStream.appendCR();
            xmlOutputStream.appendTab(1);
            xmlOutputStream.appendEndTag("graphicObjects.text");
            xmlOutputStream.appendCR();
        }
        xmlOutputStream.appendEndTag(nameSpace);
        xmlOutputStream.appendCR();
    }

    public void fromXmlElement(XmlInputStream xmlInputStream) throws IOException {
        GrObject grObject = null;
        boolean bl = false;
        while (true) {
            int n = xmlInputStream.read();
            switch (n) {
                case 5: {
                    if (!xmlInputStream.getTagName().equals("graphicObjects.point")) break;
                    GrPoint grPoint = new GrPoint();
                    grPoint.x = Float.parseFloat(xmlInputStream.getAttribute("x"));
                    grPoint.y = Float.parseFloat(xmlInputStream.getAttribute("y"));
                    if (bl) {
                        ((GrObject)grObject).setOrigin(grPoint);
                        bl = false;
                        break;
                    }
                    ((GrObject)grObject).setPoint(grPoint);
                    break;
                }
                case 3: {
                    bl = true;
                    if (xmlInputStream.getTagName().equals("graphicObjects.rectangle")) {
                        grObject = new GrRectangle();
                    } else if (xmlInputStream.getTagName().equals("graphicObjects.line")) {
                        grObject = new GrLine();
                    } else if (xmlInputStream.getTagName().equals("graphicObjects.text")) {
                        grObject = new GrText(xmlInputStream.getAttribute("text"));
                    }
                    this.grObjects.add(grObject);
                    break;
                }
                case 4: {
                    if (!xmlInputStream.getTagName().equals(nameSpace)) break;
                    return;
                }
                case -1: {
                    throw new IOException("unexpected EOF in middle of XML graphicObject structure");
                }
            }
        }
    }

    private void initGeometry() {
        this.grObjects = new ArrayList();
        this.currentObject = null;
    }

    private void initCursors() {
        this.penCursor = GToolkit.createCustomCursor(this, "penCursor");
        this.eraseCursor = GToolkit.createCustomCursor(this, "eraseCursor");
        this.textCursor = new Cursor(2);
        this.actualCursor = null;
    }

    public void setCurrentColor(Color color) {
        this.currentColor = color;
    }

    public void setCurrentStroke(Stroke stroke) {
        this.currentStroke = stroke;
    }

    public void setChannel(AChannel aChannel) {
        this.channel = aChannel;
        this.channelPlotter = aChannel.getChannelPlotter();
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.channel != null) {
            try {
                this.channelPlotter = this.channel.getChannelPlotter();
                graphics2D.setClip(this.channelPlotter.getRectangle());
                for (GrObject grObject : this.grObjects) {
                    if (grObject == null) continue;
                    grObject.paint(graphics2D);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initOperation() {
        this.operation = 0;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setCurrentText(String string) {
        this.currentText = string;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.channel != null) {
            this.channelPlotter = this.channel.getChannelPlotter();
            if (this.channelPlotter.isInsideChannel(mouseEvent.getPoint())) {
                float f = this.channelPlotter.graphToSampleX(mouseEvent.getX());
                float f2 = this.channelPlotter.graphToSampleY(mouseEvent.getY());
                switch (this.operation) {
                    case 1: {
                        this.currentObject = new GrLine();
                        this.currentObject.setOrigin(new GrPoint(f, f2));
                        this.currentObject.color = this.currentColor;
                        this.currentObject.stroke = this.currentStroke;
                        break;
                    }
                    case 2: {
                        this.currentObject = new GrRectangle();
                        this.currentObject.setOrigin(new GrPoint(f, f2));
                        this.currentObject.color = this.currentColor;
                        this.currentObject.stroke = this.currentStroke;
                        break;
                    }
                    case 3: {
                        this.currentObject = new GrText(this.currentText);
                        this.currentObject.setOrigin(new GrPoint(f, f2));
                        this.currentObject.color = this.currentColor;
                        this.currentObject.stroke = this.currentStroke;
                        break;
                    }
                    case 4: {
                        this.currentObject = new GrRectangle();
                        float[] fArray = new float[]{4.0f, 4.0f};
                        this.currentObject.setOrigin(new GrPoint(f, f2));
                        this.currentObject.color = Color.WHITE;
                        this.currentObject.stroke = new BasicStroke(1.0f, 2, 0, 1.0f, fArray, 0.0f);
                    }
                }
                this.grObjects.add(this.currentObject);
            } else {
                this.currentObject = null;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = null;
        switch (this.operation) {
            case 1: {
                cursor = this.penCursor;
                break;
            }
            case 2: {
                cursor = this.penCursor;
                break;
            }
            case 3: {
                cursor = this.textCursor;
                break;
            }
            case 4: {
                cursor = this.eraseCursor;
            }
        }
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.channel != null && this.currentObject != null && this.channelPlotter.isInsideChannel(mouseEvent.getPoint())) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n != this.oldDraggedX || n2 != this.oldDraggedY) {
                this.oldDraggedX = n;
                this.oldDraggedY = n2;
                switch (this.operation) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                if (!GToolkit.isShiftKey(mouseEvent) && !GToolkit.isCtrlKey(mouseEvent)) {
                    this.currentObject.setPoint(new GrPoint(this.channelPlotter.graphToSampleX(mouseEvent.getX()), this.channelPlotter.graphToSampleY(mouseEvent.getY())));
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.channel != null) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (this.operation) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    int n3 = this.grObjects.size();
                    for (int i = n3 - 1; i >= 0; --i) {
                        GrObject grObject = (GrObject)this.grObjects.get(i);
                        if (!grObject.isInside((GrRectangle)this.currentObject)) continue;
                        this.grObjects.remove(grObject);
                    }
                    this.grObjects.remove(this.currentObject);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.channelPlotter = this.channel.getChannelPlotter();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    private class GrText
    extends GrObject {
        private String text;
        private GrPoint point;

        public GrText(String string) {
            this.text = string;
        }

        public GrText(GrText grText) {
            super(grText);
            this.text = grText.text;
            this.point = new GrPoint(grText.point);
        }

        @Override
        public void setOrigin(GrPoint grPoint) {
            this.point = grPoint;
        }

        @Override
        public void setPoint(GrPoint grPoint) {
            this.point = grPoint;
        }

        @Override
        public boolean isInside(GrRectangle grRectangle) {
            return this.point.isInside(grRectangle);
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            graphics2D.setFont(new Font("Courrier", 0, 12));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(this.text, this.point.getGraphicX() - fontMetrics.stringWidth(this.text) / 2, this.point.getGraphicY() + fontMetrics.getAscent() - fontMetrics.getHeight() / 2);
        }
    }

    private class GrLine
    extends GrObject {
        private List points;

        public GrLine() {
            this.points = new ArrayList();
        }

        public GrLine(GrLine grLine) {
            super(grLine);
            this.points = new ArrayList();
            Iterator iterator = grLine.points.iterator();
            while (iterator.hasNext()) {
                this.points.add(new GrPoint((GrPoint)iterator.next()));
            }
        }

        @Override
        public void setOrigin(GrPoint grPoint) {
            this.points.add(grPoint);
        }

        @Override
        public void setPoint(GrPoint grPoint) {
            this.points.add(grPoint);
        }

        @Override
        public boolean isInside(GrRectangle grRectangle) {
            Iterator iterator = this.points.iterator();
            while (iterator.hasNext()) {
                if (((GrPoint)iterator.next()).isInside(grRectangle)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            Iterator iterator = this.points.iterator();
            GrPoint grPoint = null;
            while (iterator.hasNext()) {
                GrPoint grPoint2 = (GrPoint)iterator.next();
                if (grPoint != null) {
                    graphics2D.drawLine(grPoint.getGraphicX(), grPoint.getGraphicY(), grPoint2.getGraphicX(), grPoint2.getGraphicY());
                }
                grPoint = grPoint2;
            }
        }
    }

    private class GrRectangle
    extends GrObject {
        public GrPoint p1;
        public GrPoint p2;

        public GrRectangle() {
        }

        public GrRectangle(GrRectangle grRectangle) {
            super(grRectangle);
            this.p1 = new GrPoint(grRectangle.p1);
            this.p2 = new GrPoint(grRectangle.p2);
        }

        @Override
        public void setOrigin(GrPoint grPoint) {
            this.p1 = grPoint;
            this.p2 = grPoint;
        }

        @Override
        public void setPoint(GrPoint grPoint) {
            this.p2 = grPoint;
        }

        @Override
        public boolean isInside(GrRectangle grRectangle) {
            return this.p1.isInside(grRectangle) && this.p2.isInside(grRectangle);
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int n = this.p1.getGraphicX();
            int n2 = this.p1.getGraphicY();
            int n3 = this.p2.getGraphicX();
            int n4 = this.p2.getGraphicY();
            graphics2D.drawLine(n, n2, n, n4);
            graphics2D.drawLine(n, n2, n3, n2);
            graphics2D.drawLine(n3, n4, n, n4);
            graphics2D.drawLine(n3, n4, n3, n2);
        }
    }

    private class GrPoint
    extends GrObject {
        public float x;
        public float y;

        public GrPoint() {
        }

        public GrPoint(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public GrPoint(GrPoint grPoint) {
            super(grPoint);
            grPoint.x = this.x;
            grPoint.y = this.y;
        }

        public int getGraphicX() {
            return GGraphicObjects.this.channelPlotter.sampleToGraphX(this.x);
        }

        public int getGraphicY() {
            return GGraphicObjects.this.channelPlotter.sampleToGraphY(this.y);
        }

        @Override
        public void setOrigin(GrPoint grPoint) {
            this.x = grPoint.x;
            this.y = grPoint.y;
        }

        @Override
        public void setPoint(GrPoint grPoint) {
            this.setOrigin(grPoint);
        }

        @Override
        public boolean isInside(GrRectangle grRectangle) {
            int n;
            int n2 = grRectangle.p1.getGraphicX();
            int n3 = grRectangle.p1.getGraphicY();
            int n4 = grRectangle.p2.getGraphicX();
            int n5 = grRectangle.p2.getGraphicY();
            if (n4 < n2) {
                n = n4;
                n4 = n2;
                n2 = n;
            }
            if (n5 < n3) {
                n = n5;
                n5 = n3;
                n3 = n;
            }
            n = this.getGraphicX();
            int n6 = this.getGraphicY();
            return n >= n2 && n <= n4 && n6 >= n3 && n6 <= n5;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            graphics2D.drawLine(this.getGraphicX(), this.getGraphicY(), this.getGraphicX(), this.getGraphicY());
        }
    }

    private abstract class GrObject {
        public Color color;
        public Stroke stroke;

        public GrObject() {
            this.color = Color.DARK_GRAY;
            this.stroke = new BasicStroke();
        }

        public GrObject(GrObject grObject) {
            this.color = grObject.color;
            this.stroke = grObject.stroke;
        }

        public abstract void setOrigin(GrPoint var1);

        public abstract void setPoint(GrPoint var1);

        public abstract boolean isInside(GrRectangle var1);

        public void paint(Graphics2D graphics2D) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setColor(this.color);
            graphics2D.setStroke(this.stroke);
        }
    }
}

