/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSegmentGenerator;
import ch.laoe.operation.AOSpline;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class GEditableSegments {
    private Color color;
    private boolean pointsVisible = true;
    private boolean highlightActivePoint = true;
    private boolean editable = true;
    private int yDomain;
    public static final int SAMPLE_DOMAIN = 1;
    public static final int PERCENT_DOMAIN = 2;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private ArrayList segmentPoints = new ArrayList(25);
    private int activePointIndex;
    private FPoint selectedPoint;
    private FPoint leftPoint;
    private FPoint rightPoint;
    private AOSpline spline = AOToolkit.createSpline();
    private int actualOperation = 0;
    private static final int IDLE = 0;
    private static final int DRAW = 1;
    private static final int REMOVE = 2;
    private int segmentMode = 1;
    public static final int SINGLE_POINTS = -1;
    public static final int ORDER_0 = 0;
    public static final int ORDER_1 = 1;
    public static final int SPLINE = 4;
    private AChannel actualChannel;
    private AChannelPlotter actualChannelPlotter;
    private Rectangle actualChannelRect;
    private Cursor penCursor;
    private Cursor eraseCursor;
    private Cursor actualCursor;
    private MMArray x;
    private MMArray y;
    private Stroke segmentSroke = new BasicStroke();

    public GEditableSegments() {
        this.color = Color.yellow;
        this.setYDomain(1);
        this.clearXRange();
        this.clearYRange();
        this.penCursor = GToolkit.createCustomCursor(this, "penCursor");
        this.eraseCursor = GToolkit.createCustomCursor(this, "eraseCursor");
        this.actualCursor = this.penCursor;
    }

    public GEditableSegments(GEditableSegments gEditableSegments) {
        this();
        this.color = gEditableSegments.color;
        this.pointsVisible = gEditableSegments.pointsVisible;
        this.highlightActivePoint = gEditableSegments.highlightActivePoint;
        this.segmentMode = gEditableSegments.segmentMode;
        this.editable = gEditableSegments.editable;
        this.xMin = gEditableSegments.xMin;
        this.xMax = gEditableSegments.xMax;
        this.yMin = gEditableSegments.yMin;
        this.yMax = gEditableSegments.yMax;
        this.color = gEditableSegments.color;
        this.yDomain = gEditableSegments.yDomain;
        for (int i = 0; i < gEditableSegments.segmentPoints.size(); ++i) {
            this.segmentPoints.add(new FPoint((FPoint)gEditableSegments.segmentPoints.get(i)));
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPointsVisible(boolean bl) {
        this.pointsVisible = bl;
    }

    public void setHighlightActivePointEnabled(boolean bl) {
        this.highlightActivePoint = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setYDomain(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.yDomain = n;
                break;
            }
            default: {
                this.yDomain = 1;
            }
        }
    }

    public int getYDomain() {
        return this.yDomain;
    }

    public void setXRange(float f, float f2) {
        this.xMin = f;
        this.xMax = f + f2;
    }

    public void setYRange(float f, float f2) {
        this.yMin = f;
        this.yMax = f + f2;
    }

    public void clearXRange() {
        this.xMin = -3.4028235E38f;
        this.xMax = Float.MAX_VALUE;
    }

    public void clearYRange() {
        this.yMin = -3.4028235E38f;
        this.yMax = Float.MAX_VALUE;
    }

    public void setComplementary() {
        for (int i = 0; i < this.segmentPoints.size(); ++i) {
            FPoint fPoint = (FPoint)this.segmentPoints.get(i);
            fPoint.y = 1.0f - fPoint.y;
        }
    }

    public float getActivePointX() {
        try {
            return ((FPoint)this.segmentPoints.get((int)this.activePointIndex)).x;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public float getActivePointY() {
        try {
            return ((FPoint)this.segmentPoints.get((int)this.activePointIndex)).y;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void setSegmentMode(int n) {
        this.segmentMode = n;
    }

    public int getSegmentMode() {
        return this.segmentMode;
    }

    public void setChannel(AChannel aChannel) {
        this.actualChannel = aChannel;
        this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
    }

    private int searchNearest(FPoint fPoint) {
        float f = Float.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.segmentPoints.size(); ++i) {
            float f2 = fPoint.getGraphSquareDistance((FPoint)this.segmentPoints.get(i));
            if (!(f2 < f) || !(f2 < 400.0f)) continue;
            f = f2;
            n = i;
        }
        return n;
    }

    private int searchInsertIndex(FPoint fPoint) {
        for (int i = 0; i < this.segmentPoints.size(); ++i) {
            if (!(fPoint.x < ((FPoint)this.segmentPoints.get((int)i)).x)) continue;
            return i;
        }
        return this.segmentPoints.size();
    }

    public void clear() {
        this.segmentPoints.clear();
    }

    public int getNumberOfPoints() {
        return this.segmentPoints.size();
    }

    public void addPoint(float f, float f2) {
        this.segmentPoints.add(new FPoint(f, f2));
    }

    public float getPointX(int n) {
        return ((FPoint)this.segmentPoints.get((int)n)).x;
    }

    public float getPointY(int n) {
        return ((FPoint)this.segmentPoints.get((int)n)).y;
    }

    public void convertToSamples(int n) {
        if (this.segmentPoints.size() > 0) {
            MMArray mMArray = new MMArray(this.segmentPoints.size(), 0.0f);
            MMArray mMArray2 = new MMArray(mMArray.getLength(), 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, ((FPoint)this.segmentPoints.get((int)i)).x);
                mMArray2.set(i, ((FPoint)this.segmentPoints.get((int)i)).y);
            }
            AChannelSelection aChannelSelection = this.actualChannel.createChannelSelection();
            aChannelSelection.operateChannel(new AOSegmentGenerator(mMArray, mMArray2, this.segmentMode, n, true));
        }
    }

    public void convertToSelectedSamples(int n) {
        if (this.segmentPoints.size() > 0) {
            MMArray mMArray = new MMArray(this.segmentPoints.size(), 0.0f);
            MMArray mMArray2 = new MMArray(mMArray.getLength(), 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, ((FPoint)this.segmentPoints.get((int)i)).x);
                mMArray2.set(i, ((FPoint)this.segmentPoints.get((int)i)).y);
            }
            AChannelSelection aChannelSelection = this.actualChannel.getChannelSelection();
            aChannelSelection.operateChannel(new AOSegmentGenerator(mMArray, mMArray2, this.segmentMode, n, false));
        }
    }

    public void prepareResults() {
        this.x = new MMArray(this.segmentPoints.size(), 0.0f);
        this.y = new MMArray(this.segmentPoints.size(), 0.0f);
        for (int i = 0; i < this.x.getLength(); ++i) {
            this.x.set(i, ((FPoint)this.segmentPoints.get((int)i)).x);
            this.y.set(i, ((FPoint)this.segmentPoints.get((int)i)).y);
        }
        AOSpline aOSpline = AOToolkit.createSpline();
        aOSpline.load(this.x, this.y);
    }

    public float getSample(int n) {
        switch (this.segmentMode) {
            case -1: {
                for (int i = 0; i < this.x.getLength(); ++i) {
                    if (n != (int)this.x.get(i)) continue;
                    return this.y.get(i);
                }
                return 0.0f;
            }
            case 0: {
                return AOToolkit.interpolate0(this.x, this.y, n);
            }
            case 1: {
                return AOToolkit.interpolate1(this.x, this.y, n);
            }
            case 4: {
                return this.spline.getResult(n);
            }
        }
        return 0.0f;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            this.setXRange(this.actualChannelPlotter.getXOffset(), this.actualChannelPlotter.getXLength());
            this.actualOperation = 0;
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            this.actualOperation = GToolkit.isShiftKey(mouseEvent) ? 2 : 1;
            if (this.actualOperation == 1) {
                int n = this.searchNearest(fPoint);
                if (n >= 0) {
                    this.actualOperation = 1;
                    this.selectedPoint = (FPoint)this.segmentPoints.get(n);
                    this.leftPoint = n > 0 ? (FPoint)this.segmentPoints.get(n - 1) : null;
                    this.rightPoint = n < this.segmentPoints.size() - 1 ? (FPoint)this.segmentPoints.get(n + 1) : null;
                } else {
                    this.actualOperation = 0;
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        if (this.actualChannel != null && this.editable) {
            object = new FPoint();
            ((FPoint)object).toSampleDomain(mouseEvent.getPoint());
            ((FPoint)object).limitRange();
            this.activePointIndex = this.searchNearest((FPoint)object);
        }
        if ((object = GToolkit.isShiftKey(mouseEvent) ? this.eraseCursor : this.penCursor) != this.actualCursor) {
            this.actualCursor = object;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            if (this.actualOperation == 1) {
                this.selectedPoint.x = this.leftPoint != null && fPoint.x < this.leftPoint.x + 1.0f ? this.leftPoint.x + 1.0f : (this.rightPoint != null && fPoint.x > this.rightPoint.x - 1.0f ? this.rightPoint.x - 1.0f : fPoint.x);
                this.selectedPoint.y = GToolkit.isCtrlKey(mouseEvent) ? this.actualChannel.getSample((int)fPoint.x) : fPoint.y;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            switch (this.actualOperation) {
                case 0: 
                case 1: {
                    this.segmentPoints.add(this.searchInsertIndex(fPoint), fPoint);
                    break;
                }
                case 2: {
                    int n = this.searchNearest(fPoint);
                    if (n < 0) break;
                    this.segmentPoints.remove(n);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
            this.actualChannelRect = this.actualChannelPlotter.getRectangle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.actualChannel != null) {
            try {
                int n;
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                graphics2D.setStroke(this.segmentSroke);
                graphics2D.setColor(this.color);
                this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
                this.actualChannelRect = this.actualChannelPlotter.getRectangle();
                graphics2D.setClip(this.actualChannelRect.x - 5, this.actualChannelRect.y - 5, this.actualChannelRect.width + 10, this.actualChannelRect.height + 10);
                switch (this.segmentMode) {
                    case -1: {
                        Object object2;
                        int n2;
                        n = this.actualChannelPlotter.sampleToGraphY(0.0f);
                        for (n2 = 0; n2 < this.segmentPoints.size(); ++n2) {
                            object2 = ((FPoint)this.segmentPoints.get(n2)).toGraphicDomain();
                            graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object2).x, n);
                        }
                        break;
                    }
                    case 0: {
                        Object object;
                        Object object2;
                        int n2;
                        for (n2 = 0; n2 < this.segmentPoints.size() - 1; ++n2) {
                            object2 = ((FPoint)this.segmentPoints.get(n2)).toGraphicDomain();
                            object = ((FPoint)this.segmentPoints.get(n2 + 1)).toGraphicDomain();
                            graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object2).y);
                            graphics2D.drawLine(((Point)object).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                        }
                        break;
                    }
                    case 1: {
                        Object object;
                        Object object2;
                        int n2;
                        for (n2 = 0; n2 < this.segmentPoints.size() - 1; ++n2) {
                            object2 = ((FPoint)this.segmentPoints.get(n2)).toGraphicDomain();
                            object = ((FPoint)this.segmentPoints.get(n2 + 1)).toGraphicDomain();
                            graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                        }
                        break;
                    }
                    case 4: {
                        int n3;
                        int n2 = this.segmentPoints.size();
                        if (n2 <= 3) break;
                        Object object2 = new MMArray(n2, 0.0f);
                        Object object = new MMArray(n2, 0.0f);
                        for (n3 = 0; n3 < ((MMArray)object2).getLength(); ++n3) {
                            Point point = ((FPoint)this.segmentPoints.get(n3)).toGraphicDomain();
                            ((MMArray)object2).set(n3, point.x);
                            ((MMArray)object).set(n3, point.y);
                        }
                        this.spline.load((MMArray)object2, (MMArray)object);
                        n3 = Math.max(rectangle.x, (int)((MMArray)object2).get(0));
                        int n4 = Math.min(rectangle.x + rectangle.width, (int)((MMArray)object2).get(((MMArray)object2).getLength() - 1));
                        int n5 = n3;
                        int n6 = (int)this.spline.getResult(n3);
                        for (int i = n3 + 1; i < n4; i += 3) {
                            int n7 = i;
                            int n8 = (int)this.spline.getResult(i);
                            graphics2D.drawLine(n5, n6, n7, n8);
                            n5 = n7;
                            n6 = n8;
                        }
                        break;
                    }
                }
                if (this.pointsVisible) {
                    for (n = 0; n < this.segmentPoints.size(); ++n) {
                        Point point = ((FPoint)this.segmentPoints.get(n)).toGraphicDomain();
                        if (n == this.activePointIndex && this.highlightActivePoint) {
                            graphics2D.setColor(Color.red);
                        } else {
                            graphics2D.setColor(this.color);
                        }
                        graphics2D.fillRect(point.x - 2, point.y - 2, 5, 5);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class FPoint {
        public float x;
        public float y;

        public FPoint() {
            this.x = 0.0f;
            this.y = 0.0f;
        }

        public FPoint(FPoint fPoint) {
            this.x = fPoint.x;
            this.y = fPoint.y;
        }

        public FPoint(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public void toSampleDomain(Point point) {
            this.x = GEditableSegments.this.actualChannelPlotter.graphToSampleX(point.x);
            switch (GEditableSegments.this.yDomain) {
                case 2: {
                    this.y = GEditableSegments.this.actualChannelPlotter.graphToPercentY(point.y);
                    break;
                }
                default: {
                    this.y = GEditableSegments.this.actualChannelPlotter.graphToSampleY(point.y);
                }
            }
        }

        public Point toGraphicDomain() {
            int n;
            int n2 = GEditableSegments.this.actualChannelPlotter.sampleToGraphX(this.x);
            switch (GEditableSegments.this.yDomain) {
                case 2: {
                    n = GEditableSegments.this.actualChannelPlotter.percentToGraphY(this.y);
                    break;
                }
                default: {
                    n = GEditableSegments.this.actualChannelPlotter.sampleToGraphY(this.y);
                }
            }
            return new Point(n2, n);
        }

        public int getGraphSquareDistance(FPoint fPoint) {
            Point point = this.toGraphicDomain();
            Point point2 = fPoint.toGraphicDomain();
            return (int)(Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0));
        }

        public float getSampleXDistance(FPoint fPoint) {
            return Math.abs(this.x - fPoint.x);
        }

        public void limitRange() {
            if (this.x > GEditableSegments.this.xMax) {
                this.x = GEditableSegments.this.xMax;
            } else if (this.x < GEditableSegments.this.xMin) {
                this.x = GEditableSegments.this.xMin;
            }
            if (this.y > GEditableSegments.this.yMax) {
                this.y = GEditableSegments.this.yMax;
            } else if (this.y < GEditableSegments.this.yMin) {
                this.y = GEditableSegments.this.yMin;
            }
        }
    }
}

