/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSegmentGenerator;
import ch.laoe.operation.AOToolkit;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class GEditableFreehand {
    private Color color;
    private boolean editable = true;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private ArrayList points = new ArrayList(100);
    private int actualIndex;
    private int previousIndex;
    private int actualOperation = 0;
    private static final int IDLE = 0;
    private static final int DRAW = 1;
    private static final int REMOVE = 2;
    private AChannel actualChannel;
    private AChannelPlotter actualChannelPlotter;
    private Rectangle actualChannelRect;
    private Cursor penCursor;
    private Cursor eraseCursor;
    private Cursor actualCursor;
    private int oldDraggedX = 0;
    private Stroke stroke = new BasicStroke();

    public GEditableFreehand() {
        this.color = Color.yellow;
        this.clearXRange();
        this.clearYRange();
        this.penCursor = GToolkit.createCustomCursor(this, "penCursor");
        this.eraseCursor = GToolkit.createCustomCursor(this, "eraseCursor");
        this.actualCursor = this.penCursor;
    }

    public GEditableFreehand(GEditableFreehand gEditableFreehand) {
        this();
        for (int i = 0; i < gEditableFreehand.points.size(); ++i) {
            this.points.add(new FPoint((FPoint)gEditableFreehand.points.get(i)));
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setXRange(float f, float f2) {
        this.xMin = f;
        this.xMax = f + f2;
    }

    public void setYRange(float f, float f2) {
        this.yMin = f;
        this.yMax = f + f2;
    }

    public void clearXRange() {
        this.xMin = -3.4028235E38f;
        this.xMax = Float.MAX_VALUE;
    }

    public void clearYRange() {
        this.yMin = -3.4028235E38f;
        this.yMax = Float.MAX_VALUE;
    }

    public void setChannel(AChannel aChannel) {
        this.actualChannel = aChannel;
        this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
    }

    private int findIndex(FPoint fPoint) {
        for (int i = 0; i < this.points.size(); ++i) {
            if (!((FPoint)this.points.get(i)).xGreaterThan(fPoint)) continue;
            return i;
        }
        return this.points.size();
    }

    private void insertOrReplace(FPoint fPoint, int n) {
        if (this.points.size() <= n) {
            this.points.add(fPoint);
        }
        if (fPoint.x == ((FPoint)this.points.get((int)n)).x) {
            this.points.remove(n);
            this.points.add(n, fPoint);
        } else {
            this.points.add(n, fPoint);
        }
    }

    public void clear() {
        this.points.clear();
    }

    public int getNumberOfPoints() {
        return this.points.size();
    }

    public void convertToSamples(int n) {
        if (this.points.size() > 0) {
            MMArray mMArray = new MMArray(this.points.size(), 0.0f);
            MMArray mMArray2 = new MMArray(mMArray.getLength(), 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, ((FPoint)this.points.get((int)i)).x);
                mMArray2.set(i, ((FPoint)this.points.get((int)i)).y);
            }
            AChannelSelection aChannelSelection = this.actualChannel.createChannelSelection();
            aChannelSelection.operateChannel(new AOSegmentGenerator(mMArray, mMArray2, 1, n, true));
        }
    }

    public void convertToSelectedSamples(int n) {
        if (this.points.size() > 0) {
            MMArray mMArray = new MMArray(this.points.size(), 0.0f);
            MMArray mMArray2 = new MMArray(mMArray.getLength(), 0.0f);
            for (int i = 0; i < mMArray.getLength(); ++i) {
                mMArray.set(i, ((FPoint)this.points.get((int)i)).x);
                mMArray2.set(i, ((FPoint)this.points.get((int)i)).y);
            }
            AChannelSelection aChannelSelection = this.actualChannel.getChannelSelection();
            aChannelSelection.operateChannel(new AOSegmentGenerator(mMArray, mMArray2, 1, n, false));
        }
    }

    public void smooth() {
        int n;
        MMArray mMArray = new MMArray(this.points.size(), 0.0f);
        for (n = 0; n < mMArray.getLength(); ++n) {
            mMArray.set(n, ((FPoint)this.points.get((int)n)).y);
        }
        AOToolkit.smooth(mMArray, 0, mMArray.getLength(), 3.0f);
        for (n = 0; n < mMArray.getLength(); ++n) {
            ((FPoint)this.points.get((int)n)).y = mMArray.get(n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
            this.actualChannelRect = this.actualChannelPlotter.getRectangle();
            this.setXRange(this.actualChannelPlotter.getXOffset(), this.actualChannelPlotter.getXLength());
            this.setYRange(this.actualChannelPlotter.getYOffset(), this.actualChannelPlotter.getYLength());
            this.actualOperation = 0;
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            this.actualOperation = GToolkit.isShiftKey(mouseEvent) ? 2 : 1;
            this.previousIndex = this.actualIndex = this.findIndex(fPoint);
            if (this.actualOperation == 1) {
                this.insertOrReplace(fPoint, this.actualIndex);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = GToolkit.isShiftKey(mouseEvent) ? this.eraseCursor : this.penCursor;
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable && mouseEvent.getPoint().x != this.oldDraggedX) {
            this.oldDraggedX = mouseEvent.getPoint().x;
            FPoint fPoint = new FPoint();
            fPoint.toSampleDomain(mouseEvent.getPoint());
            fPoint.limitRange();
            if (this.actualOperation != 0) {
                if (GToolkit.isCtrlKey(mouseEvent)) {
                    fPoint.y = this.actualChannel.getSample((int)fPoint.x);
                }
                this.actualIndex = this.findIndex(fPoint);
                if (this.actualIndex > this.previousIndex) {
                    for (int i = this.previousIndex + 1; i < this.actualIndex; ++i) {
                        if (this.points.size() <= this.previousIndex + 1) continue;
                        this.points.remove(this.previousIndex + 1);
                    }
                } else {
                    for (int i = this.actualIndex; i < this.previousIndex; ++i) {
                        if (this.points.size() <= this.actualIndex) continue;
                        this.points.remove(this.actualIndex);
                    }
                }
                this.actualIndex = this.findIndex(fPoint);
                if (this.actualOperation == 1) {
                    this.insertOrReplace(fPoint, this.actualIndex);
                }
                this.previousIndex = this.actualIndex;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
            this.actualChannelRect = this.actualChannelPlotter.getRectangle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.actualChannel != null) {
            try {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                graphics2D.setStroke(this.stroke);
                graphics2D.setColor(this.color);
                graphics2D.setClip(this.actualChannelRect);
                for (int i = 0; i < this.points.size() - 1; ++i) {
                    Point point = ((FPoint)this.points.get(i)).toGraphicDomain();
                    Point point2 = ((FPoint)this.points.get(i + 1)).toGraphicDomain();
                    graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class FPoint {
        public float x;
        public float y;

        public FPoint() {
            this.x = 0.0f;
            this.y = 0.0f;
        }

        public FPoint(FPoint fPoint) {
            this.x = fPoint.x;
            this.y = fPoint.y;
        }

        public FPoint(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public void toSampleDomain(Point point) {
            this.x = GEditableFreehand.this.actualChannelPlotter.graphToSampleX(point.x);
            this.y = GEditableFreehand.this.actualChannelPlotter.graphToSampleY(point.y);
        }

        public Point toGraphicDomain() {
            return new Point(GEditableFreehand.this.actualChannelPlotter.sampleToGraphX(this.x), GEditableFreehand.this.actualChannelPlotter.sampleToGraphY(this.y));
        }

        public int getGraphSquareDistance(FPoint fPoint) {
            Point point = this.toGraphicDomain();
            Point point2 = fPoint.toGraphicDomain();
            return (int)(Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0));
        }

        public float getSampleXDistance(FPoint fPoint) {
            return Math.abs(this.x - fPoint.x);
        }

        public void limitRange() {
            if (this.x > GEditableFreehand.this.xMax) {
                this.x = GEditableFreehand.this.xMax;
            } else if (this.x < GEditableFreehand.this.xMin) {
                this.x = GEditableFreehand.this.xMin;
            }
            if (this.y > GEditableFreehand.this.yMax) {
                this.y = GEditableFreehand.this.yMax;
            } else if (this.y < GEditableFreehand.this.yMin) {
                this.y = GEditableFreehand.this.yMin;
            }
        }

        public boolean xGreaterThan(FPoint fPoint) {
            return this.x > fPoint.x;
        }

        public boolean yGreaterThan(FPoint fPoint) {
            return this.y > fPoint.y;
        }
    }
}

