/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class GEditableArea {
    private Color color;
    private boolean editable = true;
    private int brushSize;
    public static final int RECTANGLE = 1;
    public static final int LINE = 2;
    private int mode = 1;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private float currentX;
    private float currentY;
    private ArrayList rectangles = new ArrayList(100);
    private int actualOperation = 0;
    private static final int IDLE = 0;
    private static final int DRAW = 1;
    private static final int REMOVE = 2;
    private AChannel actualChannel;
    private AChannelPlotter actualChannelPlotter;
    private Rectangle actualChannelRect;
    private Cursor penCursor;
    private Cursor eraseCursor;
    private Cursor actualCursor;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private Stroke stroke = new BasicStroke();

    public GEditableArea() {
        this.color = Color.yellow;
        this.clearXRange();
        this.clearYRange();
        this.penCursor = GToolkit.createCustomCursor(this, "brushCursor");
        this.eraseCursor = GToolkit.createCustomCursor(this, "eraseCursor");
        this.actualCursor = this.penCursor;
    }

    public GEditableArea(GEditableArea gEditableArea) {
        this();
        this.color = gEditableArea.color;
        this.editable = gEditableArea.editable;
        this.brushSize = gEditableArea.brushSize;
        this.mode = gEditableArea.mode;
        this.xMin = gEditableArea.xMin;
        this.xMax = gEditableArea.xMax;
        this.yMin = gEditableArea.yMin;
        this.yMax = gEditableArea.yMax;
        this.currentX = gEditableArea.currentX;
        this.currentY = gEditableArea.currentY;
        for (int i = 0; i < gEditableArea.rectangles.size(); ++i) {
            this.rectangles.add(new FRectangle((FRectangle)gEditableArea.rectangles.get(i)));
        }
        this.actualChannel = gEditableArea.actualChannel;
    }

    public GEditableArea(AChannel aChannel) {
        this();
        this.setChannel(aChannel);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setBrushSize(int n) {
        this.brushSize = n;
    }

    public int getBrushSize() {
        return this.brushSize;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setXRange(float f, float f2) {
        this.xMin = f;
        this.xMax = f + f2;
    }

    public void setYRange(float f, float f2) {
        this.yMin = f;
        this.yMax = f + f2;
    }

    public void clearXRange() {
        this.xMin = -3.4028235E38f;
        this.xMax = Float.MAX_VALUE;
    }

    public void clearYRange() {
        this.yMin = -3.4028235E38f;
        this.yMax = Float.MAX_VALUE;
    }

    public float getCurrentX() {
        return this.currentX;
    }

    public float getCurrentY() {
        return this.currentY;
    }

    public void setChannel(AChannel aChannel) {
        this.actualChannel = aChannel;
        this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
    }

    public void clear() {
        this.rectangles.clear();
    }

    public void full() {
        try {
            this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
            this.actualChannelRect = this.actualChannelPlotter.getRectangle();
            FRectangle fRectangle = new FRectangle(this.actualChannelRect.x, this.actualChannelRect.y, this.actualChannelRect.x + this.actualChannelRect.width, this.actualChannelRect.y + this.actualChannelRect.height);
            fRectangle.toSampleDomain();
            this.rectangles.clear();
            this.rectangles.add(fRectangle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumberOfRectangles() {
        return this.rectangles.size();
    }

    public boolean isInside(float f, float f2) {
        for (int i = 0; i < this.rectangles.size(); ++i) {
            if (!((FRectangle)this.rectangles.get(i)).isInside(f, f2)) continue;
            return true;
        }
        return false;
    }

    public float getXMin() {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.rectangles.size(); ++i) {
            float f2 = ((FRectangle)this.rectangles.get((int)i)).topLeft.x;
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getXMax() {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < this.rectangles.size(); ++i) {
            float f2 = ((FRectangle)this.rectangles.get((int)i)).bottomRight.x;
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getYMin() {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.rectangles.size(); ++i) {
            float f2 = ((FRectangle)this.rectangles.get((int)i)).bottomRight.y;
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getYMax() {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < this.rectangles.size(); ++i) {
            float f2 = ((FRectangle)this.rectangles.get((int)i)).topLeft.y;
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
            this.actualChannelRect = this.actualChannelPlotter.getRectangle();
            this.setXRange(this.actualChannelPlotter.getXOffset(), this.actualChannelPlotter.getXLength());
            this.setYRange(this.actualChannelPlotter.getYOffset(), this.actualChannelPlotter.getYLength());
            this.actualOperation = GToolkit.isShiftKey(mouseEvent) ? 2 : 1;
            switch (this.mode) {
                case 1: {
                    this.x1 = mouseEvent.getPoint().x;
                    this.y1 = mouseEvent.getPoint().y;
                    this.x2 = this.x1;
                    this.y2 = this.y1;
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.currentX = this.actualChannelPlotter.graphToSampleX(mouseEvent.getPoint().x);
        this.currentY = this.actualChannelPlotter.graphToSampleY(mouseEvent.getPoint().y);
        Cursor cursor = GToolkit.isShiftKey(mouseEvent) ? this.eraseCursor : this.penCursor;
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            this.currentX = this.actualChannelPlotter.graphToSampleX(mouseEvent.getPoint().x);
            this.currentY = this.actualChannelPlotter.graphToSampleY(mouseEvent.getPoint().y);
            switch (this.mode) {
                case 1: {
                    this.x2 = mouseEvent.getPoint().x;
                    this.y2 = mouseEvent.getPoint().y;
                    break;
                }
                case 2: {
                    if (this.actualOperation != 1) break;
                    this.x1 = mouseEvent.getPoint().x - this.brushSize / 2;
                    this.y1 = mouseEvent.getPoint().y - this.brushSize / 2;
                    this.x2 = this.x1 + this.brushSize;
                    this.y2 = this.y1 + this.brushSize;
                    FRectangle fRectangle = new FRectangle(this.x1, this.y1, this.x2, this.y2);
                    fRectangle.toSampleDomain();
                    this.rectangles.add(fRectangle);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            switch (this.mode) {
                case 1: {
                    if (this.actualOperation != 1) break;
                    this.x2 = mouseEvent.getPoint().x;
                    this.y2 = mouseEvent.getPoint().y;
                    FRectangle fRectangle = new FRectangle(this.x1, this.y1, this.x2, this.y2);
                    fRectangle.toSampleDomain();
                    this.rectangles.add(fRectangle);
                }
            }
            this.actualOperation = 0;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.actualChannelPlotter = this.actualChannel.getChannelPlotter();
            this.actualChannelRect = this.actualChannelPlotter.getRectangle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.actualChannel != null) {
            try {
                graphics2D.setClip(this.actualChannelRect);
                graphics2D.setStroke(this.stroke);
                graphics2D.setColor(this.color);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.18f));
                for (int i = 0; i < this.rectangles.size(); ++i) {
                    Rectangle rectangle2 = ((FRectangle)this.rectangles.get(i)).toGraphicDomain();
                    graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                switch (this.mode) {
                    case 1: {
                        if (this.actualOperation != 1) break;
                        graphics2D.setStroke(this.stroke);
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class FRectangle {
        FPoint topLeft;
        FPoint bottomRight;

        public FRectangle(int n, int n2, int n3, int n4) {
            this.topLeft = new FPoint(Math.min(n, n3), Math.min(n2, n4));
            this.bottomRight = new FPoint(Math.max(n, n3), Math.max(n2, n4));
        }

        public FRectangle(FRectangle fRectangle) {
            this.topLeft = new FPoint(fRectangle.topLeft);
            this.bottomRight = new FPoint(fRectangle.bottomRight);
        }

        public void toSampleDomain() {
            this.topLeft.toSampleDomain();
            this.bottomRight.toSampleDomain();
        }

        public Rectangle toGraphicDomain() {
            Point point = this.topLeft.toGraphicDomain();
            Point point2 = this.bottomRight.toGraphicDomain();
            return new Rectangle(point.x, point.y, point2.x - point.x, point2.y - point.y);
        }

        public boolean isInside(float f, float f2) {
            return f > this.topLeft.x && f2 < this.topLeft.y && f < this.bottomRight.x && f2 > this.bottomRight.y;
        }
    }

    private class FPoint {
        public float x;
        public float y;

        public FPoint() {
            this.x = 0.0f;
            this.y = 0.0f;
        }

        public FPoint(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public FPoint(FPoint fPoint) {
            this.x = fPoint.x;
            this.y = fPoint.y;
        }

        public void toSampleDomain() {
            this.x = GEditableArea.this.actualChannelPlotter.graphToSampleX((int)this.x);
            this.y = GEditableArea.this.actualChannelPlotter.graphToSampleY((int)this.y);
        }

        public Point toGraphicDomain() {
            return new Point(GEditableArea.this.actualChannelPlotter.sampleToGraphX(this.x), GEditableArea.this.actualChannelPlotter.sampleToGraphY(this.y));
        }

        public void limitRange() {
            if (this.x > GEditableArea.this.xMax) {
                this.x = GEditableArea.this.xMax;
            } else if (this.x < GEditableArea.this.xMin) {
                this.x = GEditableArea.this.xMin;
            }
            if (this.y > GEditableArea.this.yMax) {
                this.y = GEditableArea.this.yMax;
            } else if (this.y < GEditableArea.this.yMin) {
                this.y = GEditableArea.this.yMin;
            }
        }

        public boolean xGreaterThan(FPoint fPoint) {
            return this.x > fPoint.x;
        }

        public boolean yGreaterThan(FPoint fPoint) {
            return this.y > fPoint.y;
        }
    }
}

