/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.ui.Debug;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class GClipPanel
extends JPanel {
    protected AClip clip;
    protected AClipPlotter clipPlotter;
    protected BufferedImage bgImage;
    protected Graphics2D bgGraphics;
    protected Dimension oldSize;

    public GClipPanel(AClip aClip) {
        this.clip = aClip;
        this.clipPlotter = this.clip.getClipPlotter();
        this.setFocusable(true);
        this.oldSize = new Dimension(0, 0);
    }

    public AClip getClip() {
        return this.clip;
    }

    public AClipPlotter getClipPlotter() {
        return this.clipPlotter;
    }

    public BufferedImage createFullImage(boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(this.getSize().width, this.getSize().height, 4);
        if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)this.bgImage, 0, 0, this);
            if (bl) {
                this.paintTopComponentsOnly(graphics2D);
            }
        }
        return bufferedImage;
    }

    public final void reload() {
        try {
            if (this.getSize().width > 0 && this.getSize().height > 0) {
                this.bgImage = new BufferedImage(this.getSize().width, this.getSize().height, 4);
                if (this.bgImage != null) {
                    this.bgGraphics = this.bgImage.createGraphics();
                    this.bgGraphics.setColor(this.getBackground());
                    this.bgGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    this.paintFullClip(this.bgGraphics);
                    this.repaint();
                }
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    protected void paintFullClip(Graphics2D graphics2D) {
    }

    protected void paintTopComponentsOnly(Graphics2D graphics2D) {
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.oldSize.getWidth() != this.getSize().getWidth() || this.oldSize.getHeight() != this.getSize().getHeight()) {
                this.oldSize = new Dimension((int)this.getSize().getWidth(), (int)this.getSize().getHeight());
                this.reload();
            }
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setClip(rectangle);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawImage((Image)this.bgImage, 0, 0, this);
            this.paintTopComponentsOnly(graphics2D);
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }
}

