/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AClip;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GStatusBar;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.stroke.UiStroke;
import ch.oli4.ui.stroke.UiStrokeGlass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GClipFrame
extends JFrame
implements WindowListener {
    protected UiStroke stroke;
    private GStatusBar statusBar;
    private static int clipFrameCounter = 0;
    protected GClipEditor clipEditor;

    public GClipFrame(AClip aClip) {
        GPersistence gPersistence = GPersistence.createPersistance();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.clipEditor = new GClipEditor(this, aClip);
        jPanel.add((Component)this.clipEditor, "Center");
        this.statusBar = new GStatusBar();
        jPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add(jPanel);
        Dimension dimension = new Dimension(gPersistence.getInt("clip.frameSize.width"), gPersistence.getInt("clip.frameSize.height"));
        this.setSize(dimension);
        GToolkit.setFrameInMiddleOfScreen(this);
        URL uRL = this.getClass().getResource("laoe.gif");
        if (uRL != null) {
            this.setIconImage(new ImageIcon(uRL).getImage());
        }
        if (aClip.getName() == null) {
            aClip.setName("<" + GLanguage.translate("clip") + " " + clipFrameCounter + ">");
        }
        this.setTitle(aClip.getName());
        ++clipFrameCounter;
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.stroke = new UiStrokeGlass(this);
        this.stroke.setButtonMask(8);
        this.clipEditor.addMouseListener(this.stroke);
        this.stroke.addStrokeListener(Laoe.getInstance().getPluginHandler().getStrokeHandler());
    }

    public GStatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean tryToClose() {
        Debug.println(3, "try to close " + this.getClipEditor().getClip().getName());
        this.setState(0);
        if (this.getClipEditor().getClip().getHistory().hasUnsavedModifications() && GDialog.showYesNoQuestionDialog(this, GLanguage.translate("save"), GLanguage.translate("wantToSaveModifications?"))) {
            Laoe.getInstance().getPluginHandler().fileSave.start();
        }
        Debug.println(3, "close " + this.getClipEditor().getClip().getName());
        this.setVisible(false);
        this.clipEditor.destroy();
        Laoe.getInstance().removeClipFrame(this);
        return true;
    }

    public GClipEditor getClipEditor() {
        return this.clipEditor;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        Laoe.getInstance().setFocussedClipFrame(this);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.tryToClose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

