/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.GLanguage;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GChannelChooser
extends JPanel
implements ActionListener {
    private ALayer layer;
    private JComboBox paramChannel;
    private Vector listenerList;

    public GChannelChooser() {
        this.initGui();
        this.listenerList = new Vector();
    }

    public void setLayer(ALayer aLayer) {
        this.layer = aLayer;
        this.reload();
    }

    private void initGui() {
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(this, 10, 1);
        uiCartesianLayout.setBorderGap(0.0f);
        uiCartesianLayout.setCellGap(0.0f);
        this.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("channel") + ":"), 0, 0, 3, 1);
        this.paramChannel = new JComboBox();
        uiCartesianLayout.add(this.paramChannel, 3, 0, 7, 1);
        this.reload();
        this.paramChannel.addActionListener(this);
    }

    public void reload() {
        if (this.layer != null) {
            int n = this.layer.getNumberOfChannels();
            int n2 = this.paramChannel.getSelectedIndex();
            this.paramChannel.removeAllItems();
            for (int i = 0; i < n; ++i) {
                this.paramChannel.addItem(this.layer.getChannel(i));
            }
            if (n2 < n) {
                this.paramChannel.setSelectedIndex(n2);
            }
        }
    }

    public AChannel getSelectedChannel() {
        return (AChannel)this.paramChannel.getSelectedItem();
    }

    public int getSelectedChannelIndex() {
        int n = this.paramChannel.getSelectedIndex();
        if (n < 0) {
            return 0;
        }
        if (n > this.layer.getNumberOfChannels() - 1) {
            return this.layer.getNumberOfChannels() - 1;
        }
        return n;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.paramChannel.setEnabled(bl);
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.paramChannel.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionEvent();
    }

    private void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ((ActionListener)this.listenerList.get(i)).actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(actionListener);
    }
}

