/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannelPlotterSpectrogram;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GLanguage;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPViewOptions
extends GPluginFrame {
    private JComboBox windowType;
    private JCheckBox numericRuler;
    private GComboBoxPowerOf2 fftLength;
    private EventDispatcher eventDispatcher;

    public GPViewOptions(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "viewOptions";
    }

    public void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(20, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.numericRuler = new JCheckBox(GLanguage.translate("numericRuler"));
        this.numericRuler.setSelected(AClipPlotter.isSkalaValuesVisible());
        jPanel.add((Component)this.numericRuler, new Rectangle(0, 2, 8, 1));
        jTabbedPane.add((Component)jPanel, GLanguage.translate("ruler"));
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(20, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("fftLength")), 0, 0, 4, 1);
        this.fftLength = new GComboBoxPowerOf2(5, 9);
        this.fftLength.setSelectedExponent(9);
        uiCartesianLayout2.add(this.fftLength, 4, 0, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("window")), 0, 1, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("rectangular"), GLanguage.translate("hamming"), GLanguage.translate("blackman"), GLanguage.translate("flattop")};
        this.windowType = new JComboBox<String>(stringArray);
        this.windowType.setSelectedIndex(1);
        uiCartesianLayout2.add(this.windowType, 4, 1, 6, 1);
        jTabbedPane.add((Component)jPanel2, GLanguage.translate("spectrogram"));
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.numericRuler.addActionListener(this.eventDispatcher);
        this.fftLength.addActionListener(this.eventDispatcher);
        this.windowType.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.fftLength.setSelectedValue(AChannelPlotterSpectrogram.getFftLength());
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPViewOptions.this.fftLength) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [fft length] clicked");
                AChannelPlotterSpectrogram.setFftLength(GPViewOptions.this.fftLength.getSelectedValue());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.numericRuler) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [numeric ruler] clicked");
                AClipPlotter.setSkalaValuesVisible(GPViewOptions.this.numericRuler.isSelected());
                GPViewOptions.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPViewOptions.this.windowType) {
                Debug.println(1, "plugin " + GPViewOptions.this.getName() + " [window type] clicked");
                switch (GPViewOptions.this.windowType.getSelectedIndex()) {
                    case 1: {
                        AChannelPlotterSpectrogram.setWindowType(1);
                        break;
                    }
                    case 2: {
                        AChannelPlotterSpectrogram.setWindowType(3);
                        break;
                    }
                    case 3: {
                        AChannelPlotterSpectrogram.setWindowType(4);
                        break;
                    }
                    default: {
                        AChannelPlotterSpectrogram.setWindowType(2);
                    }
                }
                GPViewOptions.this.reloadFocussedClipEditor();
            }
        }
    }
}

