/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOVibrato;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextF;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPVibrato
extends GPluginFrame {
    private JComboBox presets;
    private JComboBox shape;
    private UiControlText modulation;
    private UiControlText period;
    private JButton apply;
    private EventDispatcher eventDispatcher;
    private String[] presetsName;
    private int[] shapePresets;
    private float[] modulationPresets;
    private float[] periodPresets;

    public GPVibrato(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "vibrato";
    }

    private void initGui() {
        PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
        try {
            ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
        this.presetsName = new String[n];
        this.shapePresets = new int[n];
        this.modulationPresets = new float[n];
        this.periodPresets = new float[n];
        for (int i = 0; i < n; ++i) {
            this.presetsName[i] = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
            this.shapePresets[i] = ((Persistence)persistenceDefaultImpl).getInt("shape_" + i);
            this.modulationPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("modulation_" + i);
            this.periodPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("period_" + i);
        }
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("presets")), 0, 0, 4, 1);
        this.presets = new JComboBox<String>(this.presetsName);
        uiCartesianLayout.add(this.presets, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shape")), 0, 1, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("sinus"), GLanguage.translate("triangle"), GLanguage.translate("saw")};
        this.shape = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.shape, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("modulatedDelay")), 0, 2, 4, 1);
        this.modulation = new GControlTextX(this.getMain(), 7, true, true);
        this.modulation.setDataRange(0.0, 1000000.0);
        this.modulation.setData(100.0);
        this.modulation.setUnit("ms");
        uiCartesianLayout.add(this.modulation, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("modulationPeriod")), 0, 3, 4, 1);
        this.period = new GControlTextF(this.getMain(), 7, true, true);
        this.period.setDataRange(0.0, 1000000.0);
        this.period.setData(1000.0);
        this.period.setUnit("ms");
        uiCartesianLayout.add(this.period, 4, 3, 6, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 4, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.presets.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.modulation.refresh();
        this.period.refresh();
    }

    private void onPresetChange() {
        float f = this.getFocussedClip().getSampleRate();
        int n = this.presets.getSelectedIndex();
        this.shape.setSelectedIndex(this.shapePresets[n]);
        this.modulation.setData(f * this.modulationPresets[n]);
        this.period.setData(f / this.periodPresets[n]);
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        int n = 0;
        switch (this.shape.getSelectedIndex()) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
            }
        }
        aLayerSelection.operateEachChannel(new AOVibrato((int)this.modulation.getData(), (int)this.period.getData(), n));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPVibrato.this.apply) {
                GProgressViewer.start(GPVibrato.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPVibrato.this.getName() + " [apply] clicked");
                GPVibrato.this.onApply();
                GProgressViewer.setProgress(100);
                GPVibrato.this.updateHistory(GLanguage.translate(GPVibrato.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPVibrato.this.reloadFocussedClipEditor();
                GPVibrato.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPVibrato.this.presets) {
                Debug.println(1, "plugin " + GPVibrato.this.getName() + " [presets] clicked");
                GPVibrato.this.onPresetChange();
            }
        }
    }
}

