/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClipHistory;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextMem;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.control.UiControlText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GPUndoStack
extends GPluginFrame {
    private JTable table;
    private UndoTableModel tableModel;
    private JScrollPane scrollPane;
    private int oldNumberOfEntries = 0;
    private JButton storeButton;
    private UiControlText memory;
    private EventDispatcher eventDispatcher;

    public GPUndoStack(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "undoStack";
    }

    @Override
    public void reload() {
        super.reload();
        if (this.frame.isVisible() && this.getFocussedClip() != null) {
            this.onClipChange();
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tableModel = new UndoTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new UndoTableIconRenderer());
        tableColumn.setMaxWidth(30);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 70));
        jPanel.add((Component)this.scrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        this.storeButton = new JButton(GLanguage.translate("manualSave"));
        jPanel2.add(this.storeButton);
        jPanel2.add(new JLabel(GLanguage.translate("totalHistorySize")));
        this.memory = new GControlTextMem(12, false, true);
        this.memory.setDataRange(0.0, 1.0E12);
        this.memory.setEditable(false);
        jPanel2.add(this.memory);
        this.frame.getContentPane().add(jPanel);
        this.frame.setSize(new Dimension(400, 260));
        this.eventDispatcher = new EventDispatcher();
        this.table.addMouseListener(this.eventDispatcher);
        this.storeButton.addActionListener(this.eventDispatcher);
    }

    private void updateThisAndFocussedClip() {
        this.frame.validate();
        this.frame.repaint();
        this.reloadFocussedClipEditor();
    }

    private void onClipChange() {
        try {
            AClipHistory aClipHistory = this.getFocussedClip().getHistory();
            this.tableModel.setHistory(aClipHistory);
            this.memory.setData(AClipHistory.getMemorySize());
            if (this.oldNumberOfEntries != this.tableModel.getRowCount()) {
                this.scrollPane.getViewport().setViewPosition(new Point(0, 0x3FFFFFFF));
            }
            this.oldNumberOfEntries = this.tableModel.getRowCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.updateThisAndFocussedClip();
    }

    private class UndoTableModel
    extends AbstractTableModel {
        private AClipHistory history;
        final String[] columnNames = new String[]{"", GLanguage.translate("operation"), GLanguage.translate("time")};

        private UndoTableModel() {
        }

        public void setHistory(AClipHistory aClipHistory) {
            this.fireTableDataChanged();
            this.history = aClipHistory;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n].toString();
        }

        @Override
        public int getRowCount() {
            if (this.history != null) {
                return this.history.getStackSize();
            }
            return 1;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.history != null) {
                switch (n2) {
                    case 0: {
                        if (this.history.getIcon(n) != null) {
                            return this.history.getIcon(n);
                        }
                        return GPUndoStack.this.loadIcon();
                    }
                    case 1: {
                        return this.history.getDescription(n);
                    }
                    case 2: {
                        return this.history.getTime(n);
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.fireTableCellUpdated(n, n2);
        }
    }

    private class UndoTableIconRenderer
    implements TableCellRenderer {
        private UndoTableIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof ImageIcon) {
                return new JLabel((ImageIcon)object);
            }
            return new JLabel();
        }
    }

    private class EventDispatcher
    implements ActionListener,
    MouseListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPUndoStack.this.storeButton) {
                Debug.println(1, "plugin " + GPUndoStack.this.getName() + " [store] clicked");
                GPUndoStack.this.updateHistory(JOptionPane.showInputDialog(GPUndoStack.this.frame, (Object)GLanguage.translate("enterADescription")));
                GPUndoStack.this.onClipChange();
                GPUndoStack.this.reloadFocussedClipEditor();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (GToolkit.isButton1(mouseEvent)) {
                AClipHistory aClipHistory = GPUndoStack.this.getFocussedClip().getHistory();
                if (AClipHistory.isEnabled()) {
                    Debug.println(1, "plugin " + GPUndoStack.this.getName() + " [history entry] clicked");
                    GProgressViewer.start(GPUndoStack.this.getName());
                    aClipHistory.reloadClip(GPUndoStack.this.table.getSelectedRow(), GPUndoStack.this.getFocussedClip());
                    GPUndoStack.this.onClipChange();
                    GPUndoStack.this.updateFrameTitle();
                    GProgressViewer.finish();
                } else {
                    GDialog.showWarningDialog(null, "warning", "undoHistoryIsDisabled");
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }
    }
}

