/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GPTipOfTheDay
extends GPluginFrame {
    private JEditorPane pTip;
    private JButton bNextTip;
    private JButton bPreviousTip;
    private JCheckBox showNextTime;
    private EventDispatcher eventDispatcher;
    private int tipNumber;
    private Persistence tipTexts;
    private String pageTop;
    private String pageBottom;
    private int maxNumberOfTips;

    public GPTipOfTheDay(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.tipNumber = this.persistance.getInt("plugin." + this.getName() + ".currentTip");
        try {
            this.initGui();
            if (this.showNextTime.isSelected()) {
                this.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return "tipOfTheDay";
    }

    @Override
    public void start() {
        super.start();
    }

    private void initGui() {
        this.tipTexts = new PersistenceDefaultImpl();
        try {
            this.tipTexts.restore("tipOfTheDay_" + GLanguage.getActualLanguage() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageTop = this.tipTexts.getString("pageTop");
        this.pageBottom = this.tipTexts.getString("pageBottom");
        this.maxNumberOfTips = this.tipTexts.getInt("numberOfTips");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.pTip = new JEditorPane();
        this.pTip.setEditable(false);
        this.pTip.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(this.pTip);
        jScrollPane.setPreferredSize(new Dimension(450, 160));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        this.showNextTime = new JCheckBox(GLanguage.translate("showNextTime"));
        this.showNextTime.setSelected(this.persistance.getBoolean("plugin." + this.getName() + ".showNextTime"));
        jPanel2.add(this.showNextTime);
        this.bNextTip = new JButton(this.loadIcon("up.gif"));
        this.bNextTip.setToolTipText(GLanguage.translate("nextTip"));
        this.bNextTip.setPreferredSize(new Dimension(26, 26));
        jPanel2.add(this.bNextTip);
        this.bPreviousTip = new JButton(this.loadIcon("down.gif"));
        this.bPreviousTip.setToolTipText(GLanguage.translate("previousTip"));
        this.bPreviousTip.setPreferredSize(new Dimension(26, 26));
        jPanel2.add(this.bPreviousTip);
        jPanel.add((Component)jPanel2, "South");
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.frame.setResizable(true);
        this.eventDispatcher = new EventDispatcher();
        this.bNextTip.addActionListener(this.eventDispatcher);
        this.bPreviousTip.addActionListener(this.eventDispatcher);
        this.loadNextTip();
    }

    private String getFormattedTipNumber() {
        return "<p align=center> (" + this.tipNumber + ")";
    }

    private void loadPage() {
        try {
            String string = this.tipTexts.getString("tip" + this.tipNumber);
            if (string == null) {
                this.tipNumber = 0;
                string = this.tipTexts.getString("tip0");
            }
            this.pTip.setText(this.pageTop + " " + string + this.getFormattedTipNumber() + " " + this.pageBottom);
            this.pTip.setCaretPosition(0);
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    private void loadNextTip() {
        this.tipNumber = (this.tipNumber + 1) % this.maxNumberOfTips;
        this.loadPage();
    }

    private void loadPreviousTip() {
        if (--this.tipNumber < 0) {
            this.tipNumber = this.maxNumberOfTips - 1;
        }
        this.loadPage();
    }

    @Override
    public void onBackup(Persistence persistence) {
        super.onBackup(persistence);
        this.persistance.setInt("plugin." + this.getName() + ".currentTip", this.tipNumber);
        this.persistance.setBoolean("plugin." + this.getName() + ".showNextTime", this.showNextTime.isSelected());
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPTipOfTheDay.this.bNextTip) {
                Debug.println(1, "plugin " + GPTipOfTheDay.this.getName() + " [load next] clicked");
                GPTipOfTheDay.this.loadNextTip();
            }
            if (actionEvent.getSource() == GPTipOfTheDay.this.bPreviousTip) {
                Debug.println(1, "plugin " + GPTipOfTheDay.this.getName() + " [load previous] clicked");
                GPTipOfTheDay.this.loadPreviousTip();
            }
        }
    }
}

