/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOSpectrum;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPSpectrum
extends GPluginFrame {
    private JComboBox window;
    private JButton createSpectrum;
    private JButton update;
    private EventDispatcher eventDispatcher;
    private GClipEditor spectrumClipEditor;

    public GPSpectrum(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "spectrum";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("window")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("rectangular"), GLanguage.translate("hamming"), GLanguage.translate("blackman"), GLanguage.translate("flattop")};
        this.window = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.window, 4, 0, 6, 1);
        this.createSpectrum = new JButton(GLanguage.translate("new"));
        uiCartesianLayout.add(this.createSpectrum, 1, 1, 4, 1);
        this.update = new JButton(GLanguage.translate("update"));
        uiCartesianLayout.add(this.update, 5, 1, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.createSpectrum.addActionListener(this.eventDispatcher);
        this.update.addActionListener(this.eventDispatcher);
        this.updateGui();
    }

    private void updateGui() {
        if (this.spectrumClipEditor != null) {
            this.update.setEnabled(true);
        } else {
            this.update.setEnabled(false);
        }
    }

    private void onCreateSpectrum() {
        AClip aClip = new AClip(1, 1, AOSpectrum.getSpectrumLength());
        aClip.setName("<" + GLanguage.translate("spectrum") + ">");
        aClip.setSampleRate(this.getFocussedClip().getSampleRate());
        this.getMain().addClipFrame(aClip);
        this.spectrumClipEditor = this.getFocussedClipEditor();
    }

    private void onUpdate() {
        int n;
        switch (this.window.getSelectedIndex()) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            default: {
                n = 1;
            }
        }
        AOSpectrum aOSpectrum = new AOSpectrum(n);
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(aOSpectrum);
        AClip aClip = this.spectrumClipEditor.getClip();
        AChannel aChannel = aClip.getLayer(0).getChannel(0);
        aChannel.setSamples(aOSpectrum.getSpectrum());
        aChannel.markChange();
        try {
            aClip.getHistory().store(this.loadIcon(), GLanguage.translate(this.getName()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        aClip.getClipPlotter().autoScale();
        this.spectrumClipEditor.reload();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSpectrum.this.update) {
                GProgressViewer.start(GPSpectrum.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(100);
                Debug.println(1, "plugin " + GPSpectrum.this.getName() + " [update] clicked");
                GPSpectrum.this.onUpdate();
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
            } else if (actionEvent.getSource() == GPSpectrum.this.createSpectrum) {
                Debug.println(1, "plugin " + GPSpectrum.this.getName() + " [create spectrum] clicked");
                GPSpectrum.this.onCreateSpectrum();
            }
            GPSpectrum.this.updateGui();
        }
    }
}

