/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GCookie;
import ch.laoe.ui.GEditableArea;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPSpectrogramFilter
extends GPluginFrame {
    private GEditableArea area;
    private AChannel actualChannel;
    private Stroke segmentSroke;
    private JButton all;
    private JButton none;
    private JButton apply;
    private JButton copy;
    private JButton paste;
    private UiControlText xNumeric;
    private UiControlText yNumeric;
    private UiControlText amplification;
    private UiControlText brushSize;
    private UiControlText threshold;
    private GComboBoxPowerOf2 fftLength;
    private JCheckBox inversed;
    private JComboBox drawMode;
    private JComboBox filterMode;
    private EventDispatcher eventDispatcher;
    private GEditableArea clipBoardArea;
    private static final int MAGNITUDE = 1;
    private static final int MAGNITUDE_ABOVE_THRESHOLD = 2;
    private static final int MAGNITUDE_BELOW_THRESHOLD = 3;

    public GPSpectrogramFilter(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.updateCookie();
    }

    @Override
    public String getName() {
        return "spectrogramFilter";
    }

    @Override
    public void start() {
        super.start();
        this.updateCookie();
    }

    @Override
    public void reload() {
        super.reload();
        this.updateCookie();
        this.amplification.refresh();
        this.brushSize.refresh();
        this.threshold.refresh();
        this.xNumeric.refresh();
        this.yNumeric.refresh();
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void updateCookie() {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                if (aLayer.getChannel(i).getCookies().getCookie(this.getName()) != null) continue;
                AChannel aChannel = aLayer.getChannel(i);
                aChannel.getCookies().setCookie(new GCookieSpectrogramFilter(aChannel), this.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateActualArea(MouseEvent mouseEvent) {
        try {
            AChannel aChannel = this.getSelectedLayer().getChannel(mouseEvent.getPoint());
            if (aChannel != null) {
                this.actualChannel = this.getSelectedLayer().getChannel(mouseEvent.getPoint());
                this.area = ((GCookieSpectrogramFilter)this.actualChannel.getCookies().getCookie((String)this.getName())).area;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    private void updateActualArea() {
        try {
            this.actualChannel = this.getSelectedLayer().getSelectedChannel();
            this.area = ((GCookieSpectrogramFilter)this.actualChannel.getCookies().getCookie((String)this.getName())).area;
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.updateActualArea(mouseEvent);
            this.area.mousePressed(mouseEvent);
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.area.mouseReleased(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            this.updateActualArea(mouseEvent);
            this.updateCoordinates(mouseEvent);
            switch (this.drawMode.getSelectedIndex()) {
                case 0: {
                    this.area.setMode(1);
                    break;
                }
                case 1: {
                    this.area.setMode(2);
                }
            }
            this.area.setBrushSize((int)this.brushSize.getData());
            this.area.mouseMoved(mouseEvent);
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateCoordinates(mouseEvent);
        this.area.mouseDragged(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.area.mouseClicked(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateActualArea(mouseEvent);
        this.area.mouseEntered(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    private void updateCoordinates(MouseEvent mouseEvent) {
        this.xNumeric.setData(this.area.getCurrentX());
        this.yNumeric.setData(this.area.getCurrentY());
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                ((GCookieSpectrogramFilter)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).area.paintOntoClip(graphics2D, rectangle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 9);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("x")), 0, 0, 5, 1);
        this.xNumeric = new GControlTextX(this.getMain(), 7, false, true);
        this.xNumeric.setDataRange(-1.0E9, 1.0E9);
        this.xNumeric.setData(0.0);
        this.xNumeric.setEditable(false);
        uiCartesianLayout.add(this.xNumeric, 0, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("y")), 5, 0, 5, 1);
        this.yNumeric = new GControlTextY(this.getMain(), 7, false, true);
        this.yNumeric.setDataRange(-1.0E9, 1.0E9);
        this.yNumeric.setData(0.0);
        this.yNumeric.setEditable(false);
        uiCartesianLayout.add(this.yNumeric, 5, 1, 5, 1);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 6);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("drawMode")), 0, 0, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("rectangle"), GLanguage.translate("line")};
        this.drawMode = new JComboBox<String>(stringArray);
        this.drawMode.setSelectedIndex(0);
        uiCartesianLayout2.add(this.drawMode, 5, 0, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("brushSize")), 0, 1, 5, 1);
        this.brushSize = new UiControlText(9, true, true);
        this.brushSize.setDataRange(2.0, 50.0);
        this.brushSize.setData(4.0);
        uiCartesianLayout2.add(this.brushSize, 5, 1, 5, 1);
        this.inversed = new JCheckBox(GLanguage.translate("inversed"));
        uiCartesianLayout2.add(this.inversed, 0, 2, 7, 1);
        this.all = new JButton(GLanguage.translate("all"));
        uiCartesianLayout2.add(this.all, 1, 3, 4, 1);
        this.none = new JButton(GLanguage.translate("none"));
        uiCartesianLayout2.add(this.none, 5, 3, 4, 1);
        this.copy = new JButton(GLanguage.translate("copy"));
        uiCartesianLayout2.add(this.copy, 1, 4, 4, 1);
        this.paste = new JButton(GLanguage.translate("paste"));
        uiCartesianLayout2.add(this.paste, 5, 4, 4, 1);
        jTabbedPane.add((Component)jPanel2, GLanguage.translate("selection"));
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 6);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("filterMode")), 0, 0, 5, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("magnitude"), GLanguage.translate("aboveThreshold"), GLanguage.translate("belowThreshold")};
        this.filterMode = new JComboBox<String>(stringArray2);
        this.filterMode.setSelectedIndex(0);
        uiCartesianLayout3.add(this.filterMode, 5, 0, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("amplification")), 0, 1, 5, 1);
        this.amplification = new GControlTextA(9, true, true);
        this.amplification.setDataRange(0.0, 10.0);
        this.amplification.setData(0.0);
        uiCartesianLayout3.add(this.amplification, 5, 1, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("threshold")), 0, 2, 5, 1);
        this.threshold = new GControlTextY(this.getMain(), 9, true, true);
        this.threshold.setDataRange(0.0, 1.0E9);
        this.threshold.setData(50.0);
        uiCartesianLayout3.add(this.threshold, 5, 2, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("fftLength")), 0, 3, 5, 1);
        this.fftLength = new GComboBoxPowerOf2(6, 14);
        this.fftLength.setSelectedExponent(11);
        uiCartesianLayout3.add(this.fftLength, 5, 3, 5, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.apply, 3, 4, 4, 1);
        jTabbedPane.add((Component)jPanel3, GLanguage.translate("filter"));
        uiCartesianLayout.add(jTabbedPane, 0, 2, 10, 7);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.all.addActionListener(this.eventDispatcher);
        this.none.addActionListener(this.eventDispatcher);
        this.copy.addActionListener(this.eventDispatcher);
        this.paste.addActionListener(this.eventDispatcher);
        this.apply.addActionListener(this.eventDispatcher);
        this.drawMode.addActionListener(this.eventDispatcher);
        this.filterMode.addActionListener(this.eventDispatcher);
        this.updateComponents();
    }

    private void updateComponents() {
        this.brushSize.setEnabled(this.drawMode.getSelectedIndex() == 1);
        this.threshold.setEnabled(this.filterMode.getSelectedIndex() != 0);
    }

    private void onCopy() {
        this.updateActualArea();
        this.clipBoardArea = new GEditableArea(this.area);
        this.repaintFocussedClipEditor();
    }

    private void onPaste() {
        if (this.clipBoardArea != null) {
            GEditableArea gEditableArea = new GEditableArea(this.clipBoardArea);
            this.updateActualArea();
            gEditableArea.setChannel(this.actualChannel);
            try {
                this.area = gEditableArea;
                ((GCookieSpectrogramFilter)this.actualChannel.getCookies().getCookie((String)this.getName())).area = gEditableArea;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaintFocussedClipEditor();
        }
    }

    private void onSelectAll() {
        this.updateActualArea();
        this.area.full();
        this.repaintFocussedClipEditor();
    }

    private void onSelectNone() {
        this.updateActualArea();
        this.area.clear();
        this.repaintFocussedClipEditor();
    }

    private void onApply() {
        GProgressViewer.entrySubProgress();
        ALayer aLayer = this.getSelectedLayer();
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            AChannel aChannel = aLayer.getChannel(i);
            GProgressViewer.setProgress((i + 1) * 100 / aLayer.getNumberOfChannels());
            GEditableArea gEditableArea = ((GCookieSpectrogramFilter)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).area;
            int n = 1;
            switch (this.filterMode.getSelectedIndex()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                }
            }
            this.filter(aChannel, gEditableArea, this.inversed.isSelected(), n);
        }
        GProgressViewer.exitSubProgress();
    }

    private boolean performMagnitude(GEditableArea gEditableArea, boolean bl, MMArray mMArray, MMArray mMArray2, int n, float f) {
        boolean bl2 = false;
        float f2 = (float)this.amplification.getData();
        for (int i = 0; i < mMArray.getLength() / 2; ++i) {
            boolean bl3 = gEditableArea.isInside(n, (float)i * f / (float)mMArray.getLength());
            if (!(bl3 ^ bl)) continue;
            mMArray.set(i, mMArray.get(i) * f2);
            mMArray2.set(i, mMArray2.get(i) * f2);
            bl2 = true;
        }
        return bl2;
    }

    private boolean performMagnitudeAboveThreshold(GEditableArea gEditableArea, boolean bl, MMArray mMArray, MMArray mMArray2, int n, float f) {
        boolean bl2 = false;
        float f2 = (float)this.amplification.getData();
        float f3 = (float)this.threshold.getData();
        for (int i = 0; i < mMArray.getLength() / 2; ++i) {
            boolean bl3 = gEditableArea.isInside(n, (float)i * f / (float)mMArray.getLength());
            if (!(bl3 ^ bl) || !(AOToolkit.cartesianToMagnitude(mMArray.get(i), mMArray2.get(i)) > f3)) continue;
            mMArray.set(i, mMArray.get(i) * f2);
            mMArray2.set(i, mMArray2.get(i) * f2);
            bl2 = true;
        }
        return bl2;
    }

    private boolean performMagnitudeBelowThreshold(GEditableArea gEditableArea, boolean bl, MMArray mMArray, MMArray mMArray2, int n, float f) {
        boolean bl2 = false;
        float f2 = (float)this.amplification.getData();
        float f3 = (float)this.threshold.getData();
        for (int i = 0; i < mMArray.getLength() / 2; ++i) {
            boolean bl3 = gEditableArea.isInside(n, (float)i * f / (float)mMArray.getLength());
            if (!(bl3 ^ bl) || !(AOToolkit.cartesianToMagnitude(mMArray.get(i), mMArray2.get(i)) < f3)) continue;
            mMArray.set(i, mMArray.get(i) * f2);
            mMArray2.set(i, mMArray2.get(i) * f2);
            bl2 = true;
        }
        return bl2;
    }

    private void filter(AChannel aChannel, GEditableArea gEditableArea, boolean bl, int n) {
        try {
            if (gEditableArea.getNumberOfRectangles() > 0) {
                int n2;
                int n3;
                int n4;
                float f = this.getFocussedClip().getSampleRate();
                MMArray mMArray = aChannel.getSamples();
                int n5 = this.fftLength.getSelectedValue();
                MMArray mMArray2 = new MMArray(n5, 0.0f);
                MMArray mMArray3 = new MMArray(n5, 0.0f);
                aChannel.markChange();
                GProgressViewer.entrySubProgress();
                if (bl) {
                    n4 = 0;
                    n3 = mMArray.getLength();
                } else {
                    n4 = (int)gEditableArea.getXMin();
                    n3 = (int)gEditableArea.getXMax();
                }
                n4 = Math.max(0, n4);
                n3 = Math.min(n3, mMArray.getLength());
                MMArray mMArray4 = new MMArray(n3 - n4, 0.0f);
                int n6 = 3;
                for (n2 = n4 - n5; n2 < n3; n2 += n5 / n6) {
                    int n7;
                    GProgressViewer.setProgress((n2 + 1 - n4) * 100 / (n3 - n4));
                    for (n7 = 0; n7 < n5; ++n7) {
                        if (n2 + n7 >= 0 && n2 + n7 < mMArray.getLength()) {
                            mMArray2.set(n7, mMArray.get(n2 + n7));
                        } else {
                            mMArray2.set(n7, 0.0f);
                        }
                        mMArray3.set(n7, 0.0f);
                    }
                    AOToolkit.applyBlackmanWindow(mMArray2, n5);
                    AOToolkit.complexFft(mMArray2, mMArray3);
                    n7 = 0;
                    switch (n) {
                        case 1: {
                            n7 = this.performMagnitude(gEditableArea, bl, mMArray2, mMArray3, n2, f) ? 1 : 0;
                            break;
                        }
                        case 2: {
                            n7 = this.performMagnitudeAboveThreshold(gEditableArea, bl, mMArray2, mMArray3, n2, f) ? 1 : 0;
                            break;
                        }
                        case 3: {
                            n7 = this.performMagnitudeBelowThreshold(gEditableArea, bl, mMArray2, mMArray3, n2, f) ? 1 : 0;
                        }
                    }
                    AOToolkit.complexIfft(mMArray2, mMArray3);
                    for (int i = 0; i < n5; ++i) {
                        int n8 = n2 - n4 + i;
                        if (n8 < 0 || n8 >= mMArray4.getLength()) continue;
                        mMArray4.set(n8, mMArray4.get(n8) + mMArray2.get(i));
                    }
                }
                for (n2 = n4; n2 < n3; ++n2) {
                    mMArray.set(n2, mMArray4.get(n2 - n4));
                }
                GProgressViewer.exitSubProgress();
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSpectrogramFilter.this.all) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [all] clicked");
                GPSpectrogramFilter.this.onSelectAll();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.copy) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [copy] clicked");
                GPSpectrogramFilter.this.onCopy();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.paste) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [paste] clicked");
                GPSpectrogramFilter.this.onPaste();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.none) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [none] clicked");
                GPSpectrogramFilter.this.onSelectNone();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.apply) {
                GProgressViewer.start(GPSpectrogramFilter.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [apply] clicked");
                GPSpectrogramFilter.this.onApply();
                GProgressViewer.setProgress(100);
                GPSpectrogramFilter.this.updateHistory(GLanguage.translate(GPSpectrogramFilter.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPSpectrogramFilter.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.drawMode) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [draw mode] clicked");
                GPSpectrogramFilter.this.updateComponents();
            } else if (actionEvent.getSource() == GPSpectrogramFilter.this.filterMode) {
                Debug.println(1, "plugin " + GPSpectrogramFilter.this.getName() + " [filter mode] clicked");
                GPSpectrogramFilter.this.updateComponents();
            }
            GPSpectrogramFilter.this.reloadFocussedClipEditor();
        }
    }

    private class GCookieSpectrogramFilter
    extends GCookie {
        public GEditableArea area = new GEditableArea();

        public GCookieSpectrogramFilter(AChannel aChannel) {
            this.area.setChannel(aChannel);
        }
    }
}

