/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPMeasure;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextSF;
import ch.laoe.ui.GLanguage;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPSelectNumeric
extends GPluginFrame {
    private JComboBox mode;
    private UiControlText offset;
    private UiControlText length;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPSelectNumeric(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "selectNumeric";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 12, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("selectMode")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("free"), GLanguage.translate("loopPoints"), GLanguage.translate("measurePoints"), GLanguage.translate("begin"), GLanguage.translate("end")};
        this.mode = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.mode, 4, 0, 8, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("offset")), 0, 1, 4, 1);
        this.offset = new GControlTextSF(this.getMain(), 10, true, true);
        this.offset.setDataRange(-1.0E9, 1.0E9);
        this.offset.setData(0.0);
        uiCartesianLayout.add(this.offset, 4, 1, 8, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("length")), 0, 2, 4, 1);
        this.length = new GControlTextSF(this.getMain(), 10, true, true);
        this.length.setDataRange(-1.0E9, 1.0E9);
        this.length.setData(0.0);
        uiCartesianLayout.add(this.length, 4, 2, 8, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 4, 3, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.mode.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.offset.refresh();
        this.length.refresh();
    }

    private void onModeChange() {
        switch (this.mode.getSelectedIndex()) {
            case 0: {
                this.offset.setEnabled(true);
                this.length.setEnabled(true);
                break;
            }
            case 1: {
                this.offset.setEnabled(false);
                this.length.setEnabled(false);
                break;
            }
            case 2: {
                this.offset.setEnabled(false);
                this.length.setEnabled(false);
                break;
            }
            case 3: 
            case 4: {
                this.offset.setEnabled(false);
                this.length.setEnabled(false);
            }
        }
    }

    private void onApply() {
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        AChannel aChannel = aLayer.getSelectedChannel();
        switch (this.mode.getSelectedIndex()) {
            case 0: {
                aChannel.setChannelSelection(new AChannelSelection(aChannel, (int)this.offset.getData(), (int)this.length.getData()));
                break;
            }
            case 1: {
                aChannel.setChannelSelection(new AChannelSelection(aChannel, aClip.getAudio().getLoopStartPointer(), aClip.getAudio().getLoopEndPointer() - aClip.getAudio().getLoopStartPointer()));
                break;
            }
            case 2: {
                aChannel.setChannelSelection(new AChannelSelection(aChannel, (int)GPMeasure.getLowerCursor(), (int)(GPMeasure.getHigherCursor() - GPMeasure.getLowerCursor())));
                break;
            }
            case 3: {
                aChannel.setChannelSelection(new AChannelSelection(aChannel, 0, 1));
                break;
            }
            case 4: {
                aChannel.setChannelSelection(new AChannelSelection(aChannel, aChannel.getSampleLength() - 1, 1));
            }
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSelectNumeric.this.apply) {
                Debug.println(1, "plugin " + GPSelectNumeric.this.getName() + " [apply] clicked");
                GPSelectNumeric.this.onApply();
                GPSelectNumeric.this.updateHistory(GLanguage.translate(GPSelectNumeric.this.getName()));
                GPSelectNumeric.this.reloadFocussedClipEditor();
            } else if (actionEvent.getSource() == GPSelectNumeric.this.mode) {
                Debug.println(1, "plugin " + GPSelectNumeric.this.getName() + " [mode] clicked");
                GPSelectNumeric.this.onModeChange();
            }
        }
    }
}

