/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelMarker;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPSelect
extends GPluginFrame {
    private Cursor selectionCursor;
    private Cursor tuningSelectionCursor;
    private Cursor deepSelectionCursor;
    private Cursor intensityDrawCursor;
    private Cursor intensityEraseCursor;
    private Cursor markerDrawCursor;
    private Cursor markerEraseCursor;
    private Cursor actualCursor;
    private Point pressedPoint;
    private boolean deepSelection;
    private int startSample;
    private int endSample;
    private int startChannelIndex;
    private int endChannelIndex;
    private AClip clip;
    private ALayer layer;
    private int tuningMode;
    private static final int NO_TUNING = 1;
    private static final int START_TUNING = 2;
    private static final int END_TUNING = 3;
    private static final int tuningXTolerance = 5;
    private boolean snapEnable;
    private int xSnapRange;
    private int intensityPointIndex;
    private AChannelSelection iChannelSelection;
    private AChannelPlotter iChannelPlotter;
    private int markerIndex;
    private AChannelMarker markers;
    private final int markerSnapXDistance = 10;
    private AChannelPlotter markerChp;
    private JTabbedPane tab;
    private JCheckBox snapToZeroCross;
    private UiControlText zeroCrossWidth;
    private JButton fullIntensity;
    private JButton clearMarkers;
    private JButton copyMarkers;
    private JButton pasteMarkers;
    private JButton markersFromSelection;
    private JComboBox intensityScale;
    private EventDispatcher eventDispatcher;
    private AChannelMarker markerClipBoard;

    public GPSelect(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initCursor();
        this.initGlobalSelection();
        this.initIntensitySelection();
        this.initGui();
    }

    @Override
    public String getName() {
        return "select";
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void initCursor() {
        this.selectionCursor = this.createCustomCursor("selectionCursor");
        this.tuningSelectionCursor = this.createCustomCursor("tuningSelectionCursor");
        this.deepSelectionCursor = this.createCustomCursor("deepSelectionCursor");
        this.intensityDrawCursor = this.createCustomCursor("intensityDrawCursor");
        this.intensityEraseCursor = this.createCustomCursor("intensityEraseCursor");
        this.markerDrawCursor = this.createCustomCursor("markerDrawCursor");
        this.markerEraseCursor = this.createCustomCursor("markerEraseCursor");
        this.actualCursor = null;
    }

    private void setCursor(MouseEvent mouseEvent, Cursor cursor) {
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    private void initGlobalSelection() {
    }

    private void updateTuningMode(Point point) {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        int n = aLayer.getLayerPlotter().getInsideChannelIndex(point);
        if (n >= 0) {
            AChannel aChannel = aLayer.getChannel(n);
            AChannelPlotter aChannelPlotter = aChannel.getChannelPlotter();
            AChannelSelection aChannelSelection = aChannel.getChannelSelection();
            int n2 = aChannelPlotter.sampleToGraphX(aChannelSelection.getOffset());
            int n3 = aChannelPlotter.sampleToGraphX(aChannelSelection.getOffset() + aChannelSelection.getLength());
            this.tuningMode = Math.abs(point.x - n2) < 5 ? 2 : (Math.abs(point.x - n3) < 5 ? 3 : 1);
        }
    }

    private void globalSelectionMousePressed(MouseEvent mouseEvent) {
        Debug.println(6, "mouse pressed: start select functionality");
        this.pressedPoint = mouseEvent.getPoint();
        this.clip = this.getFocussedClip();
        this.layer = this.clip.getSelectedLayer();
        this.startChannelIndex = this.layer.getLayerPlotter().getInsideChannelIndex(this.pressedPoint);
        if (this.startChannelIndex >= 0) {
            this.updateTuningMode(mouseEvent.getPoint());
            AChannel aChannel = this.layer.getChannel(this.startChannelIndex);
            AChannelSelection aChannelSelection = aChannel.getChannelSelection();
            AChannelPlotter aChannelPlotter = aChannel.getChannelPlotter();
            int n = (int)aChannelPlotter.graphToSampleX(this.pressedPoint.x);
            if (n < 0) {
                n = 0;
            }
            if (this.snapEnable) {
                this.xSnapRange = (int)(aChannelPlotter.graphToSampleX(this.pressedPoint.x + 20) - (float)n);
                int n2 = AOToolkit.getNearestZeroCrossIndex(this.layer.getChannel(this.endChannelIndex).getSamples(), n, this.xSnapRange);
                if (n2 != -1) {
                    n = n2;
                }
            }
            switch (this.tuningMode) {
                case 1: {
                    this.startSample = n;
                    break;
                }
                case 2: {
                    this.endSample = aChannelSelection.getOffset() + aChannelSelection.getLength();
                    break;
                }
                case 3: {
                    this.startSample = aChannelSelection.getOffset();
                }
            }
            Debug.println(6, "tuning mode = " + this.tuningMode);
            this.deepSelection = GToolkit.isShiftKey(mouseEvent);
        }
    }

    private void globalSelectionMouseDragged(MouseEvent mouseEvent) {
        Debug.println(6, "mouse dragged: create selection");
        Point point = mouseEvent.getPoint();
        this.endChannelIndex = this.layer.getLayerPlotter().getInsideChannelIndex(point);
        if (this.startChannelIndex >= 0 && this.endChannelIndex >= 0) {
            int n;
            int n2 = (int)this.layer.getChannel(this.endChannelIndex).getChannelPlotter().graphToSampleX(point.x);
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.snapEnable && (n = AOToolkit.getNearestZeroCrossIndex(this.layer.getChannel(this.endChannelIndex).getSamples(), n2, this.xSnapRange)) != -1) {
                n2 = n;
            }
            switch (this.tuningMode) {
                case 1: {
                    this.endSample = n2;
                    break;
                }
                case 2: {
                    this.startSample = n2;
                    break;
                }
                case 3: {
                    this.endSample = n2;
                }
            }
            if (this.startChannelIndex > this.endChannelIndex) {
                n = this.startChannelIndex;
                this.startChannelIndex = this.endChannelIndex;
                this.endChannelIndex = n;
            }
            for (n = this.startChannelIndex; n <= this.endChannelIndex; ++n) {
                if (this.deepSelection) {
                    for (int i = 0; i < this.clip.getNumberOfLayers(); ++i) {
                        this.clip.getLayer(i).getChannel(n).modifyChannelSelection(Math.min(this.startSample, this.endSample), Math.abs(this.endSample - this.startSample));
                    }
                    continue;
                }
                this.layer.getChannel(n).modifyChannelSelection(Math.min(this.startSample, this.endSample), Math.abs(this.endSample - this.startSample));
            }
        }
        this.repaintFocussedClipEditor();
        switch (this.tuningMode) {
            case 2: 
            case 3: {
                this.setCursor(mouseEvent, this.tuningSelectionCursor);
            }
        }
    }

    private void globalSelectionMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            Debug.println(6, "mouse clicked: unselect");
            if (this.deepSelection) {
                for (int i = 0; i < this.clip.getNumberOfLayers(); ++i) {
                    this.clip.getLayer(i).getChannel(this.startChannelIndex).setEmptyChannelSelection();
                }
            } else {
                this.layer.getChannel(this.startChannelIndex).setEmptyChannelSelection();
            }
        } else if (mouseEvent.getClickCount() == 2) {
            Debug.println(6, "mouse double-clicked: create marked selection");
            if (this.deepSelection) {
                for (int i = 0; i < this.clip.getNumberOfLayers(); ++i) {
                    this.clip.getLayer(i).getChannel(this.startChannelIndex).setMarkedChannelSelection(this.startSample);
                }
            } else {
                this.layer.getChannel(this.startChannelIndex).setMarkedChannelSelection(this.startSample);
            }
        } else if (mouseEvent.getClickCount() == 3) {
            Debug.println(6, "mouse tripple-clicked: create channel selection");
            if (this.deepSelection) {
                for (int i = 0; i < this.clip.getNumberOfLayers(); ++i) {
                    this.clip.getLayer(i).getChannel(this.startChannelIndex).setFullChannelSelection();
                }
            } else {
                this.layer.getChannel(this.startChannelIndex).setFullChannelSelection();
            }
        } else if (mouseEvent.getClickCount() == 4) {
            Debug.println(6, "mouse quadruple-clicked: create layer selection");
            if (this.deepSelection) {
                for (int i = 0; i < this.clip.getNumberOfLayers(); ++i) {
                    this.clip.getLayer(i).setFullLayerSelection();
                }
            } else {
                this.layer.setFullLayerSelection();
            }
        }
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("range"));
        this.reloadFocussedClipEditor();
    }

    private void globalSelectionMouseReleased(MouseEvent mouseEvent) {
        this.tuningMode = 1;
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("range"));
        this.reloadFocussedClipEditor();
    }

    private void globalSelectionMouseMoved(MouseEvent mouseEvent) {
        this.updateTuningMode(mouseEvent.getPoint());
        if (GToolkit.isShiftKey(mouseEvent)) {
            this.setCursor(mouseEvent, this.deepSelectionCursor);
        } else if (this.tuningMode != 1) {
            this.setCursor(mouseEvent, this.tuningSelectionCursor);
        } else {
            this.setCursor(mouseEvent, this.selectionCursor);
        }
    }

    private void initIntensitySelection() {
    }

    private float toNormalizedX(int n) {
        float f = (this.iChannelPlotter.graphToSampleX(n) - (float)this.iChannelSelection.getOffset()) / (float)this.iChannelSelection.getLength();
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    private float toNormalizedY(int n) {
        float f = 1.0f - (float)(((double)n - this.iChannelPlotter.getRectangle().getY()) / this.iChannelPlotter.getRectangle().getHeight());
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    private void intensitySelectionMousePressed(MouseEvent mouseEvent) {
        Debug.println(6, "mouse pressed: find intensity point");
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        int n = aLayer.getLayerPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        if (n >= 0) {
            AChannel aChannel = aLayer.getChannel(n);
            this.iChannelSelection = aChannel.getChannelSelection();
            this.iChannelPlotter = aChannel.getChannelPlotter();
            this.intensityPointIndex = this.iChannelSelection.searchNearestIntensityPointIndex(this.toNormalizedX(mouseEvent.getPoint().x));
        }
    }

    private void intensitySelectionMouseReleased(MouseEvent mouseEvent) {
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("intensity"));
        this.reloadFocussedClipEditor();
    }

    private void intensitySelectionMouseClicked(MouseEvent mouseEvent) {
        float f = this.toNormalizedX(mouseEvent.getPoint().x);
        float f2 = this.toNormalizedY(mouseEvent.getPoint().y);
        if (GToolkit.isShiftKey(mouseEvent)) {
            this.iChannelSelection.removeIntensityPoint(f);
        } else {
            this.iChannelSelection.addIntensityPoint(f, f2);
        }
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("intensity"));
        this.reloadFocussedClipEditor();
    }

    private void intensitySelectionMouseMoved(MouseEvent mouseEvent) {
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        int n = aLayer.getLayerPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        if (n >= 0) {
            AChannel aChannel = aLayer.getChannel(n);
            this.iChannelSelection = aChannel.getChannelSelection();
            this.iChannelPlotter = aChannel.getChannelPlotter();
            this.intensityPointIndex = this.iChannelSelection.searchNearestIntensityPointIndex(this.toNormalizedX(mouseEvent.getPoint().x));
            float f = this.toNormalizedX(mouseEvent.getPoint().x);
            this.iChannelSelection.setActiveIntensityPoint(f);
            this.repaintFocussedClipEditor();
        }
        if (GToolkit.isShiftKey(mouseEvent)) {
            this.setCursor(mouseEvent, this.intensityEraseCursor);
        } else {
            this.setCursor(mouseEvent, this.intensityDrawCursor);
        }
    }

    private void intensitySelectionMouseDragged(MouseEvent mouseEvent) {
        float f = this.toNormalizedX(mouseEvent.getPoint().x);
        float f2 = this.toNormalizedY(mouseEvent.getPoint().y);
        this.iChannelSelection.modifyIntensityPoint(this.intensityPointIndex, f, f2);
        this.repaintFocussedClipEditor();
    }

    private void markersMousePressed(MouseEvent mouseEvent) {
        Debug.println(6, "mouse pressed: find marker");
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        int n = aLayer.getLayerPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        if (n >= 0) {
            AChannel aChannel = aLayer.getChannel(n);
            this.markerChp = aChannel.getChannelPlotter();
            this.markers = aChannel.getMarker();
            this.markerIndex = this.markers.searchNearestIndex((int)this.markerChp.graphToSampleX(mouseEvent.getPoint().x), (int)Math.abs(this.markerChp.graphToSampleX(mouseEvent.getPoint().x + 10) - this.markerChp.graphToSampleX(mouseEvent.getPoint().x)));
        }
    }

    private void markersMouseReleased(MouseEvent mouseEvent) {
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("markers"));
        this.reloadFocussedClipEditor();
    }

    private void markersMouseClicked(MouseEvent mouseEvent) {
        if (GToolkit.isShiftKey(mouseEvent)) {
            this.markers.removeMarker(this.markerIndex);
        } else {
            this.markers.addMarker((int)this.markerChp.graphToSampleX(mouseEvent.getPoint().x));
        }
        this.updateHistory(GLanguage.translate(this.getName()) + " " + GLanguage.translate("markers"));
        this.reloadFocussedClipEditor();
    }

    private void markersMouseMoved(MouseEvent mouseEvent) {
        if (GToolkit.isShiftKey(mouseEvent)) {
            this.setCursor(mouseEvent, this.markerEraseCursor);
        } else {
            this.setCursor(mouseEvent, this.markerDrawCursor);
        }
    }

    private void markersMouseDragged(MouseEvent mouseEvent) {
        Debug.println(6, "mouse dragged: move marker");
        if (this.markerIndex >= 0) {
            this.markers.moveMarker(this.markerIndex, (int)this.markerChp.graphToSampleX(mouseEvent.getPoint().x));
        }
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.globalSelectionMousePressed(mouseEvent);
                break;
            }
            case 1: {
                this.intensitySelectionMousePressed(mouseEvent);
                break;
            }
            case 2: {
                this.markersMousePressed(mouseEvent);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.globalSelectionMouseDragged(mouseEvent);
                break;
            }
            case 1: {
                this.intensitySelectionMouseDragged(mouseEvent);
                break;
            }
            case 2: {
                this.markersMouseDragged(mouseEvent);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.globalSelectionMouseClicked(mouseEvent);
                break;
            }
            case 1: {
                this.intensitySelectionMouseClicked(mouseEvent);
                break;
            }
            case 2: {
                this.markersMouseClicked(mouseEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.actualCursor = null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.globalSelectionMouseReleased(mouseEvent);
                break;
            }
            case 1: {
                this.intensitySelectionMouseReleased(mouseEvent);
                break;
            }
            case 2: {
                this.markersMouseReleased(mouseEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.globalSelectionMouseMoved(mouseEvent);
                break;
            }
            case 1: {
                this.intensitySelectionMouseMoved(mouseEvent);
                break;
            }
            case 2: {
                this.markersMouseMoved(mouseEvent);
            }
        }
    }

    public void initGui() {
        this.tab = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 8, 3);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.snapToZeroCross = new JCheckBox(GLanguage.translate("snapToZeroCross"));
        uiCartesianLayout.add(this.snapToZeroCross, 0, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("zeroCrossWidth")), 0, 2, 4, 1);
        this.zeroCrossWidth = new GControlTextX(this.getMain(), 8, true, true);
        this.zeroCrossWidth.setData(AOToolkit.getZeroCrossWidth());
        this.zeroCrossWidth.setDataRange(0.0, 300.0);
        this.zeroCrossWidth.setUnit(" ");
        uiCartesianLayout.add(this.zeroCrossWidth, 4, 2, 4, 1);
        this.tab.add((Component)jPanel, GLanguage.translate("range"));
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 8, 3);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(30, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("scale")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("squareRoot"), GLanguage.translate("linear"), GLanguage.translate("square"), GLanguage.translate("cubic")};
        this.intensityScale = new JComboBox<String>(stringArray);
        this.intensityScale.setSelectedIndex(1);
        uiCartesianLayout2.add(this.intensityScale, 4, 0, 4, 1);
        this.fullIntensity = new JButton(GLanguage.translate("clear"));
        uiCartesianLayout2.add(this.fullIntensity, 2, 2, 4, 1);
        this.tab.add((Component)jPanel2, GLanguage.translate("intensity"));
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 8, 3);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(30, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        this.copyMarkers = new JButton(GLanguage.translate("copy"));
        uiCartesianLayout3.add(this.copyMarkers, 0, 0, 4, 1);
        this.pasteMarkers = new JButton(GLanguage.translate("paste"));
        uiCartesianLayout3.add(this.pasteMarkers, 4, 0, 4, 1);
        this.markersFromSelection = new JButton(GLanguage.translate("fromSelection"));
        uiCartesianLayout3.add(this.markersFromSelection, 0, 1, 4, 1);
        this.clearMarkers = new JButton(GLanguage.translate("clear"));
        uiCartesianLayout3.add(this.clearMarkers, 2, 2, 4, 1);
        this.tab.add((Component)jPanel3, GLanguage.translate("markers"));
        this.frame.getContentPane().add(this.tab);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.snapToZeroCross.addActionListener(this.eventDispatcher);
        this.fullIntensity.addActionListener(this.eventDispatcher);
        this.intensityScale.addActionListener(this.eventDispatcher);
        this.zeroCrossWidth.addControlListener(this.eventDispatcher);
        this.copyMarkers.addActionListener(this.eventDispatcher);
        this.pasteMarkers.addActionListener(this.eventDispatcher);
        this.markersFromSelection.addActionListener(this.eventDispatcher);
        this.clearMarkers.addActionListener(this.eventDispatcher);
        this.onIntensityScale();
    }

    @Override
    public void reload() {
        super.reload();
        this.zeroCrossWidth.refresh();
    }

    private void onIntensityScale() {
        int n;
        switch (this.intensityScale.getSelectedIndex()) {
            case 0: {
                n = -1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                n = 1;
            }
        }
        AChannelSelection.setIntensityScale(n);
    }

    private void onFullIntensity() {
        this.getFocussedClip().getSelectedLayer().getSelectedChannel().getChannelSelection().clearIntensity();
        this.repaintFocussedClipEditor();
    }

    private void onCopyMarkers() {
        this.markerClipBoard = new AChannelMarker(this.getFocussedClip().getSelectedLayer().getSelectedChannel().getMarker());
    }

    private void onPasteMarkers() {
        this.getFocussedClip().getSelectedLayer().getSelectedChannel().setMarker(new AChannelMarker(this.markerClipBoard));
        this.repaintFocussedClipEditor();
    }

    private void onMarkersFromSelection() {
        AChannel aChannel = this.getFocussedClip().getSelectedLayer().getSelectedChannel();
        aChannel.getMarker().addMarkerFromSelection(aChannel.getChannelSelection());
        this.repaintFocussedClipEditor();
    }

    private void onClearMarkers() {
        this.getFocussedClip().getSelectedLayer().getSelectedChannel().getMarker().clear();
        this.repaintFocussedClipEditor();
    }

    private class EventDispatcher
    implements ActionListener,
    UiControlListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSelect.this.snapToZeroCross) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [snap to zerocross] clicked");
                GPSelect.this.snapEnable = GPSelect.this.snapToZeroCross.isSelected();
            } else if (actionEvent.getSource() == GPSelect.this.fullIntensity) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [full intensity] clicked");
                GPSelect.this.onFullIntensity();
            } else if (actionEvent.getSource() == GPSelect.this.intensityScale) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [intensity scale] clicked");
                GPSelect.this.onIntensityScale();
            } else if (actionEvent.getSource() == GPSelect.this.copyMarkers) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [copy markers] clicked");
                GPSelect.this.onCopyMarkers();
            } else if (actionEvent.getSource() == GPSelect.this.pasteMarkers) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [paste markers] clicked");
                GPSelect.this.onPasteMarkers();
            } else if (actionEvent.getSource() == GPSelect.this.markersFromSelection) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [from selection] clicked");
                GPSelect.this.onMarkersFromSelection();
            } else if (actionEvent.getSource() == GPSelect.this.clearMarkers) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [clear markers] clicked");
                GPSelect.this.onClearMarkers();
            }
        }

        @Override
        public void onDataChanged(UiControlEvent uiControlEvent) {
            if (uiControlEvent.getSource() == GPSelect.this.zeroCrossWidth) {
                Debug.println(1, "plugin " + GPSelect.this.getName() + " [zerocross width] changed");
                AOToolkit.setZeroCrossWidth((int)GPSelect.this.zeroCrossWidth.getData());
            }
        }

        @Override
        public void onDataChanging(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onValidate(UiControlEvent uiControlEvent) {
        }
    }
}

