/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOReverse;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPReverse
extends GPluginFrame {
    private String[] mirrorTypeItem = new String[]{GLanguage.translate("mirrorRightSide"), GLanguage.translate("mirrorLeftSide"), GLanguage.translate("reverse")};
    private JComboBox mirrorType;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPReverse(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "reverse";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode") + ":"), 0, 0, 4, 1);
        this.mirrorType = new JComboBox<String>(this.mirrorTypeItem);
        this.mirrorType.setSelectedIndex(2);
        uiCartesianLayout.add(this.mirrorType, 4, 0, 6, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 1, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        switch (this.mirrorType.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOReverse(2));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AOReverse(1));
                this.pluginHandler.getFocussedClip().getSelectedLayer().setEmptyLayerSelection();
                break;
            }
            case 2: {
                aLayerSelection.operateEachChannel(new AOReverse(3));
            }
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPReverse.this.apply) {
                GProgressViewer.start(GPReverse.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPReverse.this.getName() + " [apply] clicked");
                GPReverse.this.onApply();
                GProgressViewer.setProgress(100);
                GPReverse.this.updateHistory(GLanguage.translate(GPReverse.this.getName()));
                GPReverse.this.pluginHandler.getFocussedClipEditor().reload();
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPReverse.this.reloadFocussedClipEditor();
                GPReverse.this.autoCloseNow();
            }
        }
    }
}

