/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOMultiReverb;
import ch.laoe.operation.AOReverb;
import ch.laoe.operation.AOReverbAllPass;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class GPReverb
extends GPluginFrame {
    private JCheckBox allPass;
    private JCheckBox negFeedback;
    private JCheckBox backwardConst;
    private JCheckBox backwardVar;
    private JComboBox room;
    private JComboBox reverbType;
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText gain;
    private UiControlText delay;
    private JTable shape;
    private JButton applyConst;
    private JButton applyVar;
    private GClipLayerChooser layerChooser;
    private EventDispatcher eventDispatcher;
    private Preset[] presets;
    private int presetIndex = 0;
    private static final int maxRows = 50;

    public GPReverb(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        try {
            this.initGui();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "reverb";
    }

    private void loadPresets() {
        try {
            PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
            try {
                ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
            this.presets = new Preset[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                this.presets[i] = new Preset();
                this.presets[i].name = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
                this.presets[i].dry = ((Persistence)persistenceDefaultImpl).getFloat("dry_" + i);
                this.presets[i].wet = ((Persistence)persistenceDefaultImpl).getFloat("wet_" + i);
                this.presets[i].delay = ((Persistence)persistenceDefaultImpl).getFloat("delay_" + i);
                this.presets[i].gain = ((Persistence)persistenceDefaultImpl).getFloat("gain_" + i);
                this.presets[i].delayShape = new double[((Persistence)persistenceDefaultImpl).getInt("shapeWidth_" + i)];
                for (n2 = 0; n2 < this.presets[i].delayShape.length; ++n2) {
                    this.presets[i].delayShape[n2] = ((Persistence)persistenceDefaultImpl).getDouble("delayShape_" + i + "_" + n2);
                }
                this.presets[i].gainShape = new double[((Persistence)persistenceDefaultImpl).getInt("shapeWidth_" + i)];
                for (n2 = 0; n2 < this.presets[i].gainShape.length; ++n2) {
                    this.presets[i].gainShape[n2] = ((Persistence)persistenceDefaultImpl).getDouble("gainShape_" + i + "_" + n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initGui() {
        this.loadPresets();
        JPanel jPanel = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel2, 10, 13);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("room")), 0, 0, 4, 1);
        String[] stringArray = new String[this.presets.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.presets[i].name;
        }
        this.room = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.room, 4, 0, 6, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("comb"), GLanguage.translate("allpass"), GLanguage.translate("multi")};
        uiCartesianLayout.add(new JLabel(GLanguage.translate("reverbType")), 0, 1, 4, 1);
        this.reverbType = new JComboBox<String>(stringArray2);
        uiCartesianLayout.add(this.reverbType, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 2, 4, 1);
        this.dry = new GControlTextA(7, true, true);
        this.dry.setDataRange(-1.0, 1.0);
        this.dry.setData(1.0);
        uiCartesianLayout.add(this.dry, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 3, 4, 1);
        this.wet = new GControlTextA(7, true, true);
        this.wet.setDataRange(-1.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 4, 3, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("delay")), 0, 4, 4, 1);
        this.delay = new GControlTextX(this.getMain(), 7, true, true);
        this.delay.setDataRange(1.0, 1.0E9);
        this.delay.setData(1.0);
        this.delay.setUnit("ms");
        uiCartesianLayout.add(this.delay, 4, 4, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("gain")), 0, 5, 4, 1);
        this.gain = new GControlTextA(7, true, true);
        this.gain.setDataRange(-1.0, 1.0);
        this.gain.setData(1.0);
        uiCartesianLayout.add(this.gain, 4, 5, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shape")), 0, 6, 4, 1);
        Object[] objectArray = new String[]{GLanguage.translate("delay"), GLanguage.translate("gain")};
        this.shape = new JTable(new Object[50][2], objectArray);
        JScrollPane jScrollPane = new JScrollPane(this.shape);
        this.shape.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 7, 10, 4);
        this.onRoomChange();
        this.negFeedback = new JCheckBox(GLanguage.translate("negativeFeedback"));
        uiCartesianLayout.add(this.negFeedback, 0, 11, 5, 1);
        this.backwardConst = new JCheckBox(GLanguage.translate("backward"));
        uiCartesianLayout.add(this.backwardConst, 5, 11, 5, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 3, 12, 4, 1);
        jTabbedPane.add(GLanguage.translate("standard"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel3, 10, 13);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(this.getMain(), "room");
        uiCartesianLayout2.add(this.layerChooser, 0, 0, 10, 3);
        this.backwardVar = new JCheckBox(GLanguage.translate("backward"));
        uiCartesianLayout2.add(this.backwardVar, 4, 3, 6, 1);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applyVar, 3, 12, 4, 1);
        jTabbedPane.add(GLanguage.translate("curve"), jPanel3);
        jPanel.add(jTabbedPane);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyConst.addActionListener(this.eventDispatcher);
        this.applyVar.addActionListener(this.eventDispatcher);
        this.reverbType.addActionListener(this.eventDispatcher);
        this.room.addActionListener(this.eventDispatcher);
        this.updateGui();
    }

    private void loadReverbPoints(double[] dArray, double[] dArray2) {
        for (int i = 0; i < 50; ++i) {
            if (i < dArray.length) {
                this.shape.setValueAt(String.valueOf(dArray[i]), i, 0);
                this.shape.setValueAt(String.valueOf(dArray2[i]), i, 1);
                continue;
            }
            this.shape.setValueAt("", i, 0);
            this.shape.setValueAt("", i, 1);
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.delay.refresh();
        this.dry.refresh();
        this.gain.refresh();
        this.wet.refresh();
    }

    private void onRoomChange() {
        this.presetIndex = this.room.getSelectedIndex();
        this.dry.setData(this.presets[this.presetIndex].dry);
        this.wet.setData(this.presets[this.presetIndex].wet);
        this.delay.setData(this.presets[this.presetIndex].delay);
        this.gain.setData(this.presets[this.presetIndex].gain);
        this.loadReverbPoints(this.presets[this.presetIndex].delayShape, this.presets[this.presetIndex].gainShape);
    }

    private void updateGui() {
        this.shape.setEnabled(this.reverbType.getSelectedIndex() == 2);
    }

    private void onApplyMulti() {
        int n = 0;
        for (int i = 0; i < this.shape.getRowCount(); ++i) {
            try {
                Float.parseFloat((String)this.shape.getValueAt(i, 0));
                ++n;
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        MMArray mMArray = new MMArray(n, 0.0f);
        MMArray mMArray2 = new MMArray(n, 0.0f);
        for (int i = 0; i < n; ++i) {
            try {
                mMArray.set(i, Float.parseFloat((String)this.shape.getValueAt(i, 0)));
                mMArray2.set(i, Float.parseFloat((String)this.shape.getValueAt(i, 1)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        aLayerSelection.operateEachChannel(new AOMultiReverb((int)this.delay.getData(), (float)this.gain.getData(), mMArray, mMArray2, (float)this.dry.getData(), (float)this.wet.getData(), this.negFeedback.isSelected(), this.backwardConst.isSelected()));
    }

    private void onApplyConst() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        switch (this.reverbType.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOReverb((int)this.delay.getData(), (float)this.gain.getData(), (float)this.dry.getData(), (float)this.wet.getData(), this.negFeedback.isSelected(), this.backwardConst.isSelected()));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AOReverbAllPass((int)this.delay.getData(), (float)this.gain.getData(), (float)this.dry.getData(), (float)this.wet.getData(), this.backwardConst.isSelected()));
                break;
            }
            case 2: {
                this.onApplyMulti();
            }
        }
    }

    private void onApplyVar() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createLayerSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AOMultiReverb(0.0f, 1.0f, this.backwardVar.isSelected()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPReverb.this.applyConst) {
                GProgressViewer.start(GPReverb.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPReverb.this.getName() + " [apply const] clicked");
                GPReverb.this.onApplyConst();
                GProgressViewer.setProgress(100);
                GPReverb.this.updateHistory(GLanguage.translate(GPReverb.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPReverb.this.reloadFocussedClipEditor();
                GPReverb.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPReverb.this.applyVar) {
                GProgressViewer.start(GPReverb.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPReverb.this.getName() + " [apply var] clicked");
                GPReverb.this.onApplyVar();
                GProgressViewer.setProgress(100);
                GPReverb.this.updateHistory(GLanguage.translate(GPReverb.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPReverb.this.reloadFocussedClipEditor();
                GPReverb.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPReverb.this.reverbType) {
                Debug.println(1, "plugin " + GPReverb.this.getName() + " [reverb type] clicked");
                GPReverb.this.updateGui();
            } else if (actionEvent.getSource() == GPReverb.this.room) {
                Debug.println(1, "plugin " + GPReverb.this.getName() + " [room changed] clicked");
                GPReverb.this.onRoomChange();
            }
        }
    }

    private class Preset {
        public String name;
        public float dry;
        public float wet;
        public float delay;
        public float gain;
        public double[] delayShape;
        public double[] gainShape;

        private Preset() {
        }
    }
}

