/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOResample;
import ch.laoe.operation.AOSweepResample;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextAF;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;

public class GPResample
extends GPluginFrame {
    private JComboBox cOrder;
    private JComboBox vOrder;
    private JComboBox swOrder;
    private JRadioButton bySampleRate;
    private JRadioButton byFactor;
    private UiControlText sampleRate;
    private UiControlText factor;
    private UiControlText beginFactor;
    private UiControlText endFactor;
    private JButton applyConst;
    private JButton applySweep;
    private JButton applyVar;
    private GClipLayerChooser layerChooser;
    private EventDispatcher eventDispatcher;

    public GPResample(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "resample";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.bySampleRate = new JRadioButton(GLanguage.translate("sampleRate"));
        uiCartesianLayout.add(this.bySampleRate, 0, 0, 4, 1);
        this.byFactor = new JRadioButton(GLanguage.translate("factor"));
        uiCartesianLayout.add(this.byFactor, 0, 1, 4, 1);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bySampleRate);
        buttonGroup.add(this.byFactor);
        this.bySampleRate.setSelected(true);
        this.sampleRate = new UiControlText(7, true, false);
        this.sampleRate.setDataRange(100.0, 100000.0);
        uiCartesianLayout.add(this.sampleRate, 4, 0, 5, 1);
        this.factor = new GControlTextAF(7, true, true);
        this.factor.setDataRange(1.0E-4, 1000.0);
        this.factor.setData(1.0);
        uiCartesianLayout.add(this.factor, 4, 1, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("0Order"), GLanguage.translate("1Order"), GLanguage.translate("2Order"), GLanguage.translate("3Order")};
        this.cOrder = new JComboBox<String>(stringArray);
        this.cOrder.setSelectedIndex(3);
        uiCartesianLayout.add(this.cOrder, 0, 2, 4, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("beginFactor")), 0, 0, 4, 1);
        this.beginFactor = new GControlTextAF(7, true, true);
        this.beginFactor.setDataRange(1.0E-4, 1000.0);
        this.beginFactor.setData(1.0);
        uiCartesianLayout2.add(this.beginFactor, 4, 0, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("endFactor")), 0, 1, 4, 1);
        this.endFactor = new GControlTextAF(7, true, true);
        this.endFactor.setDataRange(1.0E-4, 1000.0);
        this.endFactor.setData(1.0);
        uiCartesianLayout2.add(this.endFactor, 4, 1, 5, 1);
        this.swOrder = new JComboBox<String>(stringArray);
        this.swOrder.setSelectedIndex(3);
        uiCartesianLayout2.add(this.swOrder, 6, 3, 4, 1);
        this.applySweep = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applySweep, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("sweep"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 5);
        jPanel3.setLayout(uiCartesianLayout3);
        this.layerChooser = new GClipLayerChooser(this.getMain(), "resampleCurve");
        uiCartesianLayout3.add(this.layerChooser, 0, 0, 10, 3);
        this.vOrder = new JComboBox<String>(stringArray);
        this.vOrder.setSelectedIndex(3);
        uiCartesianLayout3.add(this.vOrder, 6, 3, 4, 1);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.applyVar, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("f(time)"), jPanel3);
        this.updateActiveComponents();
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyConst.addActionListener(this.eventDispatcher);
        this.applyVar.addActionListener(this.eventDispatcher);
        this.applySweep.addActionListener(this.eventDispatcher);
        this.bySampleRate.addActionListener(this.eventDispatcher);
        this.byFactor.addActionListener(this.eventDispatcher);
    }

    private void updateActiveComponents() {
        if (this.bySampleRate.isSelected()) {
            this.sampleRate.setEnabled(true);
            this.factor.setEnabled(false);
        } else if (this.byFactor.isSelected()) {
            this.sampleRate.setEnabled(false);
            this.factor.setEnabled(true);
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.sampleRate.setData(this.getFocussedClip().getSampleRate());
        this.factor.refresh();
        this.beginFactor.refresh();
        this.endFactor.refresh();
    }

    private void onApplyConst() {
        float f = 1.0f;
        if (this.bySampleRate.isSelected()) {
            f = this.getFocussedClip().getSampleRate() / (float)this.sampleRate.getData();
            this.getFocussedClip().setSampleRate((float)this.sampleRate.getData());
        } else if (this.byFactor.isSelected()) {
            f = (float)this.factor.getData();
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(new AOResample(f, this.cOrder.getSelectedIndex()));
    }

    private void onApplyVar() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createLayerSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AOResample(this.vOrder.getSelectedIndex()));
    }

    private void onApplySweep() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(new AOSweepResample((float)this.beginFactor.getData(), (float)this.endFactor.getData(), this.swOrder.getSelectedIndex()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPResample.this.bySampleRate) {
                Debug.println(1, "plugin " + GPResample.this.getName() + " [by samplerate] clicked");
                GPResample.this.updateActiveComponents();
            } else if (actionEvent.getSource() == GPResample.this.byFactor) {
                Debug.println(1, "plugin " + GPResample.this.getName() + " [by factor] clicked");
                GPResample.this.updateActiveComponents();
            } else if (actionEvent.getSource() == GPResample.this.applyConst) {
                GProgressViewer.start(GPResample.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPResample.this.getName() + " [apply const] clicked");
                GPResample.this.onApplyConst();
                GProgressViewer.setProgress(100);
                GPResample.this.pluginHandler.getFocussedClip().getSelectedLayer().setEmptyLayerSelection();
                GPResample.this.autoScaleFocussedClip();
                GPResample.this.updateHistory(GLanguage.translate(GPResample.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPResample.this.reloadFocussedClipEditor();
                GPResample.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPResample.this.applyVar) {
                GProgressViewer.start(GPResample.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPResample.this.getName() + " [apply var] clicked");
                GPResample.this.onApplyVar();
                GProgressViewer.setProgress(100);
                GPResample.this.pluginHandler.getFocussedClip().getSelectedLayer().setEmptyLayerSelection();
                GPResample.this.autoScaleFocussedClip();
                GPResample.this.updateHistory(GLanguage.translate(GPResample.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPResample.this.reloadFocussedClipEditor();
                GPResample.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPResample.this.applySweep) {
                GProgressViewer.start(GPResample.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPResample.this.getName() + " [apply sweep] clicked");
                GPResample.this.onApplySweep();
                GProgressViewer.setProgress(100);
                GPResample.this.pluginHandler.getFocussedClip().getSelectedLayer().setEmptyLayerSelection();
                GPResample.this.autoScaleFocussedClip();
                GPResample.this.updateHistory(GLanguage.translate(GPResample.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPResample.this.reloadFocussedClipEditor();
                GPResample.this.autoCloseNow();
            }
        }
    }
}

