/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOPitchGenerator;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPPitchGenerator
extends GPluginFrame {
    private JButton createBaseSignalConst;
    private UiControlText constPitch;
    private JButton applyConst;
    private JButton createBaseSignalVar;
    private GClipLayerChooser layerChooser;
    private JButton applyVar;
    private EventDispatcher eventDispatcher;
    private GClipEditor baseSignalClipEditor;

    public GPPitchGenerator(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "pitchGenerator";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("pitch")), 0, 0, 4, 1);
        this.constPitch = new GControlTextA(10, true, true);
        this.constPitch.setDataRange(-100.0, 100.0);
        this.constPitch.setData(1.0);
        uiCartesianLayout.add(this.constPitch, 4, 0, 6, 1);
        this.createBaseSignalConst = new JButton(GLanguage.translate("new"));
        uiCartesianLayout.add(this.createBaseSignalConst, 1, 4, 4, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 5, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(this.getMain(), "pitchCurve");
        uiCartesianLayout2.add(this.layerChooser, 0, 0, 10, 3);
        this.createBaseSignalVar = new JButton(GLanguage.translate("new"));
        uiCartesianLayout2.add(this.createBaseSignalVar, 1, 4, 4, 1);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applyVar, 5, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("f(time)"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyConst.addActionListener(this.eventDispatcher);
        this.applyVar.addActionListener(this.eventDispatcher);
        this.createBaseSignalConst.addActionListener(this.eventDispatcher);
        this.createBaseSignalVar.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.constPitch.refresh();
    }

    private void onCreateBaseSignal() {
        AClip aClip = new AClip(1, 1, 1000);
        aClip.setName("<" + GLanguage.translate("pitchGeneratorBaseSignal") + ">");
        aClip.setSampleRate(this.getFocussedClip().getSampleRate());
        this.getMain().addClipFrame(aClip);
        this.baseSignalClipEditor = this.getFocussedClipEditor();
    }

    private void onApplyConst() {
        if (this.baseSignalClipEditor != null) {
            MMArray mMArray = this.baseSignalClipEditor.getClip().getLayer(0).getChannel(0).getSamples();
            ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
            aLayerSelection.operateEachChannel(new AOPitchGenerator(mMArray, (float)this.constPitch.getData()));
        }
    }

    private void onApplyVar() {
        if (this.baseSignalClipEditor != null) {
            MMArray mMArray = this.baseSignalClipEditor.getClip().getLayer(0).getChannel(0).getSamples();
            AClipSelection aClipSelection = new AClipSelection(new AClip());
            aClipSelection.addLayerSelection(this.getFocussedClip().getSelectedLayer().getLayerSelection());
            aClipSelection.addLayerSelection(this.layerChooser.getSelectedLayer().createLayerSelection());
            aClipSelection.operateLayer0WithLayer1(new AOPitchGenerator(mMArray));
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPPitchGenerator.this.applyConst) {
                GProgressViewer.start(GPPitchGenerator.this.getName());
                Debug.println(1, "plugin " + GPPitchGenerator.this.getName() + " [apply const] clicked");
                GPPitchGenerator.this.onApplyConst();
                GPPitchGenerator.this.updateHistory(GLanguage.translate(GPPitchGenerator.this.getName()));
                GProgressViewer.finish();
                GPPitchGenerator.this.reloadFocussedClipEditor();
                GPPitchGenerator.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPPitchGenerator.this.applyVar) {
                GProgressViewer.start(GPPitchGenerator.this.getName());
                Debug.println(1, "plugin " + GPPitchGenerator.this.getName() + " [apply var] clicked");
                GPPitchGenerator.this.onApplyVar();
                GPPitchGenerator.this.updateHistory(GLanguage.translate(GPPitchGenerator.this.getName()));
                GProgressViewer.finish();
                GPPitchGenerator.this.reloadFocussedClipEditor();
                GPPitchGenerator.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPPitchGenerator.this.createBaseSignalConst) {
                Debug.println(1, "plugin " + GPPitchGenerator.this.getName() + " [create base signal const] clicked");
                GPPitchGenerator.this.onCreateBaseSignal();
            } else if (actionEvent.getSource() == GPPitchGenerator.this.createBaseSignalVar) {
                Debug.println(1, "plugin " + GPPitchGenerator.this.getName() + " [create base signal var] clicked");
                GPPitchGenerator.this.onCreateBaseSignal();
            }
        }
    }
}

