/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GPOptions
extends GPluginFrame {
    private JTree tree;
    private JPanel nodePanel;
    private JTextField language;
    private UiControlText debugTraceLevel;
    private JCheckBox undoHistoryEnable;
    private JCheckBox undoHistoryCompression;
    private JCheckBox mainFrameAlwaysOnTop;
    private JCheckBox pluginAutoClose;
    private UiControlText clipWidth;
    private UiControlText clipHeight;
    private JTextArea defaultComment;
    private UiControlText fontSize;
    private JComboBox font;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPOptions(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.restoreOptions();
    }

    @Override
    public String getName() {
        return "laoeOptions";
    }

    private void initGui() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(GLanguage.translate("laoe"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(GLanguage.translate("general"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        OptionNode optionNode = new OptionNode(GLanguage.translate("font"));
        defaultMutableTreeNode2.add(optionNode);
        optionNode.add(new JLabel(GLanguage.translate("font")), 0, 0, 3, 1);
        this.font = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        optionNode.add(this.font, 3, 0, 5, 1);
        optionNode.add(new JLabel(GLanguage.translate("size")), 0, 1, 3, 1);
        this.fontSize = new UiControlText(5, true, false);
        optionNode.add(this.fontSize, 3, 1, 4, 1);
        OptionNode optionNode2 = new OptionNode(GLanguage.translate("language"));
        defaultMutableTreeNode2.add(optionNode2);
        optionNode2.add(new JLabel(GLanguage.translate("language")), 0, 0, 4, 1);
        this.language = new JTextField(7);
        optionNode2.add(this.language, 4, 0, 4, 1);
        OptionNode optionNode3 = new OptionNode(GLanguage.translate("debug"));
        defaultMutableTreeNode2.add(optionNode3);
        optionNode3.add(new JLabel(GLanguage.translate("verboseLevel")), 0, 0, 4, 1);
        this.debugTraceLevel = new UiControlText(7, true, false);
        this.debugTraceLevel.setDataRange(0.0, 10.0);
        optionNode3.add(this.debugTraceLevel, 4, 0, 4, 1);
        OptionNode optionNode4 = new OptionNode(GLanguage.translate("undoStack"));
        defaultMutableTreeNode2.add(optionNode4);
        this.undoHistoryEnable = new JCheckBox(GLanguage.translate("enable"));
        optionNode4.add(this.undoHistoryEnable, 0, 0, 5, 1);
        this.undoHistoryCompression = new JCheckBox(GLanguage.translate("compression"));
        optionNode4.add(this.undoHistoryCompression, 0, 1, 5, 1);
        OptionNode optionNode5 = new OptionNode(GLanguage.translate("mainFrame"));
        defaultMutableTreeNode.add(optionNode5);
        this.mainFrameAlwaysOnTop = new JCheckBox(GLanguage.translate("alwaysOnTop"));
        optionNode5.add(this.mainFrameAlwaysOnTop, 0, 0, 5, 1);
        OptionNode optionNode6 = new OptionNode(GLanguage.translate("plugins"));
        defaultMutableTreeNode.add(optionNode6);
        this.pluginAutoClose = new JCheckBox(GLanguage.translate("autoClose"));
        optionNode6.add(this.pluginAutoClose, 0, 0, 5, 1);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(GLanguage.translate("clip"));
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        OptionNode optionNode7 = new OptionNode(GLanguage.translate("frameSize"));
        defaultMutableTreeNode3.add(optionNode7);
        optionNode7.add(new JLabel(GLanguage.translate("width")), 0, 0, 4, 1);
        this.clipWidth = new UiControlText(7, true, false);
        this.clipWidth.setDataRange(30.0, 1000.0);
        optionNode7.add(this.clipWidth, 4, 0, 4, 1);
        optionNode7.add(new JLabel(GLanguage.translate("height")), 0, 1, 4, 1);
        this.clipHeight = new UiControlText(7, true, false);
        this.clipHeight.setDataRange(30.0, 700.0);
        optionNode7.add(this.clipHeight, 4, 1, 4, 1);
        OptionNode optionNode8 = new OptionNode(GLanguage.translate("defaultComment"));
        defaultMutableTreeNode3.add(optionNode8);
        this.defaultComment = new JTextArea(4, 19);
        optionNode8.add(this.defaultComment, 0, 0, 8, 3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setScrollsOnExpand(true);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(this.loadIcon("open.gif"));
        defaultTreeCellRenderer.setClosedIcon(this.loadIcon("close.gif"));
        defaultTreeCellRenderer.setLeafIcon(this.loadIcon("laoe.gif"));
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.nodePanel = new JPanel();
        this.nodePanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.nodePanel);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jPanel.add((Component)jSplitPane, "Center");
        this.apply = new JButton(GLanguage.translate("apply"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.apply);
        jPanel.add((Component)jPanel2, "South");
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.frame.setResizable(true);
        this.frame.setSize(300, 400);
        jSplitPane.setDividerLocation(0.5);
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.tree.addTreeSelectionListener(this.eventDispatcher);
    }

    private void restoreOptions() {
        GPersistence gPersistence = GPersistence.createPersistance();
        this.language.setText(gPersistence.getString("language"));
        this.debugTraceLevel.setData(gPersistence.getInt("debug.verboseLevel"));
        this.undoHistoryEnable.setSelected(gPersistence.getBoolean("history.enable"));
        this.undoHistoryCompression.setSelected(gPersistence.getBoolean("history.compression"));
        this.clipWidth.setData(gPersistence.getInt("clip.frameSize.width"));
        this.clipHeight.setData(gPersistence.getInt("clip.frameSize.height"));
        this.defaultComment.setText(gPersistence.getString("clip.defaultComment"));
        this.font.setSelectedItem(gPersistence.getString("font.name"));
        this.fontSize.setData(gPersistence.getInt("font.size"));
        this.mainFrameAlwaysOnTop.setSelected(gPersistence.getBoolean("mainFrame.alwaysOnTop"));
        this.pluginAutoClose.setSelected(gPersistence.getBoolean("plugin.autoclose"));
    }

    private void onApply() {
        GPersistence gPersistence = GPersistence.createPersistance();
        gPersistence.setString("language", this.language.getText());
        gPersistence.setInt("debug.verboseLevel", (int)this.debugTraceLevel.getData());
        gPersistence.setBoolean("history.enable", this.undoHistoryEnable.isSelected());
        gPersistence.setBoolean("history.compression", this.undoHistoryCompression.isSelected());
        gPersistence.setInt("clip.frameSize.width", (int)this.clipWidth.getData());
        gPersistence.setInt("clip.frameSize.height", (int)this.clipHeight.getData());
        gPersistence.setString("clip.defaultComment", this.defaultComment.getText());
        gPersistence.setString("font.name", (String)this.font.getSelectedItem());
        gPersistence.setInt("font.size", (int)this.fontSize.getData());
        gPersistence.setBoolean("mainFrame.alwaysOnTop", this.mainFrameAlwaysOnTop.isSelected());
        gPersistence.setBoolean("plugin.autoclose", this.pluginAutoClose.isSelected());
        GDialog.showWarningDialog(this.frame, GLanguage.translate("information"), GLanguage.translate("changesWillBeDoneAfterNewStartOfLaoe"));
    }

    private class EventDispatcher
    implements ActionListener,
    TreeSelectionListener {
        private JPanel actualNode;

        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPOptions.this.apply) {
                Debug.println(1, "plugin " + GPOptions.this.getName() + " [apply] clicked");
                GPOptions.this.onApply();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            if (this.actualNode != null) {
                this.actualNode.setVisible(false);
            }
            if (defaultMutableTreeNode instanceof OptionNode) {
                this.actualNode = ((OptionNode)defaultMutableTreeNode).getPanel();
                GPOptions.this.nodePanel.add((Component)this.actualNode, "Center");
                this.actualNode.setVisible(true);
                GPOptions.this.nodePanel.validate();
            }
        }
    }

    private class OptionNode
    extends DefaultMutableTreeNode {
        private String name;
        private JPanel panel;
        private UiCartesianLayout layout;

        public OptionNode(String string) {
            this.name = string;
            this.panel = new JPanel();
            this.layout = new UiCartesianLayout(this.panel, 8, 4);
            this.layout.setPreferredCellSize(new Dimension(25, 35));
            this.panel.setLayout(this.layout);
        }

        @Override
        public String toString() {
            return this.name;
        }

        public void add(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.layout.add(jComponent, n, n2, n3, n4);
        }

        public JPanel getPanel() {
            return this.panel;
        }
    }
}

