/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AONarrowWide;
import ch.laoe.operation.AONarrowWideSweep;
import ch.laoe.operation.AORemoveMono;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChannelChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPNarrowWide
extends GPluginFrame {
    private String[] modeItem = new String[]{GLanguage.translate("narrow"), GLanguage.translate("wide")};
    private JComboBox mode;
    private UiControlText value;
    private UiControlText beginValue;
    private UiControlText endValue;
    private UiControlText pan;
    private JCheckBox modifyCh1Const;
    private JCheckBox modifyCh2Const;
    private JCheckBox modifyCh1Var;
    private JCheckBox modifyCh2Var;
    private JCheckBox modifyCh1Sweep;
    private JCheckBox modifyCh2Sweep;
    private JCheckBox continueBefore;
    private JCheckBox continueAfter;
    private GClipLayerChannelChooser wideChannel;
    private JButton applyConst;
    private JButton applyVar;
    private JButton applySweep;
    private JButton applyMono;
    private EventDispatcher eventDispatcher;

    public GPNarrowWide(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "narrowWide";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 0, 4, 1);
        this.mode = new JComboBox<String>(this.modeItem);
        uiCartesianLayout.add(this.mode, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("value")), 0, 1, 4, 1);
        this.value = new GControlTextA(6, true, true);
        this.value.setDataRange(0.0, 1.0);
        this.value.setData(1.0);
        uiCartesianLayout.add(this.value, 4, 1, 6, 1);
        this.modifyCh1Const = new JCheckBox(GLanguage.translate("channel") + " 1");
        this.modifyCh1Const.setSelected(true);
        uiCartesianLayout.add(this.modifyCh1Const, 0, 2, 5, 1);
        this.modifyCh2Const = new JCheckBox(GLanguage.translate("channel") + " 2");
        this.modifyCh2Const.setSelected(true);
        uiCartesianLayout.add(this.modifyCh2Const, 5, 2, 5, 1);
        this.applyConst = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.applyConst, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 6);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("begin")), 0, 0, 4, 1);
        this.beginValue = new GControlTextA(6, true, true);
        this.beginValue.setDataRange(0.0, 2.0);
        this.beginValue.setData(1.0);
        uiCartesianLayout2.add(this.beginValue, 4, 0, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("end")), 0, 1, 4, 1);
        this.endValue = new GControlTextA(6, true, true);
        this.endValue.setDataRange(0.0, 2.0);
        this.endValue.setData(1.0);
        uiCartesianLayout2.add(this.endValue, 4, 1, 6, 1);
        this.continueBefore = new JCheckBox(GLanguage.translate("continueBefore"));
        uiCartesianLayout2.add(this.continueBefore, 0, 2, 5, 1);
        this.continueAfter = new JCheckBox(GLanguage.translate("continueAfter"));
        uiCartesianLayout2.add(this.continueAfter, 5, 2, 5, 1);
        this.modifyCh1Sweep = new JCheckBox(GLanguage.translate("channel") + " 1");
        this.modifyCh1Sweep.setSelected(true);
        uiCartesianLayout2.add(this.modifyCh1Sweep, 0, 3, 5, 1);
        this.modifyCh2Sweep = new JCheckBox(GLanguage.translate("channel") + " 2");
        this.modifyCh2Sweep.setSelected(true);
        uiCartesianLayout2.add(this.modifyCh2Sweep, 5, 3, 5, 1);
        this.applySweep = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applySweep, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("sweep"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 6);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        this.wideChannel = new GClipLayerChannelChooser(this.getMain(), "narrowWideCurve");
        uiCartesianLayout3.add(this.wideChannel, 0, 0, 10, 4);
        this.modifyCh1Var = new JCheckBox(GLanguage.translate("channel") + " 1");
        this.modifyCh1Var.setSelected(true);
        uiCartesianLayout3.add(this.modifyCh1Var, 0, 4, 5, 1);
        this.modifyCh2Var = new JCheckBox(GLanguage.translate("channel") + " 2");
        this.modifyCh2Var.setSelected(true);
        uiCartesianLayout3.add(this.modifyCh2Var, 5, 4, 5, 1);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.applyVar, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("f(time)"), jPanel3);
        JPanel jPanel4 = new JPanel();
        UiCartesianLayout uiCartesianLayout4 = new UiCartesianLayout(jPanel4, 10, 6);
        uiCartesianLayout4.setPreferredCellSize(new Dimension(25, 35));
        jPanel4.setLayout(uiCartesianLayout4);
        uiCartesianLayout4.add(new JLabel(GLanguage.translate("pan")), 0, 1, 4, 1);
        this.pan = new GControlTextA(6, true, true);
        this.pan.setDataRange(1.0, 2.0);
        this.pan.setData(1.5);
        uiCartesianLayout4.add(this.pan, 4, 1, 6, 1);
        this.applyMono = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout4.add(this.applyMono, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("removeMono"), jPanel4);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applyConst.addActionListener(this.eventDispatcher);
        this.applyVar.addActionListener(this.eventDispatcher);
        this.applySweep.addActionListener(this.eventDispatcher);
        this.applyMono.addActionListener(this.eventDispatcher);
    }

    private void onApplyConst() {
        float f = 1.0f;
        switch (this.mode.getSelectedIndex()) {
            case 0: {
                f = (float)(1.0 - this.value.getData());
                break;
            }
            case 1: {
                f = (float)(1.0 + this.value.getData());
            }
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateChannel0WithChannel1(new AONarrowWide(this.modifyCh1Const.isSelected(), this.modifyCh2Const.isSelected(), f));
    }

    private void onApplySweep() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateChannel0WithChannel1(new AONarrowWideSweep(this.modifyCh1Const.isSelected(), this.modifyCh2Const.isSelected(), (float)this.beginValue.getData(), (float)this.endValue.getData(), this.continueBefore.isSelected(), this.continueAfter.isSelected()));
    }

    private void onApplyVar() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        ALayerSelection aLayerSelection2 = new ALayerSelection(new ALayer());
        aLayerSelection2.addChannelSelection(aLayerSelection.getChannelSelection(0));
        aLayerSelection2.addChannelSelection(aLayerSelection.getChannelSelection(1));
        aLayerSelection2.addChannelSelection(this.wideChannel.getSelectedChannel().getChannelSelection());
        aLayerSelection2.operateChannel0WithChannel1WithChannel2(new AONarrowWide(this.modifyCh1Var.isSelected(), this.modifyCh2Var.isSelected()));
    }

    private void onApplyRemoveMono() {
        float f = (float)this.pan.getData();
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        ALayerSelection aLayerSelection = aLayer.getLayerSelection();
        aLayerSelection.operateChannel0WithChannel1(new AORemoveMono(f));
        aLayer.remove(1);
    }

    @Override
    public void reload() {
        super.reload();
        this.wideChannel.reload();
        this.value.refresh();
        this.beginValue.refresh();
        this.endValue.refresh();
        this.pan.refresh();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GProgressViewer.start(GPNarrowWide.this.getName());
            GProgressViewer.entrySubProgress();
            GProgressViewer.setProgress(70);
            if (actionEvent.getSource() == GPNarrowWide.this.applyConst) {
                Debug.println(1, "plugin " + GPNarrowWide.this.getName() + " [apply const] clicked");
                GPNarrowWide.this.onApplyConst();
                GPNarrowWide.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPNarrowWide.this.applyVar) {
                Debug.println(1, "plugin " + GPNarrowWide.this.getName() + " [apply var] clicked");
                GPNarrowWide.this.onApplyVar();
                GPNarrowWide.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPNarrowWide.this.applySweep) {
                Debug.println(1, "plugin " + GPNarrowWide.this.getName() + " [apply sweep] clicked");
                GPNarrowWide.this.onApplySweep();
                GPNarrowWide.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPNarrowWide.this.applyMono) {
                Debug.println(1, "plugin " + GPNarrowWide.this.getName() + " [apply remove mono] clicked");
                GPNarrowWide.this.onApplyRemoveMono();
                GPNarrowWide.this.autoCloseNow();
            }
            GProgressViewer.setProgress(100);
            GPNarrowWide.this.updateHistory(GLanguage.translate(GPNarrowWide.this.getName()));
            GProgressViewer.exitSubProgress();
            GProgressViewer.finish();
            GPNarrowWide.this.reloadFocussedClipEditor();
        }
    }
}

