/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMultiPitch;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GPMultiPitch
extends GPluginFrame {
    private JComboBox presets;
    private GComboBoxPowerOf2 fftLength;
    private UiControlText dry;
    private UiControlText wet;
    private JTable pitchPoints;
    private JButton apply;
    private String[] presetsName;
    private float[] dryPresets;
    private float[] wetPresets;
    private double[][] pitchPresets;
    private double[][] amplitudePresets;
    private EventDispatcher eventDispatcher;
    private static final int maxRows = 20;

    public GPMultiPitch(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "multiPitch";
    }

    private void initGui() {
        PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
        try {
            ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
        int n2 = ((Persistence)persistenceDefaultImpl).getInt("numberOfPitches");
        this.presetsName = new String[n];
        this.dryPresets = new float[n];
        this.wetPresets = new float[n];
        this.pitchPresets = new double[n][];
        this.amplitudePresets = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n3;
            this.presetsName[i] = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
            this.dryPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("dry_" + i);
            this.wetPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("wet_" + i);
            this.pitchPresets[i] = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.pitchPresets[i][n3] = ((Persistence)persistenceDefaultImpl).getDouble("pitch_" + i + "_" + n3);
            }
            this.amplitudePresets[i] = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.amplitudePresets[i][n3] = ((Persistence)persistenceDefaultImpl).getDouble("amplitude_" + i + "_" + n3);
            }
        }
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 9);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("presets")), 0, 0, 4, 1);
        this.presets = new JComboBox<String>(this.presetsName);
        uiCartesianLayout.add(this.presets, 4, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("fftLength")), 0, 1, 4, 1);
        this.fftLength = new GComboBoxPowerOf2(7, 16);
        this.fftLength.setSelectedExponent(14);
        uiCartesianLayout.add(this.fftLength, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 2, 4, 1);
        this.dry = new GControlTextA(7, true, true);
        this.dry.setDataRange(-1.0, 1.0);
        this.dry.setData(1.0);
        uiCartesianLayout.add(this.dry, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 3, 4, 1);
        this.wet = new GControlTextA(7, true, true);
        this.wet.setDataRange(-1.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 4, 3, 6, 1);
        Object[] objectArray = new String[]{GLanguage.translate("pitch") + " [1]", GLanguage.translate("amplitude") + " [1]"};
        this.pitchPoints = new JTable(new Object[20][2], objectArray);
        JScrollPane jScrollPane = new JScrollPane(this.pitchPoints);
        this.pitchPoints.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 4, 10, 4);
        this.onPresetChange();
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 8, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.presets.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.dry.refresh();
        this.wet.refresh();
    }

    private void loadPoints(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            this.pitchPoints.setValueAt(String.valueOf(dArray[i]), i, 0);
            this.pitchPoints.setValueAt(String.valueOf(dArray2[i]), i, 1);
        }
    }

    private void onPresetChange() {
        int n = this.presets.getSelectedIndex();
        this.loadPoints(this.pitchPresets[n], this.amplitudePresets[n]);
        this.dry.setData(this.dryPresets[n]);
        this.wet.setData(this.wetPresets[n]);
    }

    private int getFftLength() {
        return this.fftLength.getSelectedValue();
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        float[] fArray = new float[this.pitchPoints.getRowCount()];
        float[] fArray2 = new float[this.pitchPoints.getRowCount()];
        for (int i = 0; i < this.pitchPoints.getRowCount(); ++i) {
            try {
                fArray[i] = Float.parseFloat((String)this.pitchPoints.getValueAt(i, 0));
                fArray2[i] = Float.parseFloat((String)this.pitchPoints.getValueAt(i, 1));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        aLayerSelection.operateEachChannel(new AOMultiPitch(fArray, fArray2, (float)this.dry.getData(), (float)this.wet.getData(), this.getFftLength()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPMultiPitch.this.apply) {
                GProgressViewer.start(GPMultiPitch.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPMultiPitch.this.getName() + " [apply] clicked");
                GPMultiPitch.this.onApply();
                GProgressViewer.setProgress(100);
                GPMultiPitch.this.updateHistory(GLanguage.translate(GPMultiPitch.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPMultiPitch.this.reloadFocussedClipEditor();
                GPMultiPitch.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPMultiPitch.this.presets) {
                Debug.println(1, "plugin " + GPMultiPitch.this.getName() + " [presets] clicked");
                GPMultiPitch.this.onPresetChange();
            }
        }
    }
}

