/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMove;
import ch.laoe.plugin.GPlugin;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;

public class GPMove
extends GPlugin {
    private Cursor moveCursor;
    private Cursor moveSelectionCursor;
    private Cursor actualCursor;
    private boolean ctrlActive;
    private boolean mouseDown;
    private AChannel channel;
    private int channelIndex;
    private int pressedX;
    private int draggedX;
    private int draggedGraphX;
    private int pressedSelectionOffset;
    private Stroke stroke;

    public GPMove(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGraphics();
        this.initCursors();
    }

    @Override
    public String getName() {
        return "move";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(77);
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void initCursors() {
        this.moveCursor = this.createCustomCursor("moveCursor");
        this.moveSelectionCursor = this.createCustomCursor("moveSelectionCursor");
        this.actualCursor = null;
    }

    private void setCursor(MouseEvent mouseEvent, Cursor cursor) {
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        this.channelIndex = this.getFocussedClip().getSelectedLayer().getLayerPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        this.channel = this.getFocussedClip().getSelectedLayer().getChannel(this.channelIndex);
        this.pressedX = (int)this.channel.getChannelPlotter().graphToSampleX(mouseEvent.getPoint().x);
        this.pressedSelectionOffset = this.channel.getChannelSelection().getOffset();
        this.ctrlActive = GToolkit.isCtrlKey(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.ctrlActive && this.channelIndex >= 0) {
            int n = (int)this.channel.getChannelPlotter().graphToSampleX(mouseEvent.getPoint().x);
            GProgressViewer.start(this.getName());
            ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
            aLayerSelection.operateEachChannel(new AOMove(n));
            this.getFocussedClip().getSelectedLayer().setEmptyLayerSelection();
            this.updateHistory(GLanguage.translate(this.getName()));
            GProgressViewer.finish();
            this.reloadFocussedClipEditor();
        }
        this.mouseDown = false;
        this.ctrlActive = false;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (GToolkit.isCtrlKey(mouseEvent)) {
            this.setCursor(mouseEvent, this.moveSelectionCursor);
        } else {
            this.setCursor(mouseEvent, this.moveCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.draggedGraphX = mouseEvent.getPoint().x;
        if (this.ctrlActive && this.channelIndex >= 0) {
            this.draggedX = (int)this.channel.getChannelPlotter().graphToSampleX(mouseEvent.getPoint().x);
            this.channel.getChannelSelection().setOffset(this.pressedSelectionOffset + this.draggedX - this.pressedX);
        }
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    private void initGraphics() {
        this.stroke = new BasicStroke();
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.mouseDown && !this.ctrlActive) {
            int n = this.draggedGraphX;
            int n2 = (int)rectangle.getY() + 1;
            int n3 = n;
            int n4 = (int)rectangle.getY() + (int)rectangle.getHeight() - 1;
            int n5 = 3;
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(this.stroke);
            graphics2D.drawLine(n, n2, n3, n4);
            graphics2D.drawLine(n - n5, n2, n + n5, n2);
            graphics2D.drawLine(n3 - n5, n4, n3 + n5, n4);
        }
    }
}

