/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelPlotter;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMeasure;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextSF;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GCookie;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPMeasure
extends GPluginFrame {
    private GCookieMeasure cookie;
    private Stroke ctrlStroke;
    private Stroke shiftStroke;
    private Stroke defaultStroke;
    private static float ctrlXSample;
    private static float shiftXSample;
    private boolean shiftPositivePeak;
    private boolean ctrlPositivePeak;
    private int ctrlChannelIndex;
    private int shiftChannelIndex;
    private JComboBox cursorMode;
    private UiControlText uiCtrlX;
    private UiControlText uiCtrlY;
    private UiControlText uiShiftX;
    private UiControlText uiShiftY;
    private UiControlText uiDeltaX;
    private UiControlText uiDeltaY;
    private UiControlText mean;
    private UiControlText rms;
    private UiControlText stdDev;
    private UiControlText min;
    private UiControlText max;
    private UiControlText clippedSamples;
    private JButton updateStat;
    private JButton updateExtrema;
    private EventDispatcher eventDispatcher;

    public GPMeasure(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.updateCookie();
    }

    @Override
    public String getName() {
        return "measure";
    }

    @Override
    public void start() {
        super.start();
        this.updateCookie();
        this.updateDisplay();
    }

    @Override
    public void reload() {
        super.reload();
        this.updateCookie();
        this.updateDisplay();
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void updateCookie() {
        try {
            this.cookie = (GCookieMeasure)this.getFocussedClip().getCookies().getCookie(this.getName());
            if (this.cookie == null) {
                GCookieMeasure gCookieMeasure = new GCookieMeasure();
                this.getFocussedClip().getCookies().setCookie(gCookieMeasure, this.getName());
                this.cookie = gCookieMeasure;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.calculateCursorPositions(mouseEvent);
        this.updateDisplay();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.calculateCursorPositions(mouseEvent);
        this.updateDisplay();
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        AChannelPlotter aChannelPlotter = this.getFocussedClip().getSelectedLayer().getChannel(this.cookie.ctrlChannelIndex).getChannelPlotter();
        int n = aChannelPlotter.sampleToGraphX(this.cookie.ctrlX);
        int n2 = aChannelPlotter.sampleToGraphY(this.cookie.ctrlY);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setStroke(this.ctrlStroke);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(0, n2, (int)rectangle.getWidth(), n2);
        graphics2D.drawLine(n, 0, n, (int)rectangle.getHeight());
        if (this.cursorMode.getSelectedIndex() == 2) {
            graphics2D.setStroke(this.defaultStroke);
            graphics2D.setColor(Color.red);
            if (this.ctrlPositivePeak) {
                graphics2D.drawLine(n, n2, n - 4, n2 - 4);
                graphics2D.drawLine(n, n2, n + 4, n2 - 4);
            } else {
                graphics2D.drawLine(n, n2, n - 4, n2 + 4);
                graphics2D.drawLine(n, n2, n + 4, n2 + 4);
            }
        }
        AChannelPlotter aChannelPlotter2 = this.getFocussedClip().getSelectedLayer().getChannel(this.cookie.shiftChannelIndex).getChannelPlotter();
        int n3 = aChannelPlotter2.sampleToGraphX(this.cookie.shiftX);
        int n4 = aChannelPlotter2.sampleToGraphY(this.cookie.shiftY);
        graphics2D.setStroke(this.shiftStroke);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(0, n4, (int)rectangle.getWidth(), n4);
        graphics2D.drawLine(n3, 0, n3, (int)rectangle.getHeight());
        if (this.cursorMode.getSelectedIndex() == 2) {
            graphics2D.setStroke(this.defaultStroke);
            graphics2D.setColor(Color.red);
            if (this.shiftPositivePeak) {
                graphics2D.drawLine(n3, n4, n3 - 4, n4 - 4);
                graphics2D.drawLine(n3, n4, n3 + 4, n4 - 4);
            } else {
                graphics2D.drawLine(n3, n4, n3 - 4, n4 + 4);
                graphics2D.drawLine(n3, n4, n3 + 4, n4 + 4);
            }
        }
    }

    private void calculateCursorPositions(MouseEvent mouseEvent) {
        ALayer aLayer;
        int n;
        if (this.frame.isVisible() && this.getFocussedClip() != null && (n = (aLayer = this.getFocussedClip().getSelectedLayer()).getLayerPlotter().getInsideChannelIndex(mouseEvent.getPoint())) >= 0) {
            AChannel aChannel = aLayer.getChannel(n);
            AChannelPlotter aChannelPlotter = aChannel.getChannelPlotter();
            float f = aChannelPlotter.graphToSampleX(mouseEvent.getPoint().x);
            float f2 = aChannelPlotter.graphToSampleY(mouseEvent.getPoint().y);
            boolean bl = true;
            switch (this.cursorMode.getSelectedIndex()) {
                case 1: {
                    f = aLayer.getChannel(n).limitIndex((int)f);
                    f2 = aLayer.getChannel(n).getSample((int)f);
                    break;
                }
                case 2: {
                    int n2;
                    int n3 = (int)(aChannelPlotter.graphToSampleX(mouseEvent.getPoint().x + 15) - f);
                    f2 = aLayer.getChannel(n).getSample((int)f);
                    if (aChannelPlotter.graphToSampleY(mouseEvent.getPoint().y) > f2) {
                        n2 = AOToolkit.getNearestPositivePeakIndex(aChannel.getSamples(), (int)f, n3);
                        bl = true;
                    } else {
                        n2 = AOToolkit.getNearestNegativePeakIndex(aChannel.getSamples(), (int)f, n3);
                        bl = false;
                    }
                    f = aLayer.getChannel(n).limitIndex(n2);
                    f2 = aLayer.getChannel(n).getSample((int)f);
                }
            }
            if (GToolkit.isShiftKey(mouseEvent)) {
                shiftXSample = f;
                this.cookie.shiftX = f;
                this.cookie.shiftY = f2;
                this.shiftPositivePeak = bl;
                this.cookie.shiftChannelIndex = n;
            }
            if (GToolkit.isCtrlKey(mouseEvent)) {
                ctrlXSample = f;
                this.cookie.ctrlX = f;
                this.cookie.ctrlY = f2;
                this.ctrlPositivePeak = bl;
                this.cookie.ctrlChannelIndex = n;
            }
            this.repaintFocussedClipEditor();
        }
    }

    private void updateDisplay() {
        try {
            this.uiShiftX.setData(this.cookie.shiftX);
            this.uiShiftY.setData(this.cookie.shiftY);
            this.uiCtrlX.setData(this.cookie.ctrlX);
            this.uiCtrlY.setData(this.cookie.ctrlY);
            this.uiDeltaX.setData(this.uiCtrlX.getData() - this.uiShiftX.getData());
            this.uiDeltaY.setData(this.uiCtrlY.getData() - this.uiShiftY.getData());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initGui() {
        float[] fArray = new float[]{3.0f, 5.0f};
        this.ctrlStroke = new BasicStroke(1.0f, 2, 0, 1.0f, fArray, 0.0f);
        float[] fArray2 = new float[]{10.0f, 3.0f};
        this.shiftStroke = new BasicStroke(1.0f, 2, 0, 1.0f, fArray2, 0.0f);
        this.defaultStroke = new BasicStroke();
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 9, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("ctrl")), 0, 1, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shift")), 0, 2, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("delta")), 0, 3, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("x")), 1, 0, 4, 1);
        this.uiCtrlX = new GControlTextSF(this.getMain(), 9, false, true);
        this.uiCtrlX.setEditable(false);
        this.uiCtrlX.setDataRange(-1.0E9, 1.0E9);
        this.uiCtrlX.setData(1.0);
        this.uiCtrlX.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout.add(this.uiCtrlX, 1, 1, 4, 1);
        this.uiShiftX = new GControlTextSF(this.getMain(), 9, false, true);
        this.uiShiftX.setEditable(false);
        this.uiShiftX.setDataRange(-1.0E9, 1.0E9);
        this.uiShiftX.setData(1.0);
        this.uiShiftX.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout.add(this.uiShiftX, 1, 2, 4, 1);
        this.uiDeltaX = new GControlTextSF(this.getMain(), 9, false, true);
        this.uiDeltaX.setEditable(false);
        this.uiDeltaX.setDataRange(-1.0E9, 1.0E9);
        this.uiDeltaX.setData(1.0);
        this.uiDeltaX.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout.add(this.uiDeltaX, 1, 3, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("y")), 5, 0, 1, 1);
        String[] stringArray = new String[]{GLanguage.translate("free"), GLanguage.translate("locked"), GLanguage.translate("peak")};
        this.cursorMode = new JComboBox<String>(stringArray);
        this.cursorMode.setSelectedIndex(2);
        uiCartesianLayout.add(this.cursorMode, 6, 0, 3, 1);
        this.uiCtrlY = new GControlTextY(this.getMain(), 9, false, true);
        this.uiCtrlY.setEditable(false);
        this.uiCtrlY.setDataRange(-1.0E9, 1.0E9);
        this.uiCtrlY.setData(1.0);
        uiCartesianLayout.add(this.uiCtrlY, 5, 1, 4, 1);
        this.uiShiftY = new GControlTextY(this.getMain(), 9, false, true);
        this.uiShiftY.setEditable(false);
        this.uiShiftY.setDataRange(-1.0E9, 1.0E9);
        this.uiShiftY.setData(1.0);
        uiCartesianLayout.add(this.uiShiftY, 5, 2, 4, 1);
        this.uiDeltaY = new GControlTextY(this.getMain(), 9, false, true);
        this.uiDeltaY.setEditable(false);
        this.uiDeltaY.setDataRange(-1.0E9, 1.0E9);
        this.uiDeltaY.setData(1.0);
        uiCartesianLayout.add(this.uiDeltaY, 5, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("cursor"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 9, 4);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(30, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("mean")), 0, 0, 4, 1);
        this.mean = new GControlTextY(this.getMain(), 9, false, true);
        this.mean.setEditable(false);
        this.mean.setDataRange(-1.0E9, 1.0E9);
        this.mean.setData(1.0);
        this.mean.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout2.add(this.mean, 4, 0, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("rms")), 0, 1, 4, 1);
        this.rms = new GControlTextY(this.getMain(), 9, false, true);
        this.rms.setEditable(false);
        this.rms.setDataRange(-1.0E9, 1.0E9);
        this.rms.setData(1.0);
        this.rms.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout2.add(this.rms, 4, 1, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("standardDeviation")), 0, 2, 4, 1);
        this.stdDev = new GControlTextY(this.getMain(), 9, false, true);
        this.stdDev.setEditable(false);
        this.stdDev.setDataRange(-1.0E9, 1.0E9);
        this.stdDev.setData(1.0);
        this.stdDev.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout2.add(this.stdDev, 4, 2, 5, 1);
        this.updateStat = new JButton(GLanguage.translate("update"));
        uiCartesianLayout2.add(this.updateStat, 3, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("statistics"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 9, 4);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(30, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("min")), 0, 0, 4, 1);
        this.min = new GControlTextY(this.getMain(), 9, false, true);
        this.min.setEditable(false);
        this.min.setDataRange(-1.0E9, 1.0E9);
        this.min.setData(1.0);
        this.min.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout3.add(this.min, 4, 0, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("max")), 0, 1, 4, 1);
        this.max = new GControlTextY(this.getMain(), 9, false, true);
        this.max.setEditable(false);
        this.max.setDataRange(-1.0E9, 1.0E9);
        this.max.setData(1.0);
        this.max.getFormat().setMaximumFractionDigits(3);
        uiCartesianLayout3.add(this.max, 4, 1, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("clippedSamples")), 0, 2, 4, 1);
        this.clippedSamples = new UiControlText(9, false, true);
        this.clippedSamples.setEditable(false);
        this.clippedSamples.setDataRange(0.0, 1.0E9);
        this.clippedSamples.setData(0.0);
        uiCartesianLayout3.add(this.clippedSamples, 4, 2, 5, 1);
        this.updateExtrema = new JButton(GLanguage.translate("update"));
        uiCartesianLayout3.add(this.updateExtrema, 3, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("extrema"), jPanel3);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.updateStat.addActionListener(this.eventDispatcher);
        this.updateExtrema.addActionListener(this.eventDispatcher);
    }

    private void onUpdateStatistics() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        AOMeasure aOMeasure = new AOMeasure(this.getFocussedClip().getSampleWidth());
        aLayerSelection.operateEachChannel(aOMeasure);
        this.mean.setData(aOMeasure.getMean());
        this.rms.setData(aOMeasure.getRms());
        this.stdDev.setData(aOMeasure.getStandardDeviation());
        this.min.setData(aOMeasure.getMin());
        this.max.setData(aOMeasure.getMax());
        this.clippedSamples.setData(aOMeasure.getNumberOfClippedSamples());
    }

    public static float getLowerCursor() {
        return Math.min(ctrlXSample, shiftXSample);
    }

    public static float getHigherCursor() {
        return Math.max(ctrlXSample, shiftXSample);
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Debug.println(1, "plugin " + GPMeasure.this.getName() + " [update statistics] clicked");
            GPMeasure.this.onUpdateStatistics();
        }
    }

    private class GCookieMeasure
    extends GCookie {
        public float ctrlX;
        public float ctrlY;
        public float shiftX;
        public float shiftY;
        public int ctrlChannelIndex;
        public int shiftChannelIndex;

        private GCookieMeasure() {
        }
    }
}

