/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannelMask;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GEditableSegments;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPMask
extends GPluginFrame {
    private GEditableSegments actualSegments;
    private AChannelMask actualMask;
    private UiControlText activeX;
    private UiControlText activeY;
    private JButton clear;
    private JButton complementary;
    private JButton applyDefinitely;
    private EventDispatcher eventDispatcher;

    public GPMask(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "mask";
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.actualMask = this.getSelectedLayer().getChannel(mouseEvent.getPoint()).getMask();
        this.actualSegments = this.actualMask.getSegments();
        this.actualSegments.mousePressed(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.actualSegments.mouseClicked(mouseEvent);
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.actualSegments != null) {
            this.actualSegments.mouseEntered(mouseEvent);
        }
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            this.actualMask = this.getSelectedLayer().getChannel(mouseEvent.getPoint()).getMask();
            this.actualSegments = this.actualMask.getSegments();
            if (this.actualSegments != null) {
                this.actualSegments.mouseMoved(mouseEvent);
                this.updateActivePoint();
            }
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.actualSegments.mouseDragged(mouseEvent);
        this.updateActivePoint();
        this.repaintFocussedClipEditor();
    }

    public void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 8, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("x")), 0, 0, 4, 1);
        this.activeX = new GControlTextX(this.getMain(), 9, false, true);
        this.activeX.setDataRange(0.0, 1.0E10);
        this.activeX.setData(0.0);
        this.activeX.setEditable(false);
        uiCartesianLayout.add(this.activeX, 0, 1, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("y")), 4, 0, 4, 1);
        this.activeY = new GControlTextA(9, false, true);
        this.activeY.setDataRange(0.0, 1.0);
        this.activeY.setData(0.0);
        this.activeY.setEditable(false);
        uiCartesianLayout.add(this.activeY, 4, 1, 4, 1);
        this.clear = new JButton(GLanguage.translate("clear"));
        uiCartesianLayout.add(this.clear, 0, 2, 4, 1);
        this.complementary = new JButton(GLanguage.translate("complement"));
        uiCartesianLayout.add(this.complementary, 4, 2, 4, 1);
        this.applyDefinitely = new JButton(GLanguage.translate("applyDefinitely"));
        uiCartesianLayout.add(this.applyDefinitely, 0, 3, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.clear.addActionListener(this.eventDispatcher);
        this.complementary.addActionListener(this.eventDispatcher);
        this.applyDefinitely.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.activeX.refresh();
        this.activeY.refresh();
    }

    private void updateActivePoint() {
        this.activeX.setData(this.actualSegments.getActivePointX());
        this.activeY.setData(this.actualSegments.getActivePointY());
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AChannelMask aChannelMask = GPMask.this.getFocussedClip().getSelectedLayer().getSelectedChannel().getMask();
            if (actionEvent.getSource() == GPMask.this.clear) {
                Debug.println(1, "plugin " + GPMask.this.getName() + " [clear] clicked");
                aChannelMask.clear();
                GPMask.this.repaintFocussedClipEditor();
            } else if (actionEvent.getSource() == GPMask.this.complementary) {
                Debug.println(1, "plugin " + GPMask.this.getName() + " [complementary] clicked");
                aChannelMask.setComplementary();
                GPMask.this.repaintFocussedClipEditor();
            } else if (actionEvent.getSource() == GPMask.this.applyDefinitely) {
                GProgressViewer.start(GPMask.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPMask.this.getName() + " [apply definitely] clicked");
                aChannelMask.applyDefinitely();
                GProgressViewer.setProgress(100);
                GPMask.this.updateHistory(GLanguage.translate(GPMask.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPMask.this.reloadFocussedClipEditor();
            }
        }
    }
}

