/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerPlotter;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GLayerViewer;
import ch.laoe.ui.GProgressViewer;
import ch.laoe.ui.GSimpleColorChooser;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import ch.oli4.ui.control.UiControlText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GPLayerStack
extends GPluginFrame {
    private JComboBox plotType;
    private GSimpleColorChooser layerColor;
    private UiControlText layerColorGamma;
    private JScrollPane scrollPane;
    private JPanel pScroll;
    private JButton newButton;
    private JButton upButton;
    private JButton downButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton duplicateButton;
    private JButton deleteButton;
    private JButton mergeButton;
    private JButton mergeAllButton;
    private EventDispatcher eventDispatcher;
    private UiControlText channels;
    private UiControlText samples;
    private static ALayer clipBoardLayer;

    public GPLayerStack(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.frame.setResizable(true);
    }

    @Override
    public String getName() {
        return "layerStack";
    }

    @Override
    public JMenuItem createMenuItem() {
        return super.createMenuItem(76);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void reload() {
        super.reload();
        if (this.frame.isVisible() && this.getFocussedClip() != null) {
            this.onClipChange();
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.pScroll = new JPanel();
        JPanel jPanel3 = new JPanel();
        String[] stringArray = new String[]{GLanguage.translate("sampleCurve"), GLanguage.translate("spectrogram")};
        this.plotType = new JComboBox<String>(stringArray);
        this.plotType.setToolTipText(GLanguage.translate("plotType"));
        jPanel2.add(this.plotType);
        this.layerColor = new GSimpleColorChooser(GLanguage.translate("color"), GLanguage.translate("layerColor"));
        this.layerColor.setToolTipText(GLanguage.translate("layerColor"));
        jPanel2.add(this.layerColor);
        jPanel2.add(new JLabel(GLanguage.translate("brightness")));
        this.layerColorGamma = new GControlTextA(9, true, true);
        this.layerColorGamma.setDataRange(0.0, 1.0);
        this.layerColorGamma.setData(0.8);
        jPanel2.add(this.layerColorGamma);
        jPanel.add(jPanel2);
        this.scrollPane = new JScrollPane(this.pScroll, 22, 31);
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        jPanel.add(this.scrollPane);
        this.newButton = new JButton(this.loadIcon("new.gif"));
        this.newButton.setToolTipText(GLanguage.translate("newLayer"));
        this.newButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.newButton);
        this.upButton = new JButton(this.loadIcon("up.gif"));
        this.upButton.setToolTipText(GLanguage.translate("moveLayerUp"));
        this.upButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.upButton);
        this.downButton = new JButton(this.loadIcon("down.gif"));
        this.downButton.setToolTipText(GLanguage.translate("moveLayerDown"));
        this.downButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.downButton);
        this.copyButton = new JButton(this.loadIcon("copy.gif"));
        this.copyButton.setToolTipText(GLanguage.translate("copyLayer"));
        this.copyButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.copyButton);
        this.pasteButton = new JButton(this.loadIcon("paste.gif"));
        this.pasteButton.setToolTipText(GLanguage.translate("pasteLayer"));
        this.pasteButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.pasteButton);
        this.duplicateButton = new JButton(this.loadIcon("duplicate.gif"));
        this.duplicateButton.setToolTipText(GLanguage.translate("duplicateLayer"));
        this.duplicateButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.duplicateButton);
        this.deleteButton = new JButton(this.loadIcon("delete.gif"));
        this.deleteButton.setToolTipText(GLanguage.translate("deleteLayer"));
        this.deleteButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.deleteButton);
        this.mergeButton = new JButton(this.loadIcon("mergeUpLayer.gif"));
        this.mergeButton.setToolTipText(GLanguage.translate("mergeUpLayer"));
        this.mergeButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.mergeButton);
        this.mergeAllButton = new JButton(this.loadIcon("mergeAllLayers.gif"));
        this.mergeAllButton.setToolTipText(GLanguage.translate("mergeAllLayers"));
        this.mergeAllButton.setPreferredSize(new Dimension(26, 26));
        jPanel3.add(this.mergeAllButton);
        jPanel.add(jPanel3);
        this.frame.getContentPane().add(jPanel);
        this.frame.setSize(new Dimension(400, 300));
        this.eventDispatcher = new EventDispatcher();
        this.plotType.addActionListener(this.eventDispatcher);
        this.layerColor.addActionListener(this.eventDispatcher);
        this.layerColorGamma.addControlListener(this.eventDispatcher);
        this.newButton.addActionListener(this.eventDispatcher);
        this.upButton.addActionListener(this.eventDispatcher);
        this.downButton.addActionListener(this.eventDispatcher);
        this.copyButton.addActionListener(this.eventDispatcher);
        this.pasteButton.addActionListener(this.eventDispatcher);
        this.duplicateButton.addActionListener(this.eventDispatcher);
        this.deleteButton.addActionListener(this.eventDispatcher);
        this.mergeButton.addActionListener(this.eventDispatcher);
        this.mergeAllButton.addActionListener(this.eventDispatcher);
    }

    private void updateThisAndFocussedClip() {
        this.frame.validate();
        this.frame.repaint();
        this.repaintFocussedClipEditor();
    }

    private void reloadFocussedClip() {
        this.pluginHandler.getFocussedClipEditor().reload();
    }

    private void onPlotTypeChange() {
        switch (this.plotType.getSelectedIndex()) {
            case 0: {
                this.pluginHandler.getFocussedClip().getSelectedLayer().setPlotType(1);
                break;
            }
            case 1: {
                this.pluginHandler.getFocussedClip().getSelectedLayer().setPlotType(2);
            }
        }
        this.onClipChange();
        this.updateThisAndFocussedClip();
        this.reloadFocussedClip();
    }

    private void onLayerColorChange() {
        ALayerPlotter aLayerPlotter = this.pluginHandler.getFocussedClip().getSelectedLayer().getLayerPlotter();
        aLayerPlotter.setColor(this.layerColor.getSelectedColor());
        aLayerPlotter.setColorGamma((float)this.layerColorGamma.getData());
        this.onClipChange();
        this.updateThisAndFocussedClip();
        this.reloadFocussedClip();
    }

    private JPanel createNewLayerDialogContent(int n, int n2) {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("channels")), 0, 0, 4, 1);
        this.channels = new UiControlText(10, true, false);
        this.channels.setDataRange(1.0, 100.0);
        this.channels.setData(n);
        uiCartesianLayout.add(this.channels, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("samples")), 0, 1, 4, 1);
        this.samples = new GControlTextX(this.getMain(), 10, true, true);
        this.samples.setDataRange(1.0, 1.0E9);
        this.samples.setData(n2);
        uiCartesianLayout.add(this.samples, 4, 1, 6, 1);
        return jPanel;
    }

    private void onNewButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        if (GDialog.showCustomOkCancelDialog(this.frame, this.createNewLayerDialogContent(aClip.getMaxNumberOfChannels(), aClip.getMaxSampleLength()), GLanguage.translate("newLayer"))) {
            aClip.insert(new ALayer((int)this.channels.getData(), (int)this.samples.getData()), aClip.getSelectedIndex() + 1);
            this.pluginHandler.getFocussedClipEditor().reload();
            this.updateHistory(GLanguage.translate("newLayer"));
            this.onClipChange();
            this.autoScaleFocussedClip();
            this.reloadFocussedClip();
        }
    }

    private void onUpButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        aClip.moveDown(aClip.getSelectedIndex());
        this.updateHistory(GLanguage.translate("moveLayerUp"));
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClip();
    }

    private void onDownButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        aClip.moveUp(aClip.getSelectedIndex());
        this.updateHistory(GLanguage.translate("moveLayerDown"));
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClip();
    }

    private void onCopyButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        clipBoardLayer = new ALayer(aClip.getSelectedLayer());
    }

    private void onPasteButton() {
        if (clipBoardLayer != null) {
            AClip aClip = this.pluginHandler.getFocussedClip();
            aClip.insert(new ALayer(clipBoardLayer), aClip.getSelectedIndex());
            this.updateHistory(GLanguage.translate("pasteLayer"));
            this.onClipChange();
            this.autoScaleFocussedClip();
            this.reloadFocussedClip();
        }
    }

    private void onDuplicateButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        aClip.insert(new ALayer(aClip.getSelectedLayer()), aClip.getSelectedIndex());
        this.updateHistory(GLanguage.translate("duplicateLayer"));
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClip();
    }

    private void onDeleteButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        aClip.remove(aClip.getSelectedIndex());
        this.updateHistory(GLanguage.translate("deleteLayer"));
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClip();
    }

    private void onMergeButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        aClip.mergeDownLayer(aClip.getSelectedIndex());
        this.updateHistory(GLanguage.translate("mergeUpLayer"));
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClip();
    }

    private void onMergeAllButton() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        aClip.mergeAllLayers();
        this.updateHistory(GLanguage.translate("mergeAllLayers"));
        this.onClipChange();
        this.autoScaleFocussedClip();
        this.reloadFocussedClip();
    }

    public void onClipChange() {
        AClip aClip = this.pluginHandler.getFocussedClip();
        if (aClip == null) {
            this.pScroll.removeAll();
            return;
        }
        switch (this.getFocussedClip().getSelectedLayer().getPlotType()) {
            case 1: {
                this.plotType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.plotType.setSelectedIndex(1);
            }
        }
        this.layerColor.setSelectedColor(this.getFocussedClip().getSelectedLayer().getLayerPlotter().getColor());
        this.layerColorGamma.setData(this.getFocussedClip().getSelectedLayer().getLayerPlotter().getColorGamma());
        this.pScroll.removeAll();
        this.pScroll.setPreferredSize(new Dimension(300, 60 * this.pluginHandler.getFocussedClip().getNumberOfLayers()));
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            this.pScroll.add(new LayerPanel(this, aClip, i));
        }
        this.updateThisAndFocussedClip();
    }

    private class LayerPanel
    extends JPanel
    implements ActionListener,
    MouseListener {
        private JCheckBox visible;
        private JCheckBox audible;
        private GLayerViewer layerView;
        private JTextField layerName;
        private boolean selected;
        private GPLayerStack layerStack;
        private AClip clip;
        private ALayer layer;
        private int layerIndex;

        public LayerPanel(GPLayerStack gPLayerStack2, AClip aClip, int n) {
            this.setLayout(new BoxLayout(this, 0));
            this.layerStack = gPLayerStack2;
            this.clip = aClip;
            this.layerIndex = n;
            this.layer = aClip.getLayer(n);
            this.visible = new JCheckBox();
            this.visible.setSelectedIcon(GToolkit.loadIcon(this, "visibleSelectedCheckBox"));
            this.visible.setIcon(GToolkit.loadIcon(this, "visibleUnselectedCheckBox"));
            this.visible.setToolTipText(GLanguage.translate("visible"));
            this.visible.setSelected(this.layer.getLayerPlotter().isVisible());
            this.visible.addActionListener(this);
            this.add(this.visible);
            this.audible = new JCheckBox();
            this.audible.setSelectedIcon(GToolkit.loadIcon(this, "audibleSelectedCheckBox"));
            this.audible.setIcon(GToolkit.loadIcon(this, "audibleUnselectedCheckBox"));
            this.audible.setToolTipText(GLanguage.translate("audible"));
            this.audible.setSelected(this.layer.getType() == 1);
            this.audible.addActionListener(this);
            this.add(this.audible);
            this.layerView = new GLayerViewer(aClip, n);
            this.layerView.setPreferredSize(new Dimension(100, 40));
            this.layerView.addMouseListener(this);
            this.add(this.layerView);
            this.layerName = new JTextField(30);
            this.layerName.setToolTipText(GLanguage.translate("layerName"));
            this.layerName.setText(this.layer.getName());
            this.layerName.addActionListener(this);
            this.add(this.layerName);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setSelected(aClip.getSelectedLayer() == this.layer);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(380, 50));
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            Color color = new Color(4746398);
            if (this.selected) {
                this.setBackground(color);
                this.visible.setBackground(color);
                this.audible.setBackground(color);
                this.layerName.setBackground(color);
            }
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.visible) {
                Debug.println(1, "plugin " + this.getName() + " [visible] clicked");
                this.layer.getLayerPlotter().setVisible(this.visible.isSelected());
                this.layerStack.pluginHandler.getFocussedClipEditor().reload();
            } else if (actionEvent.getSource() == this.audible) {
                Debug.println(1, "plugin " + this.getName() + " [audible] clicked");
                if (this.audible.isSelected()) {
                    this.layer.setType(1);
                } else {
                    this.layer.setType(2);
                }
                this.layerStack.pluginHandler.getFocussedClipEditor().reload();
            } else if (actionEvent.getSource() == this.layerName) {
                Debug.println(1, "plugin " + this.getName() + " [layer name] clicked");
                this.layer.setName(this.layerName.getText());
            }
            this.layerStack.onClipChange();
            this.layerStack.pluginHandler.getFocussedClipEditor().reload();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Debug.println(1, "plugin " + this.getName() + " [select layer] mouse-click");
            this.clip.setSelectedIndex(this.layerIndex);
            this.layerStack.onClipChange();
            this.layerStack.pluginHandler.getFocussedClipEditor().reload();
        }
    }

    private class EventDispatcher
    implements ActionListener,
    ChangeListener,
    UiControlListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == GPLayerStack.this.plotType) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [plot type] clicked");
                    GPLayerStack.this.onPlotTypeChange();
                    return;
                }
                if (actionEvent.getSource() == GPLayerStack.this.layerColor) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [layer color] clicked");
                    GPLayerStack.this.onLayerColorChange();
                    return;
                }
                GProgressViewer.start(GPLayerStack.this.getName());
                if (actionEvent.getSource() == GPLayerStack.this.newButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [new] clicked");
                    GPLayerStack.this.onNewButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.upButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [up] clicked");
                    GPLayerStack.this.onUpButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.downButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [down] clicked");
                    GPLayerStack.this.onDownButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.copyButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [copy] clicked");
                    GPLayerStack.this.onCopyButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.pasteButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [paste] clicked");
                    GPLayerStack.this.onPasteButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.duplicateButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [duplicate] clicked");
                    GPLayerStack.this.onDuplicateButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.deleteButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [delete] clicked");
                    GPLayerStack.this.onDeleteButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.mergeButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [merge] clicked");
                    GPLayerStack.this.onMergeButton();
                } else if (actionEvent.getSource() == GPLayerStack.this.mergeAllButton) {
                    Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [merge all] clicked");
                    GPLayerStack.this.onMergeAllButton();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            GProgressViewer.finish();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void onDataChanging(UiControlEvent uiControlEvent) {
        }

        @Override
        public void onDataChanged(UiControlEvent uiControlEvent) {
            if (uiControlEvent.getSource() == GPLayerStack.this.layerColorGamma) {
                Debug.println(1, "plugin " + GPLayerStack.this.getName() + " [layer color gamma] changed");
                GPLayerStack.this.onLayerColorChange();
                return;
            }
        }

        @Override
        public void onValidate(UiControlEvent uiControlEvent) {
        }
    }
}

