/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.plugin.GFileFilter;
import ch.laoe.plugin.GPFileView;
import ch.laoe.plugin.GPlugin;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class GPImageSaveAs
extends GPlugin {
    private JFileChooser fileChooser;

    public GPImageSaveAs(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.fileChooser = new JFileChooser(this.persistance.getString("plugin." + this.getName() + ".currentDirectory"));
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fileChooser.addChoosableFileFilter(new GFileFilter("." + stringArray[i]));
        }
        this.fileChooser.setFileView(new GPFileView());
    }

    @Override
    public String getName() {
        return "imageSaveAs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.fileChooser.showSaveDialog(null) == 0) {
            try {
                File file = this.fileChooser.getSelectedFile();
                String string = this.fileChooser.getFileFilter().getDescription().toLowerCase();
                if (file.getName().indexOf(46) < 0) {
                    file = new File(file.getPath() + string);
                }
                if (file.isDirectory()) {
                    GDialog.showErrorDialog(this.fileChooser, "fileError", "isDirectory");
                    return;
                }
                if (file.isFile() && !GDialog.showYesNoQuestionDialog(this.fileChooser, "fileWarning", new JLabel(GLanguage.translate("overwrite?")))) {
                    return;
                }
                boolean bl = GDialog.showYesNoQuestionDialog(this.fileChooser, "paintOptions", new JLabel(GLanguage.translate("pluginDrawings?")));
                GProgressViewer.start("saving");
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(3, "save clip frame " + this.getFocussedClipEditor().getClip().getName() + " as image " + file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string.substring(1));
                ImageWriter imageWriter = iterator.next();
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(fileOutputStream);
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(this.getFocussedClipEditor().createFullImage(bl));
                fileOutputStream.close();
                GProgressViewer.setProgress(100);
                GProgressViewer.exitSubProgress();
            }
            catch (Exception exception) {
                GDialog.showErrorDialog(null, "ioError", "couldNotSaveImage");
                exception.printStackTrace();
            }
            finally {
                GProgressViewer.finish();
            }
        }
    }

    @Override
    public void onBackup(Persistence persistence) {
        this.persistance.setString("plugin." + this.getName() + ".currentDirectory", this.fileChooser.getCurrentDirectory().getPath());
    }
}

