/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOHistogram;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class GPHistogram
extends GPluginFrame {
    private JButton createHistogram;
    private JButton update;
    private EventDispatcher eventDispatcher;
    private GClipEditor histogramClipEditor;

    public GPHistogram(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "histogram";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.createHistogram = new JButton(GLanguage.translate("new"));
        uiCartesianLayout.add(this.createHistogram, 1, 1, 4, 1);
        this.update = new JButton(GLanguage.translate("update"));
        uiCartesianLayout.add(this.update, 5, 1, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.createHistogram.addActionListener(this.eventDispatcher);
        this.update.addActionListener(this.eventDispatcher);
        this.updateGui();
    }

    private void updateGui() {
        if (this.histogramClipEditor != null) {
            this.update.setEnabled(true);
        } else {
            this.update.setEnabled(false);
        }
    }

    private void onCreateHistogram() {
        AClip aClip = new AClip(1, 1, AOHistogram.getHistogramLength());
        aClip.setName("<" + GLanguage.translate("histogram") + ">");
        aClip.setSampleRate(this.getFocussedClip().getSampleRate());
        this.getMain().addClipFrame(aClip);
        this.histogramClipEditor = this.getFocussedClipEditor();
    }

    private void onUpdate() {
        AOHistogram aOHistogram = new AOHistogram();
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(aOHistogram);
        AClip aClip = this.histogramClipEditor.getClip();
        AChannel aChannel = aClip.getLayer(0).getChannel(0);
        aChannel.setSamples(aOHistogram.getHistogram());
        aChannel.markChange();
        try {
            aClip.getHistory().store(this.loadIcon(), GLanguage.translate(this.getName()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        aClip.getClipPlotter().autoScale();
        this.histogramClipEditor.reload();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPHistogram.this.update) {
                GProgressViewer.start(GPHistogram.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(100);
                Debug.println(1, "plugin " + GPHistogram.this.getName() + " [update] clicked");
                GPHistogram.this.onUpdate();
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
            } else if (actionEvent.getSource() == GPHistogram.this.createHistogram) {
                Debug.println(1, "plugin " + GPHistogram.this.getName() + " [create histogram] clicked");
                GPHistogram.this.onCreateHistogram();
            }
            GPHistogram.this.updateGui();
        }
    }
}

