/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOHarmonicsGenerator;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextF;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GPHarmonicsGenerator
extends GPluginFrame {
    private UiControlText offset;
    private UiControlText basePeriod;
    private JCheckBox add;
    private JTable amplitudes;
    private JButton reset;
    private JButton apply;
    private EventDispatcher eventDispatcher;
    private static final int maxRows = 30;

    public GPHarmonicsGenerator(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "harmonicsGenerator";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 10);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("offset")), 0, 0, 4, 1);
        this.offset = new GControlTextY(this.getMain(), 9, true, true);
        this.offset.setDataRange(-1.0E9, 1.0E9);
        this.offset.setData(0.0);
        uiCartesianLayout.add(this.offset, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("basePeriod")), 0, 1, 4, 1);
        this.basePeriod = new GControlTextF(this.getMain(), 9, true, true);
        this.basePeriod.setDataRange(0.0, 1000000.0);
        this.basePeriod.setData(1000.0);
        uiCartesianLayout.add(this.basePeriod, 4, 1, 6, 1);
        this.add = new JCheckBox(GLanguage.translate("add"));
        uiCartesianLayout.add(this.add, 5, 2, 5, 1);
        Object[] objectArray = new String[]{GLanguage.translate("harmonic"), GLanguage.translate("amplitude") + " [1]"};
        this.amplitudes = new JTable(new Object[30][2], objectArray);
        for (int i = 0; i < 30; ++i) {
            this.amplitudes.setValueAt(Integer.toString(i + 1), i, 0);
        }
        JScrollPane jScrollPane = new JScrollPane(this.amplitudes);
        this.amplitudes.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 3, 10, 6);
        this.reset = new JButton(GLanguage.translate("reset"));
        uiCartesianLayout.add(this.reset, 1, 9, 4, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 5, 9, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.reset.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.offset.refresh();
        this.basePeriod.refresh();
    }

    private void onApply() {
        float[] fArray = new float[30];
        for (int i = 0; i < fArray.length; ++i) {
            String string = (String)this.amplitudes.getValueAt(i, 1);
            if (string == null || string.length() <= 0) continue;
            fArray[i] = (float)Double.parseDouble(string);
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(new AOHarmonicsGenerator(fArray, (float)this.offset.getData(), (int)this.basePeriod.getData(), this.add.isSelected()));
    }

    private void onReset() {
        for (int i = 0; i < 30; ++i) {
            this.amplitudes.setValueAt(null, i, 1);
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPHarmonicsGenerator.this.apply) {
                GProgressViewer.start(GPHarmonicsGenerator.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPHarmonicsGenerator.this.getName() + " [apply] clicked");
                GPHarmonicsGenerator.this.onApply();
                GProgressViewer.setProgress(100);
                GPHarmonicsGenerator.this.updateHistory(GLanguage.translate(GPHarmonicsGenerator.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPHarmonicsGenerator.this.reloadFocussedClipEditor();
                GPHarmonicsGenerator.this.autoCloseNow();
            }
            if (actionEvent.getSource() == GPHarmonicsGenerator.this.reset) {
                Debug.println(1, "plugin " + GPHarmonicsGenerator.this.getName() + " [reset] clicked");
                GPHarmonicsGenerator.this.onReset();
            }
        }
    }
}

