/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GGraphicObjects;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class GPGraphicDocumentation
extends GPluginFrame {
    private GGraphicObjects graphicObjects;
    private JToggleButton lineButton;
    private JToggleButton rectangleButton;
    private JToggleButton textButton;
    private JToggleButton eraseButton;
    private JTextField text;
    private EventDispatcher eventDispatcher;

    public GPGraphicDocumentation(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "graphicDoc";
    }

    @Override
    public void start() {
        super.start();
        this.graphicObjects = this.getSelectedLayer().getSelectedChannel().getGraphicObjects();
        this.repaintFocussedClipEditor();
        this.reloadGui();
    }

    @Override
    public void reload() {
        super.reload();
        this.graphicObjects = this.getSelectedLayer().getSelectedChannel().getGraphicObjects();
        this.repaintFocussedClipEditor();
        this.reloadGui();
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.graphicObjects = this.getSelectedLayer().getSelectedChannel().getGraphicObjects();
            if (this.graphicObjects != null) {
                this.graphicObjects.mousePressed(mouseEvent);
            }
            this.reloadGui();
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            if (this.graphicObjects != null) {
                this.graphicObjects.mouseMoved(mouseEvent);
            }
            this.reloadGui();
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseDragged(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseReleased(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseClicked(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseEntered(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                aLayer.getChannel(i).getGraphicObjects().paintOntoClip(graphics2D, rectangle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 6, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(35, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.lineButton = new JToggleButton(GToolkit.loadIcon(this, "drawLine"));
        this.lineButton.setToolTipText(GLanguage.translate("drawLine"));
        jPanel.add((Component)this.lineButton, new Rectangle(0, 0, 1, 1));
        this.rectangleButton = new JToggleButton(GToolkit.loadIcon(this, "drawRectangle"));
        this.rectangleButton.setToolTipText(GLanguage.translate("drawRectangle"));
        jPanel.add((Component)this.rectangleButton, new Rectangle(1, 0, 1, 1));
        this.textButton = new JToggleButton(GToolkit.loadIcon(this, "drawText"));
        this.textButton.setToolTipText(GLanguage.translate("drawText"));
        jPanel.add((Component)this.textButton, new Rectangle(2, 0, 1, 1));
        this.eraseButton = new JToggleButton(GToolkit.loadIcon(this, "erase"));
        this.eraseButton.setToolTipText(GLanguage.translate("erase"));
        jPanel.add((Component)this.eraseButton, new Rectangle(3, 0, 1, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lineButton);
        buttonGroup.add(this.rectangleButton);
        buttonGroup.add(this.textButton);
        buttonGroup.add(this.eraseButton);
        jPanel.add((Component)new JLabel(GLanguage.translate("text")), new Rectangle(0, 1, 2, 1));
        this.text = new JTextField();
        jPanel.add((Component)this.text, new Rectangle(2, 1, 4, 1));
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.lineButton.addActionListener(this.eventDispatcher);
        this.rectangleButton.addActionListener(this.eventDispatcher);
        this.textButton.addActionListener(this.eventDispatcher);
        this.eraseButton.addActionListener(this.eventDispatcher);
        this.text.addActionListener(this.eventDispatcher);
    }

    private void reloadGui() {
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPGraphicDocumentation.this.lineButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [line] clicked");
                GPGraphicDocumentation.this.graphicObjects.setOperation(1);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.rectangleButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [rectangle] clicked");
                GPGraphicDocumentation.this.graphicObjects.setOperation(2);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.textButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [text] clicked");
                GPGraphicDocumentation.this.graphicObjects.setOperation(3);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.eraseButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [erase] clicked");
                GPGraphicDocumentation.this.graphicObjects.setOperation(4);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.text) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [text field] clicked");
                GPGraphicDocumentation.this.graphicObjects.setCurrentText(GPGraphicDocumentation.this.text.getText());
            }
        }
    }
}

