/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GCookie;
import ch.laoe.ui.GEditableFreehand;
import ch.laoe.ui.GEditableSegments;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GPFreeGenerator
extends GPluginFrame {
    private GEditableSegments segments;
    private GEditableFreehand freehand;
    private JButton clear;
    private JButton smooth;
    private JButton apply;
    private JButton copy;
    private JButton paste;
    private String[] interpolationItem = new String[]{GLanguage.translate("no"), GLanguage.translate("0Order"), GLanguage.translate("1Order"), GLanguage.translate("spline")};
    private JComboBox interpolation;
    private String[] operationItem = new String[]{GLanguage.translate("replace"), GLanguage.translate("envelope")};
    private JComboBox operation;
    private UiControlText xNumeric;
    private UiControlText yNumeric;
    private JCheckBox selectionIndependent;
    private JTabbedPane tab;
    private EventDispatcher eventDispatcher;
    private GEditableSegments segmentsClipBoard;
    private GEditableFreehand freehandClipBoard;

    public GPFreeGenerator(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
        this.updateCookie();
    }

    @Override
    public String getName() {
        return "freeGenerator";
    }

    @Override
    public void start() {
        super.start();
        this.updateCookie();
        this.reloadGui();
    }

    @Override
    public void reload() {
        super.reload();
        this.updateCookie();
        this.reloadGui();
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    private void updateCookie() {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                if (aLayer.getChannel(i).getCookies().getCookie(this.getName()) != null) continue;
                AChannel aChannel = aLayer.getChannel(i);
                aChannel.getCookies().setCookie(new GCookieFreeGenerator(aChannel), this.getName());
            }
            this.segments = ((GCookieFreeGenerator)this.getSelectedLayer().getSelectedChannel().getCookies().getCookie((String)this.getName())).segments;
            this.freehand = ((GCookieFreeGenerator)this.getSelectedLayer().getSelectedChannel().getCookies().getCookie((String)this.getName())).freehand;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            switch (this.tab.getSelectedIndex()) {
                case 0: {
                    this.segments = ((GCookieFreeGenerator)this.getSelectedLayer().getChannel((Point)mouseEvent.getPoint()).getCookies().getCookie((String)this.getName())).segments;
                    this.segments.mousePressed(mouseEvent);
                    break;
                }
                case 1: {
                    this.freehand = ((GCookieFreeGenerator)this.getSelectedLayer().getChannel((Point)mouseEvent.getPoint()).getCookies().getCookie((String)this.getName())).freehand;
                    this.freehand.mousePressed(mouseEvent);
                }
            }
            this.reloadGui();
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            switch (this.tab.getSelectedIndex()) {
                case 0: {
                    this.segments = ((GCookieFreeGenerator)this.getSelectedLayer().getChannel((Point)mouseEvent.getPoint()).getCookies().getCookie((String)this.getName())).segments;
                    this.segments.mouseMoved(mouseEvent);
                    break;
                }
                case 1: {
                    this.freehand = ((GCookieFreeGenerator)this.getSelectedLayer().getChannel((Point)mouseEvent.getPoint()).getCookies().getCookie((String)this.getName())).freehand;
                    this.freehand.mouseMoved(mouseEvent);
                }
            }
            this.reloadGui();
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.segments.mouseDragged(mouseEvent);
                break;
            }
            case 1: {
                this.freehand.mouseDragged(mouseEvent);
            }
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.segments.mouseClicked(mouseEvent);
                break;
            }
            case 1: {
                this.freehand.mouseClicked(mouseEvent);
            }
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.segments.mouseEntered(mouseEvent);
                break;
            }
            case 1: {
                this.freehand.mouseEntered(mouseEvent);
            }
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        try {
            ALayer aLayer = this.getSelectedLayer();
            block6: for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                switch (this.tab.getSelectedIndex()) {
                    case 0: {
                        ((GCookieFreeGenerator)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).segments.paintOntoClip(graphics2D, rectangle);
                        continue block6;
                    }
                    case 1: {
                        ((GCookieFreeGenerator)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).freehand.paintOntoClip(graphics2D, rectangle);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 8);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.tab = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 3);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("interpolation")), 0, 0, 5, 1);
        this.interpolation = new JComboBox<String>(this.interpolationItem);
        this.interpolation.setSelectedIndex(2);
        uiCartesianLayout2.add(this.interpolation, 5, 0, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("x")), 0, 1, 5, 1);
        this.xNumeric = new GControlTextX(this.getMain(), 7, false, true);
        this.xNumeric.setDataRange(-1.0E9, 1.0E9);
        this.xNumeric.setData(0.0);
        this.xNumeric.setEditable(false);
        uiCartesianLayout2.add(this.xNumeric, 0, 2, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("y")), 5, 1, 5, 1);
        this.yNumeric = new GControlTextY(this.getMain(), 7, false, true);
        this.yNumeric.setDataRange(-1.0E9, 1.0E9);
        this.yNumeric.setData(0.0);
        this.yNumeric.setEditable(false);
        uiCartesianLayout2.add(this.yNumeric, 5, 2, 5, 1);
        this.tab.add((Component)jPanel2, GLanguage.translate("points"));
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 3);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        this.smooth = new JButton(GLanguage.translate("smooth"));
        uiCartesianLayout3.add(this.smooth, 3, 1, 4, 1);
        this.tab.add((Component)jPanel3, GLanguage.translate("freeHand"));
        uiCartesianLayout.add(this.tab, 0, 0, 10, 4);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("operation")), 0, 5, 4, 1);
        this.operation = new JComboBox<String>(this.operationItem);
        this.operation.setSelectedIndex(0);
        uiCartesianLayout.add(this.operation, 4, 5, 6, 1);
        this.selectionIndependent = new JCheckBox(GLanguage.translate("selectionIndependent"));
        this.selectionIndependent.setSelected(true);
        uiCartesianLayout.add(this.selectionIndependent, 0, 4, 8, 1);
        this.clear = new JButton(GLanguage.translate("reset"));
        uiCartesianLayout.add(this.clear, 1, 6, 4, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 5, 6, 4, 1);
        this.copy = new JButton(GLanguage.translate("copy"));
        uiCartesianLayout.add(this.copy, 1, 7, 4, 1);
        this.paste = new JButton(GLanguage.translate("paste"));
        uiCartesianLayout.add(this.paste, 5, 7, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.clear.addActionListener(this.eventDispatcher);
        this.smooth.addActionListener(this.eventDispatcher);
        this.apply.addActionListener(this.eventDispatcher);
        this.copy.addActionListener(this.eventDispatcher);
        this.paste.addActionListener(this.eventDispatcher);
        this.tab.addChangeListener(this.eventDispatcher);
        this.interpolation.addActionListener(this.eventDispatcher);
        this.onInterpolationChange();
    }

    private void reloadGui() {
        switch (this.segments.getSegmentMode()) {
            case -1: {
                this.interpolation.setSelectedIndex(0);
                break;
            }
            case 0: {
                this.interpolation.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.interpolation.setSelectedIndex(2);
                break;
            }
            case 4: {
                this.interpolation.setSelectedIndex(3);
            }
        }
        this.xNumeric.setData(this.segments.getActivePointX());
        this.yNumeric.setData(this.segments.getActivePointY());
    }

    private void onClear() {
        this.updateCookie();
        switch (this.tab.getSelectedIndex()) {
            case 0: {
                this.segments.clear();
                break;
            }
            case 1: {
                this.freehand.clear();
            }
        }
    }

    private void onSmooth() {
        this.updateCookie();
        this.freehand.smooth();
    }

    private void onApply() {
        ALayer aLayer = this.getSelectedLayer();
        block8: for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            GEditableSegments gEditableSegments = ((GCookieFreeGenerator)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).segments;
            GEditableFreehand gEditableFreehand = ((GCookieFreeGenerator)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).freehand;
            int n = 0;
            switch (this.operation.getSelectedIndex()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                }
            }
            switch (this.tab.getSelectedIndex()) {
                case 0: {
                    if (this.selectionIndependent.isSelected()) {
                        gEditableSegments.convertToSamples(n);
                        continue block8;
                    }
                    gEditableSegments.convertToSelectedSamples(n);
                    continue block8;
                }
                case 1: {
                    if (this.selectionIndependent.isSelected()) {
                        gEditableFreehand.convertToSamples(n);
                        continue block8;
                    }
                    gEditableFreehand.convertToSelectedSamples(n);
                }
            }
        }
    }

    private void onInterpolationChange() {
        ALayer aLayer = this.getSelectedLayer();
        try {
            block11: for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                GEditableSegments gEditableSegments = ((GCookieFreeGenerator)aLayer.getChannel((int)i).getCookies().getCookie((String)this.getName())).segments;
                switch (this.tab.getSelectedIndex()) {
                    case 0: {
                        switch (this.interpolation.getSelectedIndex()) {
                            case 0: {
                                gEditableSegments.setSegmentMode(-1);
                                break;
                            }
                            case 1: {
                                gEditableSegments.setSegmentMode(0);
                                break;
                            }
                            case 2: {
                                gEditableSegments.setSegmentMode(1);
                                break;
                            }
                            case 3: {
                                gEditableSegments.setSegmentMode(4);
                            }
                        }
                        continue block11;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCopy() {
        this.updateCookie();
        this.segmentsClipBoard = new GEditableSegments(this.segments);
        this.freehandClipBoard = new GEditableFreehand(this.freehand);
        this.repaintFocussedClipEditor();
    }

    private void onPaste() {
        AChannel aChannel = this.getFocussedClip().getSelectedLayer().getSelectedChannel();
        this.segments = new GEditableSegments(this.segmentsClipBoard);
        this.segments.setChannel(aChannel);
        ((GCookieFreeGenerator)this.getSelectedLayer().getSelectedChannel().getCookies().getCookie((String)this.getName())).segments = this.segments;
        this.freehand = new GEditableFreehand(this.freehandClipBoard);
        this.freehand.setChannel(aChannel);
        ((GCookieFreeGenerator)this.getSelectedLayer().getSelectedChannel().getCookies().getCookie((String)this.getName())).freehand = this.freehand;
        this.repaintFocussedClipEditor();
    }

    private class EventDispatcher
    implements ActionListener,
    ChangeListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPFreeGenerator.this.clear) {
                Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [clear] clicked");
                GPFreeGenerator.this.onClear();
            } else if (actionEvent.getSource() == GPFreeGenerator.this.smooth) {
                Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [smooth] clicked");
                GPFreeGenerator.this.onSmooth();
            } else if (actionEvent.getSource() == GPFreeGenerator.this.apply) {
                GProgressViewer.start(GPFreeGenerator.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [apply] clicked");
                GPFreeGenerator.this.onApply();
                GProgressViewer.setProgress(100);
                GPFreeGenerator.this.updateHistory(GLanguage.translate(GPFreeGenerator.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPFreeGenerator.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPFreeGenerator.this.copy) {
                Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [copy] clicked");
                GPFreeGenerator.this.onCopy();
            } else if (actionEvent.getSource() == GPFreeGenerator.this.paste) {
                Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [paste] clicked");
                GPFreeGenerator.this.onPaste();
            } else if (actionEvent.getSource() == GPFreeGenerator.this.interpolation) {
                Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [interpolation] clicked");
                GPFreeGenerator.this.onInterpolationChange();
            }
            GPFreeGenerator.this.reloadFocussedClipEditor();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Debug.println(1, "plugin " + GPFreeGenerator.this.getName() + " [tab] clicked");
            GPFreeGenerator.this.onInterpolationChange();
        }
    }

    private class GCookieFreeGenerator
    extends GCookie {
        public GEditableSegments segments = new GEditableSegments();
        public GEditableFreehand freehand;

        public GCookieFreeGenerator(AChannel aChannel) {
            this.segments.setChannel(aChannel);
            this.freehand = new GEditableFreehand();
            this.freehand.setChannel(aChannel);
        }
    }
}

