/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.audio.AFileOptions;
import ch.laoe.audio.Audio;
import ch.laoe.audio.AudioException;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMeasure;
import ch.laoe.plugin.GFileFilter;
import ch.laoe.plugin.GPFileView;
import ch.laoe.plugin.GPlugin;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class GPFileSaveAs
extends GPlugin {
    private JFileChooser fileChooser;

    public GPFileSaveAs(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.fileChooser = new JFileChooser(this.persistance.getString("plugin." + this.getName() + ".currentDirectory"));
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        GFileFilter gFileFilter = new GFileFilter(".laoe");
        this.fileChooser.addChoosableFileFilter(gFileFilter);
        this.fileChooser.addChoosableFileFilter(new GFileFilter(".wav"));
        this.fileChooser.addChoosableFileFilter(new GFileFilter(".au"));
        this.fileChooser.addChoosableFileFilter(new GFileFilter(".aiff"));
        this.fileChooser.addChoosableFileFilter(new GFileFilter(".snd"));
        this.fileChooser.setFileFilter(gFileFilter);
        this.fileChooser.setFileView(new GPFileView());
    }

    @Override
    public String getName() {
        return "saveAs";
    }

    private boolean hasClippedSamples() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        AOMeasure aOMeasure = new AOMeasure(this.getFocussedClip().getSampleWidth());
        aLayerSelection.operateEachChannel(aOMeasure);
        return aOMeasure.getNumberOfClippedSamples() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.fileChooser.showSaveDialog(null) == 0) {
            try {
                File file = this.fileChooser.getSelectedFile();
                String string = this.fileChooser.getFileFilter().getDescription().toLowerCase();
                Audio audio = this.getFocussedClip().getAudio();
                if (file.getName().indexOf(46) < 0) {
                    file = new File(file.getPath() + string);
                }
                if (file.isDirectory()) {
                    GDialog.showErrorDialog(this.fileChooser, "fileError", "isDirectory");
                    return;
                }
                if (file.isFile() && !GDialog.showYesNoQuestionDialog(this.fileChooser, "fileWarning", "overwrite?")) {
                    return;
                }
                AFileOptions aFileOptions = Audio.createFileOptions(string);
                JPanel jPanel = aFileOptions.getPanel();
                if (jPanel != null && !GDialog.showCustomOkCancelDialog(null, jPanel, GLanguage.translate("options"))) {
                    return;
                }
                if (this.hasClippedSamples()) {
                    GDialog.showWarningDialog(this.fileChooser, "fileWarning", "containsClippedSamples");
                }
                GProgressViewer.start("saving");
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                audio.setFileType(string);
                audio.setFileOptions(aFileOptions);
                audio.saveAs(file);
                this.getFocussedClip().setName(file.getName());
                GProgressViewer.setProgress(100);
                this.getFocussedClip().getHistory().onSave();
                GProgressViewer.exitSubProgress();
                this.updateFrameTitle();
            }
            catch (AudioException audioException) {
                GDialog.showErrorDialog(null, "audioError", audioException.getMessage());
            }
            finally {
                GProgressViewer.finish();
            }
        }
    }

    @Override
    public void onBackup(Persistence persistence) {
        this.persistance.setString("plugin." + this.getName() + ".currentDirectory", this.fileChooser.getCurrentDirectory().getPath());
    }
}

