/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOFft;
import ch.laoe.operation.AOIfft;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPFft
extends GPluginFrame {
    private JComboBox operation;
    private GClipLayerChooser phaseLayer;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPFft(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "fft";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("operation")), 0, 0, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("fft"), GLanguage.translate("ifft")};
        this.operation = new JComboBox<String>(stringArray);
        this.operation.setSelectedIndex(0);
        uiCartesianLayout.add(this.operation, 5, 0, 5, 1);
        this.phaseLayer = new GClipLayerChooser(this.getMain(), "phaseLayer");
        uiCartesianLayout.add(this.phaseLayer, 0, 2, 10, 3);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 5, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.operation.addActionListener(this.eventDispatcher);
        this.updateComponents();
    }

    @Override
    public void reload() {
        super.reload();
        this.phaseLayer.reload();
    }

    private void updateComponents() {
        switch (this.operation.getSelectedIndex()) {
            case 0: {
                this.phaseLayer.setEnabled(false);
                break;
            }
            case 1: {
                this.phaseLayer.setEnabled(true);
            }
        }
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        switch (this.operation.getSelectedIndex()) {
            case 0: {
                ALayer aLayer = this.getFocussedClip().getSelectedLayer();
                ALayer aLayer2 = new ALayer(aLayer.getNumberOfChannels(), aLayer.getMaxSampleLength());
                aLayer2.setName(GLanguage.translate("phaseOf") + " " + aLayer.getName());
                aLayer2.setType(2);
                this.getFocussedClip().add(aLayer2);
                AClipSelection aClipSelection = new AClipSelection(new AClip());
                aClipSelection.addLayerSelection(aLayer.createLayerSelection());
                aClipSelection.addLayerSelection(aLayer2.createLayerSelection());
                aClipSelection.operateLayer0WithLayer1(new AOFft());
                break;
            }
            case 1: {
                ALayer aLayer = this.getFocussedClip().getSelectedLayer();
                ALayer aLayer3 = this.phaseLayer.getSelectedLayer();
                AClipSelection aClipSelection = new AClipSelection(new AClip());
                aClipSelection.addLayerSelection(aLayer.createLayerSelection());
                aClipSelection.addLayerSelection(aLayer3.createLayerSelection());
                aClipSelection.operateLayer0WithLayer1(new AOIfft());
            }
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPFft.this.apply) {
                GProgressViewer.start(GPFft.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPFft.this.getName() + " [apply] clicked");
                GPFft.this.onApply();
                GProgressViewer.setProgress(100);
                GPFft.this.updateHistory(GLanguage.translate(GPFft.this.getName() + " " + (String)GPFft.this.operation.getSelectedItem()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPFft.this.reloadFocussedClipEditor();
                GPFft.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPFft.this.operation) {
                Debug.println(1, "plugin " + GPFft.this.getName() + " [operation] clicked");
                GPFft.this.updateComponents();
            }
        }
    }
}

