/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOFade;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPFade
extends GPluginFrame {
    private JComboBox fadeType;
    private JComboBox order;
    private JCheckBox continueLow;
    private UiControlText lowFactor;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPFade(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "fade";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("fadeIn"), GLanguage.translate("fadeOut"), GLanguage.translate("fadeCross")};
        this.fadeType = new JComboBox<String>(stringArray);
        this.fadeType.setSelectedIndex(0);
        uiCartesianLayout.add(this.fadeType, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("order")), 0, 1, 4, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("squareRoot"), GLanguage.translate("linear"), GLanguage.translate("square"), GLanguage.translate("cubic")};
        this.order = new JComboBox<String>(stringArray2);
        this.order.setSelectedIndex(2);
        uiCartesianLayout.add(this.order, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("lowFactor")), 0, 2, 4, 1);
        this.lowFactor = new GControlTextA(7, true, true);
        this.lowFactor.setDataRange(0.0, 1.0);
        this.lowFactor.setData(0.0);
        uiCartesianLayout.add(this.lowFactor, 4, 2, 6, 1);
        this.continueLow = new JCheckBox(GLanguage.translate("continueLow"));
        uiCartesianLayout.add(this.continueLow, 0, 3, 5, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 4, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.fadeType.addActionListener(this.eventDispatcher);
        this.apply.addActionListener(this.eventDispatcher);
        this.updateComponents();
    }

    @Override
    public void reload() {
        super.reload();
        this.lowFactor.refresh();
    }

    private void updateComponents() {
        switch (this.fadeType.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.continueLow.setEnabled(true);
                this.lowFactor.setEnabled(true);
                break;
            }
            default: {
                this.continueLow.setEnabled(false);
                this.lowFactor.setEnabled(false);
            }
        }
    }

    private void onApply() {
        int n = 1;
        switch (this.fadeType.getSelectedIndex()) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
            }
        }
        int n2 = 2;
        switch (this.order.getSelectedIndex()) {
            case 0: {
                n2 = -2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
            }
        }
        boolean bl = this.continueLow.isSelected();
        float f = (float)this.lowFactor.getData();
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(new AOFade(n, n2, f, bl));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPFade.this.apply) {
                GProgressViewer.start(GPFade.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPFade.this.getName() + " [apply] clicked");
                GPFade.this.onApply();
                GProgressViewer.setProgress(100);
                GPFade.this.updateHistory(GLanguage.translate(GPFade.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPFade.this.reloadFocussedClipEditor();
                GPFade.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPFade.this.fadeType) {
                Debug.println(1, "plugin " + GPFade.this.getName() + " [fade type] clicked");
                GPFade.this.updateComponents();
            }
        }
    }
}

