/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AODisharmony;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPDisharmony
extends GPluginFrame {
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText shift;
    private JComboBox type;
    private GComboBoxPowerOf2 bufferLength;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPDisharmony(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "disharmony";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        String[] stringArray = new String[]{GLanguage.translate("shift"), GLanguage.translate("blur"), GLanguage.translate("unpitch"), GLanguage.translate("bassDephase"), GLanguage.translate("trebleDephase")};
        uiCartesianLayout.add(new JLabel(GLanguage.translate("type")), 0, 0, 5, 1);
        this.type = new JComboBox<String>(stringArray);
        this.type.setSelectedIndex(0);
        uiCartesianLayout.add(this.type, 5, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 1, 5, 1);
        this.dry = new GControlTextA(6, true, true);
        this.dry.setDataRange(0.0, 1.0);
        this.dry.setData(0.0);
        uiCartesianLayout.add(this.dry, 5, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 2, 5, 1);
        this.wet = new GControlTextA(6, true, true);
        this.wet.setDataRange(0.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 5, 2, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("disharmony")), 0, 3, 5, 1);
        this.shift = new GControlTextA(6, true, true);
        this.shift.setDataRange(-1.0, 1.0);
        this.shift.setData(0.01);
        uiCartesianLayout.add(this.shift, 5, 3, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("bufferLength")), 0, 4, 5, 1);
        this.bufferLength = new GComboBoxPowerOf2(7, 20);
        this.bufferLength.setSelectedExponent(10);
        uiCartesianLayout.add(this.bufferLength, 5, 4, 5, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 5, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.dry.refresh();
        this.wet.refresh();
        this.shift.refresh();
    }

    private void onApply() {
        int n = this.bufferLength.getSelectedValue();
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(new AODisharmony(this.type.getSelectedIndex(), (float)this.dry.getData(), (float)this.wet.getData(), (float)this.shift.getData(), n));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPDisharmony.this.apply) {
                GProgressViewer.start(GPDisharmony.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPDisharmony.this.getName() + " [apply] clicked");
                GPDisharmony.this.onApply();
                GProgressViewer.setProgress(100);
                GPDisharmony.this.updateHistory(GLanguage.translate(GPDisharmony.this.getName() + " " + (String)GPDisharmony.this.type.getSelectedItem()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPDisharmony.this.reloadFocussedClipEditor();
                GPDisharmony.this.autoCloseNow();
            }
        }
    }
}

