/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AODelayEcho;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class GPDelayEcho
extends GPluginFrame {
    private JComboBox room;
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText delay;
    private UiControlText gain;
    private JTable shape;
    private GClipLayerChooser layerChooser;
    private JButton apply1;
    private JButton apply2;
    private Preset[] presets;
    private int presetIndex = 0;
    private EventDispatcher eventDispatcher;
    private static final int maxRows = 50;

    public GPDelayEcho(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        try {
            this.initGui();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "delayEcho";
    }

    private void loadPresets() {
        try {
            PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
            try {
                ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
            this.presets = new Preset[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                this.presets[i] = new Preset();
                this.presets[i].name = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
                this.presets[i].dry = ((Persistence)persistenceDefaultImpl).getFloat("dry_" + i);
                this.presets[i].wet = ((Persistence)persistenceDefaultImpl).getFloat("wet_" + i);
                this.presets[i].delay = ((Persistence)persistenceDefaultImpl).getFloat("delay_" + i);
                this.presets[i].gain = ((Persistence)persistenceDefaultImpl).getFloat("gain_" + i);
                this.presets[i].delayShape = new double[((Persistence)persistenceDefaultImpl).getInt("shapeWidth_" + i)];
                for (n2 = 0; n2 < this.presets[i].delayShape.length; ++n2) {
                    this.presets[i].delayShape[n2] = ((Persistence)persistenceDefaultImpl).getDouble("delayShape_" + i + "_" + n2);
                }
                this.presets[i].gainShape = new double[((Persistence)persistenceDefaultImpl).getInt("shapeWidth_" + i)];
                for (n2 = 0; n2 < this.presets[i].gainShape.length; ++n2) {
                    this.presets[i].gainShape[n2] = ((Persistence)persistenceDefaultImpl).getDouble("gainShape_" + i + "_" + n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initGui() {
        this.loadPresets();
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 11);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("delayEchoType")), 0, 0, 4, 1);
        String[] stringArray = new String[this.presets.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.presets[i].name;
        }
        this.room = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.room, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 1, 4, 1);
        this.dry = new GControlTextA(7, true, true);
        this.dry.setDataRange(-1.0, 1.0);
        this.dry.setData(1.0);
        uiCartesianLayout.add(this.dry, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 2, 4, 1);
        this.wet = new GControlTextA(7, true, true);
        this.wet.setDataRange(-1.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("delay")), 0, 3, 4, 1);
        this.delay = new GControlTextX(this.getMain(), 7, true, true);
        this.delay.setDataRange(-1.0E9, 1.0E9);
        this.delay.setData(1100.0);
        uiCartesianLayout.add(this.delay, 4, 3, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("gain")), 0, 4, 4, 1);
        this.gain = new GControlTextA(7, true, true);
        this.gain.setDataRange(-100.0, 100.0);
        this.gain.setData(0.3);
        uiCartesianLayout.add(this.gain, 4, 4, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shape")), 0, 5, 4, 1);
        Object[] objectArray = new String[]{GLanguage.translate("delay"), GLanguage.translate("gain")};
        this.shape = new JTable(new Object[50][2], objectArray);
        JScrollPane jScrollPane = new JScrollPane(this.shape);
        this.shape.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 6, 10, 4);
        this.onRoomChange();
        this.apply1 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply1, 3, 10, 4, 1);
        jTabbedPane.add(GLanguage.translate("standard"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 11);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(this.getMain(), "room");
        uiCartesianLayout2.add(this.layerChooser, 0, 0, 10, 3);
        this.apply2 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.apply2, 3, 10, 4, 1);
        jTabbedPane.add(GLanguage.translate("curve"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply1.addActionListener(this.eventDispatcher);
        this.apply2.addActionListener(this.eventDispatcher);
        this.room.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.dry.refresh();
        this.wet.refresh();
        this.delay.refresh();
        this.gain.refresh();
    }

    private void loadDelayEchoPoints(double[] dArray, double[] dArray2) {
        for (int i = 0; i < 50; ++i) {
            if (i < dArray.length) {
                this.shape.setValueAt(String.valueOf(dArray[i]), i, 0);
                this.shape.setValueAt(String.valueOf(dArray2[i]), i, 1);
                continue;
            }
            this.shape.setValueAt("", i, 0);
            this.shape.setValueAt("", i, 1);
        }
    }

    private void onRoomChange() {
        this.presetIndex = this.room.getSelectedIndex();
        this.dry.setData(this.presets[this.presetIndex].dry);
        this.wet.setData(this.presets[this.presetIndex].wet);
        this.delay.setData(this.presets[this.presetIndex].delay);
        this.gain.setData(this.presets[this.presetIndex].gain);
        this.loadDelayEchoPoints(this.presets[this.presetIndex].delayShape, this.presets[this.presetIndex].gainShape);
    }

    private void onApply1() {
        int n = 0;
        for (int i = 0; i < this.shape.getRowCount(); ++i) {
            try {
                Float.parseFloat((String)this.shape.getValueAt(i, 0));
                ++n;
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        MMArray mMArray = new MMArray(n, 0.0f);
        MMArray mMArray2 = new MMArray(n, 0.0f);
        for (int i = 0; i < n; ++i) {
            try {
                mMArray.set(i, Float.parseFloat((String)this.shape.getValueAt(i, 0)));
                mMArray2.set(i, Float.parseFloat((String)this.shape.getValueAt(i, 1)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        aLayerSelection.operateEachChannel(new AODelayEcho(mMArray, mMArray2, (float)this.delay.getData(), (float)this.gain.getData(), (float)this.dry.getData(), (float)this.wet.getData()));
    }

    private void onApply2() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createLayerSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AODelayEcho(0.0f, 1.0f));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPDelayEcho.this.apply1) {
                GProgressViewer.start(GPDelayEcho.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPDelayEcho.this.getName() + " [apply1] clicked");
                GPDelayEcho.this.onApply1();
                GProgressViewer.setProgress(100);
                GPDelayEcho.this.updateHistory(GLanguage.translate(GPDelayEcho.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPDelayEcho.this.reloadFocussedClipEditor();
                GPDelayEcho.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPDelayEcho.this.apply2) {
                GProgressViewer.start(GPDelayEcho.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPDelayEcho.this.getName() + " [apply2] clicked");
                GPDelayEcho.this.onApply2();
                GProgressViewer.setProgress(100);
                GPDelayEcho.this.updateHistory(GLanguage.translate(GPDelayEcho.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPDelayEcho.this.reloadFocussedClipEditor();
                GPDelayEcho.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPDelayEcho.this.room) {
                GPDelayEcho.this.onRoomChange();
            }
        }
    }

    private class Preset {
        public String name;
        public float dry;
        public float wet;
        public float delay;
        public float gain;
        public double[] delayShape;
        public double[] gainShape;

        private Preset() {
        }
    }
}

