/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOAutoCropSilence;
import ch.laoe.operation.AOCropSelection;
import ch.laoe.operation.AOCropSilence;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPCrop
extends GPluginFrame {
    private String[] cropTypeItem = new String[]{GLanguage.translate("borderSilence"), GLanguage.translate("everySilence"), GLanguage.translate("selection")};
    private JComboBox cropType;
    private UiControlText silenceLimit;
    private UiControlText silenceTMin;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPCrop(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "crop";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 0, 4, 1);
        this.cropType = new JComboBox<String>(this.cropTypeItem);
        uiCartesianLayout.add(this.cropType, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("silenceThreshold")), 0, 1, 4, 1);
        this.silenceLimit = new GControlTextY(this.getMain(), 6, true, true);
        this.silenceLimit.setDataRange(0.0, 1000000.0);
        this.silenceLimit.setData(33.0);
        uiCartesianLayout.add(this.silenceLimit, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("silenceMinTime")), 0, 2, 4, 1);
        this.silenceTMin = new GControlTextX(this.getMain(), 6, true, true);
        this.silenceTMin.setDataRange(0.0, 1000000.0);
        this.silenceTMin.setData(50.0);
        uiCartesianLayout.add(this.silenceTMin, 4, 2, 6, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 3, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.cropType.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.silenceLimit.refresh();
        this.silenceTMin.refresh();
    }

    @Override
    public void start() {
        super.start();
        this.updateActiveComponents();
    }

    private void updateActiveComponents() {
        switch (this.cropType.getSelectedIndex()) {
            case 0: {
                this.silenceLimit.setEnabled(true);
                this.silenceTMin.setEnabled(false);
                break;
            }
            case 1: {
                this.silenceLimit.setEnabled(true);
                this.silenceTMin.setEnabled(true);
                break;
            }
            case 2: {
                this.silenceLimit.setEnabled(false);
                this.silenceTMin.setEnabled(false);
            }
        }
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        switch (this.cropType.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOCropSilence((float)this.silenceLimit.getData()));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AOAutoCropSilence((float)this.silenceLimit.getData(), (int)this.silenceTMin.getData()));
                break;
            }
            case 2: {
                aLayerSelection.operateEachChannel(new AOCropSelection());
            }
        }
        this.updateHistory(GLanguage.translate(this.getName()));
        this.pluginHandler.getFocussedClip().getSelectedLayer().setEmptyLayerSelection();
        this.reloadFocussedClipEditor();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPCrop.this.cropType) {
                Debug.println(1, "plugin " + GPCrop.this.getName() + " [cropType] clicked");
                GPCrop.this.updateActiveComponents();
            } else if (actionEvent.getSource() == GPCrop.this.apply) {
                GProgressViewer.start(GPCrop.this.getName());
                Debug.println(1, "plugin " + GPCrop.this.getName() + " [apply] clicked");
                GPCrop.this.onApply();
                GProgressViewer.finish();
                GPCrop.this.reloadFocussedClipEditor();
                GPCrop.this.autoCloseNow();
            }
        }
    }
}

