/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOConvolution;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class GPConvolution
extends GPluginFrame {
    private JTable kernel;
    private GClipLayerChooser layerChooser;
    private JButton apply1;
    private JButton apply2;
    private EventDispatcher eventDispatcher;
    private static final int maxRows = 50;

    public GPConvolution(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "convolution";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 5);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        Object[] objectArray = new String[]{GLanguage.translate("kernel"), GLanguage.translate("value")};
        this.kernel = new JTable(new Object[50][2], objectArray);
        for (int i = 0; i < 50; ++i) {
            this.kernel.setValueAt(String.valueOf(i), i, 0);
            this.kernel.setValueAt(String.valueOf(0), i, 1);
        }
        JScrollPane jScrollPane = new JScrollPane(this.kernel);
        this.kernel.setPreferredScrollableViewportSize(new Dimension(200, 70));
        uiCartesianLayout.add(jScrollPane, 0, 0, 10, 4);
        this.apply1 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply1, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("list"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(this.getMain(), "kernelLayer");
        uiCartesianLayout2.add(this.layerChooser, 0, 0, 10, 3);
        this.apply2 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.apply2, 3, 4, 4, 1);
        jTabbedPane.add(GLanguage.translate("layer"), jPanel2);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply1.addActionListener(this.eventDispatcher);
        this.apply2.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
    }

    private void onApply1() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        MMArray mMArray = new MMArray(this.kernel.getRowCount(), 0.0f);
        for (int i = 0; i < this.kernel.getRowCount(); ++i) {
            try {
                mMArray.set(i, Float.parseFloat((String)this.kernel.getValueAt(i, 1)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        aLayerSelection.operateEachChannel(new AOConvolution(mMArray));
    }

    private void onApply2() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createLayerSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AOConvolution());
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GProgressViewer.start(GPConvolution.this.getName());
            if (actionEvent.getSource() == GPConvolution.this.apply1) {
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPConvolution.this.getName() + " [apply1] clicked");
                GPConvolution.this.onApply1();
                GProgressViewer.setProgress(100);
                GPConvolution.this.updateHistory(GLanguage.translate(GPConvolution.this.getName()));
                GProgressViewer.exitSubProgress();
                GPConvolution.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPConvolution.this.apply2) {
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPConvolution.this.getName() + " [apply2] clicked");
                GPConvolution.this.onApply2();
                GProgressViewer.setProgress(100);
                GPConvolution.this.updateHistory(GLanguage.translate(GPConvolution.this.getName()));
                GProgressViewer.exitSubProgress();
                GPConvolution.this.autoCloseNow();
            }
            GProgressViewer.finish();
            GPConvolution.this.reloadFocussedClipEditor();
        }
    }
}

