/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOCompressExpand;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPCompressExpand
extends GPluginFrame {
    private JComboBox effect;
    private UiControlText attack;
    private UiControlText release;
    private UiControlText x0;
    private UiControlText y0;
    private UiControlText x1;
    private UiControlText y1;
    private UiControlText x2;
    private UiControlText y2;
    private JButton applySeg;
    private JButton applyVar;
    private GClipLayerChooser layerChooser;
    private String[] presetsName;
    private float[] x0Presets;
    private float[] y0Presets;
    private float[] x1Presets;
    private float[] y1Presets;
    private float[] x2Presets;
    private float[] y2Presets;
    private float[] attackPresets;
    private float[] releasePresets;
    private EventDispatcher eventDispatcher;

    public GPCompressExpand(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "compressExpand";
    }

    private void initGui() {
        PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
        try {
            ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
        this.presetsName = new String[n];
        this.x0Presets = new float[n];
        this.y0Presets = new float[n];
        this.x1Presets = new float[n];
        this.y1Presets = new float[n];
        this.x2Presets = new float[n];
        this.y2Presets = new float[n];
        this.attackPresets = new float[n];
        this.releasePresets = new float[n];
        for (int i = 0; i < n; ++i) {
            this.presetsName[i] = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
            this.x0Presets[i] = ((Persistence)persistenceDefaultImpl).getFloat("x0_" + i);
            this.y0Presets[i] = ((Persistence)persistenceDefaultImpl).getFloat("y0_" + i);
            this.x1Presets[i] = ((Persistence)persistenceDefaultImpl).getFloat("x1_" + i);
            this.y1Presets[i] = ((Persistence)persistenceDefaultImpl).getFloat("y1_" + i);
            this.x2Presets[i] = ((Persistence)persistenceDefaultImpl).getFloat("x2_" + i);
            this.y2Presets[i] = ((Persistence)persistenceDefaultImpl).getFloat("y2_" + i);
            this.attackPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("attack_" + i);
            this.releasePresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("release_" + i);
        }
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 9);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("effect")), 0, 0, 4, 1);
        this.effect = new JComboBox<String>(this.presetsName);
        uiCartesianLayout.add(this.effect, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("attack")), 0, 1, 4, 1);
        this.attack = new GControlTextX(this.getMain(), 7, true, true);
        this.attack.setDataRange(1.0, 1.0E9);
        this.attack.setData(1000.0);
        this.attack.setUnit("ms");
        uiCartesianLayout.add(this.attack, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("release")), 0, 2, 4, 1);
        this.release = new GControlTextX(this.getMain(), 7, true, true);
        this.release.setDataRange(0.0, 1.0E9);
        this.release.setData(1000.0);
        this.release.setUnit("ms");
        uiCartesianLayout.add(this.release, 4, 2, 6, 1);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 5);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("factor")), 0, 0, 4, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("atAmplitude")), 5, 0, 4, 1);
        this.x0 = new GControlTextY(this.getMain(), 7, true, true);
        this.x0.setDataRange(0.0, 1.0E9);
        uiCartesianLayout2.add(this.x0, 5, 1, 5, 1);
        this.y0 = new GControlTextA(7, true, true);
        this.y0.setDataRange(-1.0E9, 1.0E9);
        uiCartesianLayout2.add(this.y0, 0, 1, 5, 1);
        this.x1 = new GControlTextY(this.getMain(), 7, true, true);
        this.x1.setDataRange(0.0, 1.0E9);
        uiCartesianLayout2.add(this.x1, 5, 2, 5, 1);
        this.y1 = new GControlTextA(7, true, true);
        this.y1.setDataRange(-1.0E9, 1.0E9);
        uiCartesianLayout2.add(this.y1, 0, 2, 5, 1);
        this.x2 = new GControlTextY(this.getMain(), 7, true, true);
        this.x2.setDataRange(0.0, 1.0E9);
        uiCartesianLayout2.add(this.x2, 5, 3, 5, 1);
        this.y2 = new GControlTextA(7, true, true);
        this.y2.setDataRange(-1.0E9, 1.0E9);
        uiCartesianLayout2.add(this.y2, 0, 3, 5, 1);
        this.applySeg = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.applySeg, 3, 4, 4, 1);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 5);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        this.layerChooser = new GClipLayerChooser(this.getMain(), "transferFunction");
        uiCartesianLayout3.add(this.layerChooser, 0, 0, 10, 3);
        this.applyVar = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.applyVar, 3, 4, 4, 1);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)jPanel2, GLanguage.translate("segments"));
        jTabbedPane.add((Component)jPanel3, GLanguage.translate("f(amplitude)"));
        uiCartesianLayout.add(jTabbedPane, 0, 3, 10, 6);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.applySeg.addActionListener(this.eventDispatcher);
        this.applyVar.addActionListener(this.eventDispatcher);
        this.effect.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.attack.refresh();
        this.release.refresh();
        this.x0.refresh();
        this.y0.refresh();
        this.x1.refresh();
        this.y1.refresh();
        this.x2.refresh();
        this.y2.refresh();
    }

    private void onEffectChange() {
        float f = this.getFocussedClip().getSampleRate();
        float f2 = (float)Math.pow(2.0, this.getFocussedClip().getSampleWidth() - 1);
        float f3 = this.getFocussedClip().getMaxSampleValue();
        int n = this.effect.getSelectedIndex();
        this.attack.setData(this.attackPresets[n] * f);
        this.release.setData(this.releasePresets[n] * f);
        this.x0.setData(this.x0Presets[n]);
        this.y0.setData(this.y0Presets[n]);
        this.x1.setData(this.x1Presets[n]);
        this.y1.setData(this.y1Presets[n]);
        this.x2.setData(this.x2Presets[n]);
        this.y2.setData(this.y2Presets[n]);
    }

    private void onApplySeg() {
        MMArray mMArray = new MMArray(3, 0.0f);
        mMArray.set(0, (float)this.x0.getData());
        mMArray.set(1, (float)this.x1.getData());
        mMArray.set(2, (float)this.x2.getData());
        MMArray mMArray2 = new MMArray(3, 0.0f);
        mMArray2.set(0, (float)this.y0.getData());
        mMArray2.set(1, (float)this.y1.getData());
        mMArray2.set(2, (float)this.y2.getData());
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        aLayerSelection.operateEachChannel(new AOCompressExpand((int)this.getFocussedClip().getSampleRate(), (int)this.attack.getData(), (int)this.release.getData(), mMArray, mMArray2));
    }

    private void onApplyVar() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createLayerSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AOCompressExpand((int)this.getFocussedClip().getSampleRate(), (int)this.attack.getData(), (int)this.release.getData(), null, null));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPCompressExpand.this.applySeg) {
                GProgressViewer.start(GPCompressExpand.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPCompressExpand.this.getName() + " [apply segments] clicked");
                GPCompressExpand.this.onApplySeg();
                GProgressViewer.setProgress(100);
                GPCompressExpand.this.updateHistory(GLanguage.translate(GPCompressExpand.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPCompressExpand.this.reloadFocussedClipEditor();
                GPCompressExpand.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPCompressExpand.this.applyVar) {
                GProgressViewer.start(GPCompressExpand.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPCompressExpand.this.getName() + " [apply var] clicked");
                GPCompressExpand.this.onApplyVar();
                GProgressViewer.setProgress(100);
                GPCompressExpand.this.updateHistory(GLanguage.translate(GPCompressExpand.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPCompressExpand.this.reloadFocussedClipEditor();
                GPCompressExpand.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPCompressExpand.this.effect) {
                Debug.println(1, "plugin " + GPCompressExpand.this.getName() + " [effect] clicked");
                GPCompressExpand.this.onEffectChange();
            }
        }
    }
}

