/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOChorusFlange;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextF;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GProgressViewer;
import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceDefaultImpl;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPChorusFlange
extends GPluginFrame {
    private JComboBox presets;
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText feedback;
    private JCheckBox negFeedback;
    private JComboBox shape;
    private UiControlText base;
    private UiControlText modulation;
    private UiControlText period;
    private JButton apply;
    private EventDispatcher eventDispatcher;
    private String[] presetsName;
    private float[] dryPresets;
    private float[] wetPresets;
    private float[] feedbackPresets;
    private boolean[] negFeedbackPresets;
    private int[] shapePresets;
    private float[] basePresets;
    private float[] modulationPresets;
    private float[] periodPresets;

    public GPChorusFlange(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "chorusFlange";
    }

    private void initGui() {
        PersistenceDefaultImpl persistenceDefaultImpl = new PersistenceDefaultImpl();
        try {
            ((Persistence)persistenceDefaultImpl).restore(this.getName() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ((Persistence)persistenceDefaultImpl).getInt("numberOfPresets");
        this.presetsName = new String[n];
        this.dryPresets = new float[n];
        this.wetPresets = new float[n];
        this.feedbackPresets = new float[n];
        this.negFeedbackPresets = new boolean[n];
        this.shapePresets = new int[n];
        this.basePresets = new float[n];
        this.modulationPresets = new float[n];
        this.periodPresets = new float[n];
        for (int i = 0; i < n; ++i) {
            this.presetsName[i] = GLanguage.translate(((Persistence)persistenceDefaultImpl).getString("name_" + i));
            this.dryPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("dry_" + i);
            this.wetPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("wet_" + i);
            this.feedbackPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("feedback_" + i);
            this.negFeedbackPresets[i] = ((Persistence)persistenceDefaultImpl).getBoolean("negFeedback_" + i);
            this.shapePresets[i] = ((Persistence)persistenceDefaultImpl).getInt("shape_" + i);
            this.basePresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("base_" + i);
            this.modulationPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("modulation_" + i);
            this.periodPresets[i] = ((Persistence)persistenceDefaultImpl).getFloat("period_" + i);
        }
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 10);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("presets")), 0, 0, 4, 1);
        this.presets = new JComboBox<String>(this.presetsName);
        uiCartesianLayout.add(this.presets, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 1, 4, 1);
        this.dry = new GControlTextA(7, true, true);
        this.dry.setDataRange(0.0, 1.0);
        this.dry.setData(0.0);
        uiCartesianLayout.add(this.dry, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 2, 4, 1);
        this.wet = new GControlTextA(7, true, true);
        this.wet.setDataRange(0.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("feedback")), 0, 3, 4, 1);
        this.feedback = new GControlTextA(7, true, true);
        this.feedback.setDataRange(0.0, 1.0);
        this.feedback.setData(0.5);
        uiCartesianLayout.add(this.feedback, 4, 3, 6, 1);
        this.negFeedback = new JCheckBox(GLanguage.translate("negativeFeedback"));
        uiCartesianLayout.add(this.negFeedback, 0, 4, 10, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shape")), 0, 5, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("sinus"), GLanguage.translate("triangle"), GLanguage.translate("saw")};
        this.shape = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.shape, 4, 5, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("baseDelay")), 0, 6, 4, 1);
        this.base = new GControlTextX(this.getMain(), 7, true, true);
        this.base.setDataRange(0.0, 1000000.0);
        this.base.setData(1000.0);
        this.base.setUnit("ms");
        uiCartesianLayout.add(this.base, 4, 6, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("modulatedDelay")), 0, 7, 4, 1);
        this.modulation = new GControlTextX(this.getMain(), 7, true, true);
        this.modulation.setDataRange(0.0, 1000000.0);
        this.modulation.setData(100.0);
        this.modulation.setUnit("ms");
        uiCartesianLayout.add(this.modulation, 4, 7, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("modulationPeriod")), 0, 8, 4, 1);
        this.period = new GControlTextF(this.getMain(), 7, true, true);
        this.period.setDataRange(0.0, 1000000.0);
        this.period.setData(1000.0);
        this.period.setUnit("ms");
        uiCartesianLayout.add(this.period, 4, 8, 6, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 9, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.presets.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.dry.refresh();
        this.wet.refresh();
        this.feedback.refresh();
        this.base.refresh();
        this.modulation.refresh();
        this.period.refresh();
    }

    private void onPresetChange() {
        float f = this.getFocussedClip().getSampleRate();
        int n = this.presets.getSelectedIndex();
        this.dry.setData(this.dryPresets[n]);
        this.wet.setData(this.wetPresets[n]);
        this.feedback.setData(this.feedbackPresets[n]);
        this.negFeedback.setSelected(this.negFeedbackPresets[n]);
        this.shape.setSelectedIndex(this.shapePresets[n]);
        this.base.setData(f * this.basePresets[n]);
        this.modulation.setData(f * this.modulationPresets[n]);
        this.period.setData(f / this.periodPresets[n]);
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getLayerSelection();
        int n = 0;
        switch (this.shape.getSelectedIndex()) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
            }
        }
        aLayerSelection.operateEachChannel(new AOChorusFlange((float)this.dry.getData(), (float)this.wet.getData(), (float)this.feedback.getData(), this.negFeedback.isSelected(), (int)this.base.getData(), (int)this.modulation.getData(), (int)this.period.getData(), n));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPChorusFlange.this.apply) {
                GProgressViewer.start(GPChorusFlange.this.getName());
                GProgressViewer.entrySubProgress();
                GProgressViewer.setProgress(70);
                Debug.println(1, "plugin " + GPChorusFlange.this.getName() + " [apply] clicked");
                GPChorusFlange.this.onApply();
                GProgressViewer.setProgress(100);
                GPChorusFlange.this.updateHistory(GLanguage.translate(GPChorusFlange.this.getName()));
                GProgressViewer.exitSubProgress();
                GProgressViewer.finish();
                GPChorusFlange.this.reloadFocussedClipEditor();
                GPChorusFlange.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPChorusFlange.this.presets) {
                GPChorusFlange.this.onPresetChange();
            }
        }
    }
}

