/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOFifo;
import ch.laoe.operation.AOSpline;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class AOToolkit {
    private static final double halfToneFactor = 1.0 / Math.log(Math.pow(2.0, 0.08333333333333333));
    private static final double octaveFactor = 1.0 / Math.log(2.0);
    public static int zeroCrossWidth = 30;

    public static float todB(float f) {
        return (float)Math.max(8.68589 * Math.log(Math.abs(f)), -200.0);
    }

    public static float fromdB(float f) {
        return (float)Math.exp((double)f / 8.68589);
    }

    public static float toHalfTone(float f) {
        return (float)(halfToneFactor * Math.log(Math.abs(f)));
    }

    public static float fromHalfTone(float f) {
        return (float)Math.exp((double)f / halfToneFactor);
    }

    public static float toOctave(float f) {
        return (float)(octaveFactor * Math.log(Math.abs(f)));
    }

    public static float fromOctave(float f) {
        return (float)Math.exp((double)f / octaveFactor);
    }

    public static float interpolate0(MMArray mMArray, float f) {
        return mMArray.get((int)f % mMArray.getLength());
    }

    public static float interpolate1(MMArray mMArray, float f) {
        int n = (int)f;
        float f2 = f - (float)n;
        int n2 = mMArray.getLength();
        return mMArray.get(n % n2) * (1.0f - f2) + mMArray.get((n + 1) % n2) * f2;
    }

    public static float interpolate2(MMArray mMArray, float f) {
        int n = (int)f;
        float f2 = f - (float)n;
        int n2 = mMArray.getLength();
        float f3 = mMArray.get(n % n2);
        float f4 = mMArray.get((n + 1) % n2);
        float f5 = mMArray.get((n + 2) % n2);
        float f6 = f3;
        float f7 = f4 - f3;
        float f8 = (f5 - f4 - f7) / 2.0f;
        return f6 + f7 * f2 + f8 * f2 * (f2 - 1.0f);
    }

    public static float interpolate3(MMArray mMArray, float f) {
        int n = (int)f;
        float f2 = f - (float)n;
        int n2 = mMArray.getLength();
        float f3 = mMArray.get((n - 1) % n2);
        float f4 = mMArray.get(n % n2);
        float f5 = mMArray.get((n + 1) % n2);
        float f6 = mMArray.get((n + 2) % n2);
        float f7 = (3.0f * (f4 - f5) - f3 + f6) / 2.0f;
        float f8 = 2.0f * f5 + f3 - (5.0f * f4 + f6) / 2.0f;
        float f9 = (f5 - f3) / 2.0f;
        return ((f7 * f2 + f8) * f2 + f9) * f2 + mMArray.get(n % n2);
    }

    public static float interpolate0(MMArray mMArray, MMArray mMArray2, float f) {
        if (f < mMArray.get(0)) {
            return mMArray2.get(0);
        }
        for (int i = 1; i < mMArray.getLength(); ++i) {
            if (!(mMArray.get(i) > f)) continue;
            return mMArray2.get(i - 1);
        }
        return mMArray2.get(mMArray2.getLength() - 1);
    }

    public static float interpolate1(MMArray mMArray, MMArray mMArray2, float f) {
        if (f < mMArray.get(0)) {
            return mMArray2.get(0);
        }
        for (int i = 1; i < mMArray.getLength(); ++i) {
            if (!(mMArray.get(i) > f)) continue;
            float f2 = mMArray.get(i) - mMArray.get(i - 1);
            float f3 = mMArray2.get(i) - mMArray2.get(i - 1);
            return mMArray2.get(i - 1) + (f - mMArray.get(i - 1)) / f2 * f3;
        }
        return mMArray2.get(mMArray2.getLength() - 1);
    }

    public static float interpolate2(MMArray mMArray, MMArray mMArray2, float f) {
        int n = 0;
        for (n = mMArray.getLength() - 1; n >= 0 && !(mMArray.get(n) < f); --n) {
        }
        if (n > mMArray.getLength() - 3) {
            n = mMArray.getLength() - 3;
        }
        if (n < 0) {
            n = 0;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        f10 = mMArray.get(n);
        f9 = mMArray.get(n + 1);
        f8 = mMArray.get(n + 2);
        f7 = mMArray2.get(n);
        f6 = mMArray2.get(n + 1);
        f5 = mMArray2.get(n + 2);
        f4 = (f6 - f7) / (f9 - f10);
        f3 = (f5 - f6) / (f8 - f9);
        f2 = (f3 - f4) / (f8 - f10);
        return f7 + f4 * (f - f10) + f2 * (f - f10) * (f - f9);
    }

    public static float interpolate3(MMArray mMArray, MMArray mMArray2, float f) {
        int n = 0;
        for (n = mMArray.getLength() - 1; n >= 0 && !(mMArray.get(n) < f); --n) {
        }
        if (--n > mMArray.getLength() - 4) {
            n = mMArray.getLength() - 4;
        }
        if (n < 0) {
            n = 0;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        f15 = mMArray.get(n);
        f14 = mMArray.get(n + 1);
        f13 = mMArray.get(n + 2);
        f12 = mMArray.get(n + 3);
        f11 = mMArray2.get(n);
        f10 = mMArray2.get(n + 1);
        f9 = mMArray2.get(n + 2);
        f8 = mMArray2.get(n + 3);
        f7 = (f10 - f11) / (f14 - f15);
        f6 = (f9 - f10) / (f13 - f14);
        f5 = (f8 - f9) / (f12 - f13);
        f4 = (f6 - f7) / (f13 - f15);
        f3 = (f5 - f6) / (f12 - f14);
        f2 = (f3 - f4) / (f12 - f15);
        return f11 + f7 * (f - f15) + f4 * (f - f15) * (f - f14) + f2 * (f - f15) * (f - f14) * (f - f13);
    }

    public static AOSpline createSpline() {
        return new AOSpline();
    }

    public static float convolve(MMArray mMArray, int n, MMArray mMArray2, int n2) {
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f += mMArray.get(n - i) * mMArray2.get(i);
        }
        return f;
    }

    public static void setLowPassKernel(MMArray mMArray, int n, float f) {
        int n2;
        int n3 = n / 2;
        float f2 = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == n3) {
                mMArray.set(n2, (float)Math.PI * 2 * f);
            } else {
                mMArray.set(n2, (float)Math.sin((float)Math.PI * 2 * f * (float)(n2 - n3)) / (float)(n2 - n3));
            }
            mMArray.set(n2, (float)((double)mMArray.get(n2) * (0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)n2 / (double)n) + 0.08 * Math.cos(Math.PI * 4 * (double)n2 / (double)n))));
            f2 += mMArray.get(n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            mMArray.set(n2, mMArray.get(n2) / f2);
        }
    }

    public static void setHighPassKernel(MMArray mMArray, int n, float f) {
        int n2;
        int n3 = n / 2;
        float f2 = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == n3) continue;
            mMArray.set(n2, (float)Math.sin((float)Math.PI * 2 * f * (float)(n2 - n3)) / (float)(n2 - n3));
            mMArray.set(n2, (float)((double)mMArray.get(n2) * (0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)n2 / (double)n) + 0.08 * Math.cos(Math.PI * 4 * (double)n2 / (double)n))));
            f2 += mMArray.get(n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            mMArray.set(n2, mMArray.get(n2) / -f2);
        }
        mMArray.set(n3, 1.0f);
    }

    public static void addIirBandPass(MMArray mMArray, MMArray mMArray2, int n, int n2, float f, float f2, float f3) {
        float f4 = (float)(Math.PI * 2 * (double)f);
        float f5 = (float)(0.5 * (1.0 - Math.tan((double)f4 / (2.0 * (double)f2))) / (1.0 + Math.tan((double)f4 / (2.0 * (double)f2))));
        float f6 = (float)((0.5 - (double)f5) / 2.0);
        float f7 = (float)((0.5 + (double)f5) * Math.cos(f4));
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        for (int i = n; i < n + n2; ++i) {
            f8 = f9;
            f9 = f10;
            f10 = mMArray.get(i);
            f11 = f12;
            f12 = f13;
            f13 = 2.0f * (f6 * (f10 - f8) + f7 * f12 - f5 * f11);
            mMArray2.set(i - n, mMArray2.get(i - n) + f3 * f13);
        }
    }

    public static void setIirHighPass(MMArray mMArray, int n, int n2, float f, float f2, float f3) {
        float f4 = (float)(Math.PI * 2 * (double)f3);
        float f5 = (float)Math.cos(f4);
        float f6 = (float)(Math.sin(f4) / 2.0);
        float f7 = 1.0f + f6;
        float f8 = (1.0f + f5) / 2.0f / f7;
        float f9 = -(1.0f + f5) / f7;
        float f10 = f8;
        float f11 = -2.0f * f5 / f7;
        float f12 = (1.0f - f6) / f7;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        for (int i = n; i < n + n2; ++i) {
            f13 = f14;
            f14 = f15;
            f15 = mMArray.get(i);
            f16 = f17;
            f17 = f18;
            f18 = f8 * f15 + f9 * f14 + f10 * f13 - f11 * f17 - f12 * f16;
            mMArray.set(i, mMArray.get(i) * f + f18 * f2);
        }
    }

    public static void setIirLowPass(MMArray mMArray, int n, int n2, float f, float f2, float f3) {
        float f4 = (float)(Math.PI * 2 * (double)f3);
        float f5 = (float)Math.cos(f4);
        float f6 = (float)(Math.sin(f4) / 2.0);
        float f7 = 1.0f + f6;
        float f8 = (1.0f - f5) / 2.0f / f7;
        float f9 = (1.0f - f5) / f7;
        float f10 = f8;
        float f11 = -2.0f * f5 / f7;
        float f12 = (1.0f - f6) / f7;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        for (int i = n; i < n + n2; ++i) {
            f13 = f14;
            f14 = f15;
            f15 = mMArray.get(i);
            f16 = f17;
            f17 = f18;
            f18 = f8 * f15 + f9 * f14 + f10 * f13 - f11 * f17 - f12 * f16;
            mMArray.set(i, mMArray.get(i) * f + f18 * f2);
        }
    }

    public static void setIirNotch(MMArray mMArray, int n, int n2, float f, float f2, float f3) {
        float f4 = (float)(Math.PI * 2 * (double)f);
        float f5 = (float)Math.cos(f4);
        float f6 = (float)(Math.sin(f4) / (double)(2.0f * f2));
        float f7 = 1.0f + f6;
        float f8 = 1.0f / f7;
        float f9 = -2.0f * f5 / f7;
        float f10 = f8;
        float f11 = -2.0f * f5 / f7;
        float f12 = (1.0f - f6) / f7;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        for (int i = n; i < n + n2; ++i) {
            f13 = f14;
            f14 = f15;
            f15 = mMArray.get(i);
            f16 = f17;
            f17 = f18;
            f18 = f8 * f15 + f9 * f14 + f10 * f13 - f11 * f17 - f12 * f16;
            mMArray.set(i, f18 * f3);
        }
    }

    public static void complexFft(MMArray mMArray, MMArray mMArray2) {
        AOToolkit.baseFft(false, mMArray, mMArray2);
    }

    public static void complexIfft(MMArray mMArray, MMArray mMArray2) {
        AOToolkit.baseFft(true, mMArray, mMArray2);
    }

    private static void baseFft(boolean bl, MMArray mMArray, MMArray mMArray2) {
        int n;
        int n2;
        int n3 = mMArray.getLength();
        float f = (float)Math.sqrt(1.0f / (float)n3);
        int n4 = bl ? -1 : 1;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n5 >= n2) {
                float f2 = mMArray.get(n5) * f;
                float f3 = mMArray2.get(n5) * f;
                mMArray.set(n5, mMArray.get(n2) * f);
                mMArray2.set(n5, mMArray2.get(n2) * f);
                mMArray.set(n2, f2);
                mMArray2.set(n2, f3);
            }
            for (n = n3 / 2; n >= 1 && n5 >= n; n5 -= n, n /= 2) {
            }
            n5 += n;
        }
        n = 1;
        int n6 = 2 * n;
        while (n < n3) {
            float f4 = (float)n4 * (float)Math.PI / (float)n;
            for (int i = 0; i < n; ++i) {
                float f5 = (float)i * f4;
                float f6 = (float)Math.cos(f5);
                float f7 = (float)Math.sin(f5);
                for (n2 = i; n2 < n3; n2 += n6) {
                    n5 = n2 + n;
                    float f8 = f6 * mMArray.get(n5) - f7 * mMArray2.get(n5);
                    float f9 = f6 * mMArray2.get(n5) + f7 * mMArray.get(n5);
                    mMArray.set(n5, mMArray.get(n2) - f8);
                    mMArray2.set(n5, mMArray2.get(n2) - f9);
                    mMArray.set(n2, mMArray.get(n2) + f8);
                    mMArray2.set(n2, mMArray2.get(n2) + f9);
                }
            }
            n = n6;
            n = n6;
            n6 = 2 * n;
        }
        if (!bl) {
            int n7;
            for (n7 = 0; n7 < n3; ++n7) {
                mMArray.set(n7, mMArray.get(n7) * 2.0f);
                mMArray2.set(n7, mMArray2.get(n7) * 2.0f);
            }
            for (n7 = n3 / 2; n7 < n3; ++n7) {
                mMArray.set(n7, 0.0f);
                mMArray2.set(n7, 0.0f);
            }
        }
    }

    public static void powerFft(MMArray mMArray, MMArray mMArray2) {
        throw new NotImplementedException();
    }

    public static void applyRectangularWindow(MMArray mMArray, int n) {
        for (int i = 0; i < mMArray.getLength(); ++i) {
            if (i < n) continue;
            mMArray.set(i, 0.0f);
        }
    }

    public static void applyHammingWindow(MMArray mMArray, int n) {
        for (int i = 0; i < mMArray.getLength(); ++i) {
            if (i < n) {
                mMArray.set(i, mMArray.get(i) * (float)(0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)n)));
                continue;
            }
            mMArray.set(i, 0.0f);
        }
    }

    public static void applyBlackmanWindow(MMArray mMArray, int n) {
        for (int i = 0; i < mMArray.getLength(); ++i) {
            if (i < n) {
                double d = Math.PI * 2 * (double)i / (double)n;
                mMArray.set(i, mMArray.get(i) * (float)(0.42 - 0.5 * Math.cos(d) + 0.08 * Math.cos(2.0 * d)));
                continue;
            }
            mMArray.set(i, 0.0f);
        }
    }

    public static void applyFlattopWindow(MMArray mMArray, int n) {
        throw new NotImplementedException();
    }

    public void autoCorrelation(MMArray mMArray, MMArray mMArray2) {
        throw new NotImplementedException();
    }

    public static float average(MMArray mMArray, int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f += mMArray.get(n + i);
        }
        return f /= (float)n2;
    }

    public static float rmsAverage(MMArray mMArray, int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f += mMArray.get(n + i) * mMArray.get(n + i);
        }
        f = (float)Math.sqrt(f / (float)n2);
        return f;
    }

    public static float movingAverage(float f, float f2, float f3) {
        return (f * f3 + f2) / (f3 + 1.0f);
    }

    public static float movingRmsAverage(float f, float f2, float f3) {
        return (float)Math.sqrt((f * f * f3 + f2 * f2) / (f3 + 1.0f));
    }

    public static void smooth(MMArray mMArray, int n, int n2, float f) {
        int n3;
        float f2 = mMArray.get(n);
        for (n3 = n; n3 < n + n2; ++n3) {
            f2 = AOToolkit.movingAverage(f2, mMArray.get(n3), f);
            mMArray.set(n3, f2);
        }
        f2 = mMArray.get(n + n2 - 1);
        for (n3 = n + n2 - 1; n3 >= n; --n3) {
            f2 = AOToolkit.movingAverage(f2, mMArray.get(n3), f);
            mMArray.set(n3, f2);
        }
    }

    public static void smoothRms(MMArray mMArray, int n, int n2, float f) {
        int n3;
        float f2 = mMArray.get(n);
        for (n3 = n; n3 < n + n2; ++n3) {
            f2 = AOToolkit.movingRmsAverage(f2, mMArray.get(n3), f);
            mMArray.set(n3, f2);
        }
        f2 = mMArray.get(n + n2 - 1);
        for (n3 = n + n2 - 1; n3 >= n; --n3) {
            f2 = AOToolkit.movingRmsAverage(f2, mMArray.get(n3), f);
            mMArray.set(n3, f2);
        }
    }

    public static int getPositivePeakIndex(MMArray mMArray, int n, int n2) {
        float f = Float.MIN_VALUE;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(mMArray.get(n + i) > f)) continue;
            f = mMArray.get(n + i);
            n3 = n + i;
        }
        return n3;
    }

    public static int getNegativePeakIndex(MMArray mMArray, int n, int n2) {
        float f = Float.MAX_VALUE;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(mMArray.get(n + i) < f)) continue;
            f = mMArray.get(n + i);
            n3 = n + i;
        }
        return n3;
    }

    public static int getNearestPositivePeakIndex(MMArray mMArray, int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= mMArray.getLength()) {
            n = mMArray.getLength() - 1;
        }
        float f = Float.MIN_VALUE;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i;
            if (n4 < mMArray.getLength() && mMArray.get(n4) > f) {
                f = mMArray.get(n4);
                n3 = n4;
            }
            if ((n4 = n - i) < 0 || !(mMArray.get(n4) > f)) continue;
            f = mMArray.get(n4);
            n3 = n4;
        }
        if (mMArray.get(n3 + 1) <= mMArray.get(n3) && mMArray.get(n3 - 1) <= mMArray.get(n3)) {
            return n3;
        }
        return n;
    }

    public static int getNearestNegativePeakIndex(MMArray mMArray, int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= mMArray.getLength()) {
            n = mMArray.getLength() - 1;
        }
        float f = Float.MAX_VALUE;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i;
            if (n4 < mMArray.getLength() && mMArray.get(n4) < f) {
                f = mMArray.get(n4);
                n3 = n4;
            }
            if ((n4 = n - i) < 0 || !(mMArray.get(n4) < f)) continue;
            f = mMArray.get(n4);
            n3 = n4;
        }
        if (mMArray.get(n3 + 1) >= mMArray.get(n3) && mMArray.get(n3 - 1) >= mMArray.get(n3)) {
            return n3;
        }
        return n;
    }

    public static int getNearestZeroCrossIndex(MMArray mMArray, int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= mMArray.getLength()) {
            n = mMArray.getLength() - 1;
        }
        boolean bl = mMArray.get(n) > 0.0f;
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            if (n3 < mMArray.getLength() && bl != mMArray.get(n3) > 0.0f) {
                return n3;
            }
            n3 = n - i;
            if (n3 < 0 || bl == mMArray.get(n3) > 0.0f) continue;
            return n3;
        }
        return -1;
    }

    public static int getNumberOfNoiseSamples(MMArray mMArray, int n, int n2, float f) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(Math.abs(mMArray.get(n + i)) > f)) continue;
            ++n3;
        }
        return n3;
    }

    public static int getNumberOfSilenceSamples(MMArray mMArray, int n, int n2, float f) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(Math.abs(mMArray.get(n + i)) <= f)) continue;
            ++n3;
        }
        return n3;
    }

    public static int getNextUpperNoiseIndex(MMArray mMArray, int n, int n2, float f, int n3) {
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            n4 = Math.abs(mMArray.get(n + i)) > f ? ++n4 : 0;
            if (n4 < n3) continue;
            return n + i - n4;
        }
        return -1;
    }

    public static int getNextLowerNoiseIndex(MMArray mMArray, int n, int n2, float f, int n3) {
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            n4 = Math.abs(mMArray.get(n - i)) > f ? ++n4 : 0;
            if (n4 < n3) continue;
            return n - i + n4;
        }
        return -1;
    }

    public static int getNextUpperSilenceIndex(MMArray mMArray, int n, int n2, float f, int n3) {
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            n4 = Math.abs(mMArray.get(n + i)) <= f ? ++n4 : 0;
            if (n4 < n3) continue;
            return n + i - n4;
        }
        return -1;
    }

    public static int getNextLowerSilenceIndex(MMArray mMArray, int n, int n2, float f, int n3) {
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            n4 = Math.abs(mMArray.get(n - i)) <= f ? ++n4 : 0;
            if (n4 < n3) continue;
            return n - i + n4;
        }
        return -1;
    }

    public static AChannelSelection expandSilence(AChannelSelection aChannelSelection, float f, int n) {
        int n2 = aChannelSelection.getOffset();
        int n3 = n2 + aChannelSelection.getLength();
        AChannel aChannel = aChannelSelection.getChannel();
        n2 = AOToolkit.getNextLowerNoiseIndex(aChannel.getSamples(), n2, n2, f, n);
        n3 = AOToolkit.getNextUpperNoiseIndex(aChannel.getSamples(), n3, aChannel.getSamples().getLength() - n3, f, n);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = aChannel.getSamples().getLength() - 1;
        }
        if (n2 < n3) {
            return new AChannelSelection(aChannel, n2, n3 - n2);
        }
        return new AChannelSelection(aChannel, 0, 0);
    }

    public static AChannelSelection expandNoise(AChannelSelection aChannelSelection, float f, int n) {
        int n2 = aChannelSelection.getOffset();
        int n3 = n2 + aChannelSelection.getLength();
        AChannel aChannel = aChannelSelection.getChannel();
        n2 = AOToolkit.getNextLowerSilenceIndex(aChannel.getSamples(), n2, n2, f, n);
        n3 = AOToolkit.getNextUpperSilenceIndex(aChannel.getSamples(), n3, aChannel.getSamples().getLength() - n3, f, n);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = aChannel.getSamples().getLength() - 1;
        }
        if (n2 < n3) {
            return new AChannelSelection(aChannel, n2, n3 - n2);
        }
        return new AChannelSelection(aChannel, 0, 0);
    }

    public static AChannelSelection reduceSilence(AChannelSelection aChannelSelection, float f, int n) {
        int n2 = aChannelSelection.getOffset();
        int n3 = n2 + aChannelSelection.getLength();
        AChannel aChannel = aChannelSelection.getChannel();
        n2 = AOToolkit.getNextUpperSilenceIndex(aChannel.getSamples(), n2, aChannel.getSamples().getLength() - n2, f, n);
        n3 = AOToolkit.getNextLowerSilenceIndex(aChannel.getSamples(), n3, n3, f, n);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = aChannel.getSamples().getLength() - 1;
        }
        if (n2 < n3) {
            return new AChannelSelection(aChannel, n2, n3 - n2);
        }
        return new AChannelSelection(aChannel, 0, 0);
    }

    public static AChannelSelection reduceNoise(AChannelSelection aChannelSelection, float f, int n) {
        int n2 = aChannelSelection.getOffset();
        int n3 = n2 + aChannelSelection.getLength();
        AChannel aChannel = aChannelSelection.getChannel();
        n2 = AOToolkit.getNextUpperNoiseIndex(aChannel.getSamples(), n2, aChannel.getSamples().getLength() - n2, f, n);
        n3 = AOToolkit.getNextLowerNoiseIndex(aChannel.getSamples(), n3, n3, f, n);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = aChannel.getSamples().getLength() - 1;
        }
        if (n2 < n3) {
            return new AChannelSelection(aChannel, n2, n3 - n2);
        }
        return new AChannelSelection(aChannel, 0, 0);
    }

    public static float cartesianToMagnitude(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static float cartesianToPhase(float f, float f2) {
        return (float)Math.atan2(f2, f);
    }

    public static float polarToX(float f, float f2) {
        return (float)((double)f * Math.cos(f2));
    }

    public static float polarToY(float f, float f2) {
        return (float)((double)f * Math.sin(f2));
    }

    public static void applyZeroCross(MMArray mMArray, int n, int n2) {
        try {
            AOToolkit.smooth(mMArray, n - n2 / 2, n2, 1.5f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setZeroCrossWidth(int n) {
        zeroCrossWidth = n;
    }

    public static int getZeroCrossWidth() {
        return zeroCrossWidth;
    }

    public static void applyZeroCross(MMArray mMArray, int n) {
        AOToolkit.applyZeroCross(mMArray, n, zeroCrossWidth);
    }

    public static AOFifo createFifo(int n) {
        return new AOFifo(n);
    }

    public static void add(MMArray mMArray, int n, int n2, float f) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) + f);
        }
    }

    public static void add(MMArray mMArray, MMArray mMArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) + mMArray2.get(n + i));
        }
    }

    public static void subtract(MMArray mMArray, int n, int n2, float f) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) - f);
        }
    }

    public static void subtract(MMArray mMArray, MMArray mMArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) - mMArray2.get(n + i));
        }
    }

    public static void multiply(MMArray mMArray, int n, int n2, float f) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) * f);
        }
    }

    public static void multiply(MMArray mMArray, MMArray mMArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) * mMArray2.get(n + i));
        }
    }

    public static void divide(MMArray mMArray, int n, int n2, float f) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, mMArray.get(n + i) / f);
        }
    }

    public static void divide(MMArray mMArray, MMArray mMArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (mMArray2.get(n + i) == 0.0f) continue;
            mMArray.set(n + i, mMArray.get(n + i) / mMArray2.get(n + i));
        }
    }

    public static void derivate(MMArray mMArray, int n, int n2) {
        float f = mMArray.get(n);
        float f2 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f2 = mMArray.get(n + i) - f;
            f = mMArray.get(n + i);
            mMArray.set(n + i, f2);
        }
    }

    public static void integrate(MMArray mMArray, int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, f += mMArray.get(n + i));
        }
    }

    public static void invers(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (mMArray.get(n + i) == 0.0f) continue;
            mMArray.set(n + i, 1.0f / mMArray.get(n + i));
        }
    }

    public static void neg(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, -mMArray.get(n + i));
        }
    }

    public static void pow(MMArray mMArray, int n, int n2, float f) {
        for (int i = 0; i < n2; ++i) {
            float f2 = mMArray.get(n + i);
            if (f2 >= 0.0f) {
                mMArray.set(n + i, (float)Math.pow(mMArray.get(n + i), f));
                continue;
            }
            mMArray.set(n + i, -((float)Math.pow(-mMArray.get(n + i), f)));
        }
    }

    public static void sqrt(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, (float)Math.sqrt(mMArray.get(n + i)));
        }
    }

    public static void exp(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, (float)Math.exp(mMArray.get(n + i)));
        }
    }

    public static void log(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, (float)Math.log(mMArray.get(n + i)));
        }
    }

    public static void todB(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, AOToolkit.todB(mMArray.get(n + i)));
        }
    }

    public static void fromdB(MMArray mMArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            mMArray.set(n + i, AOToolkit.fromdB(mMArray.get(n + i)));
        }
    }

    public static float max(MMArray mMArray, int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            if (!(Math.abs(mMArray.get(n + i)) > f)) continue;
            f = Math.abs(mMArray.get(n + i));
        }
        return f;
    }
}

