/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.GProgressViewer;

public class AOSweepResample
extends AOperation {
    private float beginFactor;
    private float endFactor;
    private int order;

    public AOSweepResample(float f, float f2, int n) {
        this.beginFactor = f;
        this.endFactor = f2;
        this.order = n;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        double d;
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d = (double)i / (double)n2;
            d2 += (double)(1.0f / this.beginFactor) * (1.0 - d) + (double)(1.0f / this.endFactor) * d;
        }
        MMArray mMArray2 = new MMArray(mMArray.getLength() - n2 + (int)d2, 0.0f);
        mMArray2.copy(mMArray, 0, 0, n);
        d = n;
        int n3 = n + (int)d2;
        GProgressViewer.entrySubProgress();
        for (int i = n; i < n3; ++i) {
            GProgressViewer.setProgress((i + 1 - n) * 100 / (n3 - n));
            if ((int)d + 1 >= mMArray.getLength()) break;
            switch (this.order) {
                case 0: {
                    mMArray2.set(i, AOToolkit.interpolate0(mMArray, (float)d));
                    break;
                }
                case 1: {
                    mMArray2.set(i, AOToolkit.interpolate1(mMArray, (float)d));
                    break;
                }
                case 2: {
                    mMArray2.set(i, AOToolkit.interpolate2(mMArray, (float)d));
                    break;
                }
                case 3: {
                    mMArray2.set(i, AOToolkit.interpolate3(mMArray, (float)d));
                }
            }
            double d3 = (double)(i - n) / d2;
            d += 1.0 / ((double)(1.0f / this.beginFactor) * (1.0 - d3) + (double)(1.0f / this.endFactor) * d3);
        }
        GProgressViewer.exitSubProgress();
        mMArray2.copy(mMArray, n + n2, n + (int)d2, mMArray2.getLength() - n - (int)d2);
        aChannelSelection.getChannel().setSamples(mMArray2);
    }
}

