/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GProgressViewer;

public class AOSpectrum
extends AOperation {
    private int windowType;
    public static final int RECTANGULAR_WINDOW = 1;
    public static final int HAMMING_WINDOW = 2;
    public static final int BLACKMAN_WINDOW = 3;
    public static final int FLATTOP_WINDOW = 4;
    private static final int convertBufferLength = 16384;
    private MMArray re;
    private MMArray im;
    private MMArray spectrum;

    public AOSpectrum(int n) {
        this.windowType = n;
        this.re = new MMArray(16384, 0.0f);
        this.im = new MMArray(16384, 0.0f);
        this.spectrum = new MMArray(8192, 0.0f);
    }

    public MMArray getSpectrum() {
        return this.spectrum;
    }

    public static int getSpectrumLength() {
        return 8192;
    }

    private void operateTWindow() {
        switch (this.windowType) {
            case 1: {
                AOToolkit.applyRectangularWindow(this.re, this.re.getLength());
                break;
            }
            case 2: {
                AOToolkit.applyHammingWindow(this.re, this.re.getLength());
                break;
            }
            case 3: {
                AOToolkit.applyBlackmanWindow(this.re, this.re.getLength());
                break;
            }
            case 4: {
                AOToolkit.applyFlattopWindow(this.re, this.re.getLength());
            }
        }
    }

    private void addToSpectrum() {
        for (int i = 0; i < this.spectrum.getLength(); ++i) {
            this.spectrum.set(i, this.spectrum.get(i) + AOToolkit.cartesianToMagnitude(this.re.get(i), this.im.get(i)));
        }
    }

    private void reduceSpectrum(int n) {
        for (int i = 0; i < this.spectrum.getLength(); ++i) {
            this.spectrum.set(i, this.spectrum.get(i) / (float)n);
        }
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        try {
            int n3 = n2 / 16384 + 1;
            GProgressViewer.entrySubProgress();
            for (int i = 0; i < n3; ++i) {
                GProgressViewer.setProgress((i + 1) * 100 / n3);
                for (int j = 0; j < 16384; ++j) {
                    int n4 = n + i * 16384 + j;
                    if (n4 < n + n2) {
                        this.re.set(j, mMArray.get(n4));
                    } else {
                        this.re.set(j, 0.0f);
                    }
                    this.im.set(j, 0.0f);
                }
                this.operateTWindow();
                AOToolkit.complexFft(this.re, this.im);
                this.addToSpectrum();
            }
            this.reduceSpectrum(n3);
            GProgressViewer.exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

