/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOSpline;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOSegmentGenerator
extends AOperation {
    public static final int SINGLE_POINTS = -1;
    public static final int ORDER_0 = 0;
    public static final int ORDER_1 = 1;
    public static final int ORDER_2 = 2;
    public static final int ORDER_3 = 3;
    public static final int SPLINE = 4;
    private int order;
    public static final int REPLACE_OPERATION = 0;
    public static final int ENVELOPE_OPERATION = 1;
    private int operation;
    private MMArray x;
    private MMArray y;
    private boolean selectionIndependent;

    public AOSegmentGenerator(MMArray mMArray, MMArray mMArray2, int n, int n2, boolean bl) {
        this.x = mMArray;
        this.y = mMArray2;
        this.order = n;
        this.operation = n2;
        this.selectionIndependent = bl;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        block28: {
            int n;
            int n2;
            int n3;
            MMArray mMArray = aChannelSelection.getChannel().getSamples();
            if (this.selectionIndependent) {
                n3 = (int)this.x.get(0);
                n2 = (int)this.x.get(this.x.getLength() - 1);
            } else {
                n3 = aChannelSelection.getOffset();
                n2 = aChannelSelection.getLength() + aChannelSelection.getOffset();
            }
            MMArray mMArray2 = new MMArray(n2 - n3, 0.0f);
            aChannelSelection.getChannel().markChange();
            switch (this.order) {
                case -1: {
                    for (int i = 0; i < this.x.getLength(); ++i) {
                        if (!aChannelSelection.getChannel().getSamples().isInRange((int)this.x.get(i))) continue;
                        if (this.selectionIndependent) {
                            mMArray.set((int)this.x.get(i), this.y.get(i));
                            continue;
                        }
                        n = (int)this.x.get(i);
                        if (!aChannelSelection.isSelected(n)) continue;
                        mMArray.set(n, aChannelSelection.mixIntensity(n, mMArray.get(n), this.y.get(i)));
                    }
                    break;
                }
                case 0: {
                    for (int i = n3; i < n2; ++i) {
                        if (!aChannelSelection.getChannel().getSamples().isInRange(i)) continue;
                        mMArray2.set(i - n3, AOToolkit.interpolate0(this.x, this.y, i));
                    }
                    break;
                }
                case 1: {
                    for (int i = n3; i < n2; ++i) {
                        if (!aChannelSelection.getChannel().getSamples().isInRange(i)) continue;
                        mMArray2.set(i - n3, AOToolkit.interpolate1(this.x, this.y, i));
                    }
                    break;
                }
                case 2: {
                    for (int i = n3; i < n2; ++i) {
                        if (!aChannelSelection.getChannel().getSamples().isInRange(i)) continue;
                        mMArray2.set(i - n3, AOToolkit.interpolate2(this.x, this.y, i));
                    }
                    break;
                }
                case 3: {
                    for (int i = n3; i < n2; ++i) {
                        if (!aChannelSelection.getChannel().getSamples().isInRange(i)) continue;
                        mMArray2.set(i - n3, AOToolkit.interpolate3(this.x, this.y, i));
                    }
                    break;
                }
                case 4: {
                    AOSpline aOSpline = AOToolkit.createSpline();
                    aOSpline.load(this.x, this.y);
                    for (n = n3; n < n2; ++n) {
                        if (!aChannelSelection.getChannel().getSamples().isInRange(n)) continue;
                        mMArray2.set(n - n3, aOSpline.getResult(n));
                    }
                    break;
                }
            }
            switch (this.order) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    switch (this.operation) {
                        case 0: {
                            for (int i = 0; i < mMArray2.getLength(); ++i) {
                                if (!aChannelSelection.getChannel().getSamples().isInRange(i + n3)) continue;
                                if (this.selectionIndependent) {
                                    mMArray.set(i + n3, mMArray2.get(i));
                                    continue;
                                }
                                n = i + n3;
                                mMArray.set(n, aChannelSelection.mixIntensity(n, mMArray.get(n), mMArray2.get(i)));
                            }
                            break block28;
                        }
                        case 1: {
                            float f = AOToolkit.max(mMArray, n3, n2 - n3);
                            for (n = 0; n < mMArray2.getLength(); ++n) {
                                if (!aChannelSelection.getChannel().getSamples().isInRange(n + n3)) continue;
                                if (this.selectionIndependent) {
                                    mMArray.set(n + n3, mMArray.get(n + n3) * mMArray2.get(n) / f);
                                    continue;
                                }
                                int n4 = n + n3;
                                float f2 = mMArray.get(n4) * mMArray2.get(n) / f;
                                mMArray.set(n4, aChannelSelection.mixIntensity(n4, mMArray.get(n4), f2));
                            }
                        }
                    }
                }
            }
        }
    }
}

