/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOFifo;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOReverbAllPass
extends AOperation {
    private int delay;
    private float gain;
    private float dry;
    private float wet;
    private boolean backward;

    public AOReverbAllPass(int n, float f, float f2, float f3, boolean bl) {
        this.delay = n;
        this.gain = f;
        this.dry = f2;
        this.wet = f3;
        this.backward = bl;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        float f = AOToolkit.rmsAverage(mMArray, n, n2);
        aChannelSelection.getChannel().markChange();
        AOFifo aOFifo = AOToolkit.createFifo(this.delay + 1);
        MMArray mMArray2 = new MMArray(n2, 0.0f);
        try {
            int n3;
            if (this.backward) {
                for (n3 = 0; n3 < n2; ++n3) {
                    mMArray2.set(n2 - 1 - n3, mMArray.get(n3 + n));
                }
            } else {
                mMArray2.copy(mMArray, n, 0, n2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                float f2;
                if (this.delay < aOFifo.getActualSize()) {
                    f2 = aOFifo.pickFromHead(this.delay - 1) + mMArray2.get(n3) * -this.gain;
                    aOFifo.put(mMArray2.get(n3) + f2 * this.gain);
                    mMArray2.set(n3, f2);
                    continue;
                }
                f2 = mMArray2.get(n3) * -this.gain;
                aOFifo.put(mMArray2.get(n3) + f2 * this.gain);
                mMArray2.set(n3, f2);
            }
            float f3 = AOToolkit.rmsAverage(mMArray2, 0, n2);
            AOToolkit.multiply(mMArray2, 0, n2, f / f3);
            if (this.backward) {
                for (int i = n; i < n + n2; ++i) {
                    float f4 = mMArray.get(i) * this.dry + mMArray2.get(n2 - 1 - i - n) * this.wet;
                    mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f4));
                }
            } else {
                for (int i = n; i < n + n2; ++i) {
                    float f5 = mMArray.get(i) * this.dry + mMArray2.get(i - n) * this.wet;
                    mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f5));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

