/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;

public class AOPitchShift
extends AOperation {
    private float shiftFactor;
    private MMArray buffer;
    private MMArray transition;

    public AOPitchShift(int n, float f) {
        this(1.0f, n, f);
    }

    public AOPitchShift(float f, int n, float f2) {
        this.shiftFactor = f;
        this.buffer = new MMArray(n, 0.0f);
        this.transition = new MMArray((int)((float)n * f2), 0.0f);
        for (int i = 0; i < this.transition.getLength(); ++i) {
            if (i >= this.transition.getLength() / 2) {
                this.transition.set(i, 1.0f);
                continue;
            }
            this.transition.set(i, 0.0f);
        }
        AOToolkit.smooth(this.transition, 0, this.transition.getLength(), this.transition.getLength() / 8);
    }

    @Override
    public void operate(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        this.performPitchShift(aChannelSelection, aChannelSelection2);
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        this.performPitchShift(aChannelSelection, null);
    }

    private void performPitchShift(AChannelSelection aChannelSelection, AChannelSelection aChannelSelection2) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        try {
            MMArray mMArray2 = new MMArray(n2, 0.0f);
            mMArray2.copy(mMArray, n, 0, mMArray2.getLength());
            int n3 = this.buffer.getLength() - this.transition.getLength();
            int n4 = this.transition.getLength();
            for (int i = n; i < n + n2; i += n3) {
                float f;
                int n5;
                for (n5 = 0; n5 < this.buffer.getLength(); ++n5) {
                    f = aChannelSelection2 != null ? (float)(i - n) + (float)n5 * aChannelSelection2.getChannel().getSamples().get(i) : (float)(i - n) + (float)n5 * this.shiftFactor;
                    if (f < (float)n2) {
                        this.buffer.set(n5, AOToolkit.interpolate3(mMArray2, f));
                        continue;
                    }
                    this.buffer.set(n5, AOToolkit.interpolate3(mMArray2, n5));
                }
                for (n5 = 0; n5 < this.buffer.getLength(); ++n5) {
                    if (i + n5 >= n + n2) continue;
                    if (n5 < n4) {
                        float f2 = this.transition.get(n5);
                        int n6 = this.transition.getLength() / 5;
                        float f3 = n5 < n6 ? 0.0f : this.transition.get(n5 - n6);
                        f = mMArray.get(i + n5) * (1.0f - f3) + this.buffer.get(n5) * f2;
                    } else {
                        f = this.buffer.get(n5);
                    }
                    mMArray.set(i + n5, aChannelSelection.mixIntensity(i + n5, mMArray.get(i + n5), f));
                }
            }
            AOToolkit.applyZeroCross(mMArray, n);
            AOToolkit.applyZeroCross(mMArray, n + n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

